/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.compiler.BlackboxUnitResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.DelegatingUnitResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.ResolverUtils;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitContents;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIUnitResolver
extends DelegatingUnitResolver {
    private List<URI> fBaseURIs;

    public URIUnitResolver(List<URI> baseURL) {
        if (baseURL == null || baseURL.contains(null)) {
            throw new IllegalArgumentException();
        }
        this.fBaseURIs = new ArrayList<URI>(baseURL.size());
        for (URI uri : baseURL) {
            URI normalizedURI = uri;
            if (!normalizedURI.hasTrailingPathSeparator()) {
                normalizedURI = normalizedURI.appendSegment("");
            }
            this.fBaseURIs.add(normalizedURI);
        }
        this.setParent(BlackboxUnitResolver.DEFAULT);
    }

    @Override
    protected UnitProxy doResolveUnit(String qualifiedName) {
        for (URI baseURI : this.fBaseURIs) {
            UnitProxy unit = this.doResolveUnit(baseURI, qualifiedName);
            if (unit == null) continue;
            return unit;
        }
        return null;
    }

    private UnitProxy doResolveUnit(URI baseURI, String qualifiedName) {
        URI unitURI;
        String[] nameSegments;
        String namespace;
        block4: {
            try {
                String unitFilePath;
                namespace = null;
                nameSegments = ResolverUtils.getNameSegments(qualifiedName);
                if (nameSegments.length > 1) {
                    namespace = ResolverUtils.toQualifiedName(nameSegments, 0, nameSegments.length - 2);
                }
                if (URIConverter.INSTANCE.exists(unitURI = URI.createURI((String)(unitFilePath = ResolverUtils.toNamespaceRelativeUnitFilePath(qualifiedName))).resolve(baseURI), Collections.EMPTY_MAP)) break block4;
                return null;
            }
            catch (RuntimeException e) {
                QvtPlugin.getDefault().log(e);
                return null;
            }
        }
        String unitName = nameSegments[nameSegments.length - 1];
        return new Unit(namespace, unitName, unitURI);
    }

    public static UnitProxy getUnit(URI unitURI) {
        URI baseURI = unitURI.segmentCount() > 1 ? unitURI.trimSegments(1) : URI.createURI((String)"/");
        return new URIUnitResolver(Collections.singletonList(baseURI)).doResolveUnit(unitURI.trimFileExtension().lastSegment());
    }

    private final class Unit
    extends UnitProxy {
        private final URI fURI;

        private Unit(String namespace, String unitName, URI unitURI) {
            super(namespace, unitName, unitURI);
            this.fURI = unitURI;
        }

        public int getContentType() {
            return 0;
        }

        public UnitContents getContents() throws IOException {
            return new UnitContents.CSTContents(){

                public Reader getContents() throws IOException {
                    InputStream is = URIConverter.INSTANCE.createInputStream(Unit.this.fURI);
                    return new InputStreamReader(is, "UTF-8");
                }
            };
        }

        public UnitResolver getResolver() {
            return URIUnitResolver.this;
        }
    }
}

