/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.ui.trace.common;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.trace.TraceViewContentProvider;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.trace.TraceViewLabelProvider;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.trace.actions.OpenEObjectAction;
import org.eclipse.m2m.internal.qvt.oml.trace.Trace;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchPart;

public class TraceWorkbenchPart {
    private TreeViewer myTraceViewer;
    private final IWorkbenchPart myWorkbenchPart;

    public TraceWorkbenchPart(IWorkbenchPart workbenchPart) {
        this.myWorkbenchPart = workbenchPart;
    }

    public void createPartControl(Composite parent) {
        Tree tree = new Tree(parent, 2820);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 200;
        tree.setLayoutData((Object)gridData);
        tree.setFont(parent.getFont());
        this.myTraceViewer = new TreeViewer(tree);
        TraceViewContentProvider contentProvider = new TraceViewContentProvider();
        this.myTraceViewer.setContentProvider((IContentProvider)contentProvider);
        TraceViewLabelProvider labelProvider = new TraceViewLabelProvider();
        this.myTraceViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.myTraceViewer.setUseHashlookup(true);
        this.hookDoubleClickAction();
    }

    public Trace getInput() {
        return (Trace)this.myTraceViewer.getInput();
    }

    public void setInput(Trace trace) {
        this.myTraceViewer.setInput((Object)trace);
    }

    public void setSelection(Object objToSelect) {
        this.myTraceViewer.setSelection((ISelection)new StructuredSelection(objToSelect));
    }

    public TreeViewer getViewer() {
        return this.myTraceViewer;
    }

    private void hookDoubleClickAction() {
        final OpenEObjectAction openEObjectAction = new OpenEObjectAction(this.myWorkbenchPart.getSite().getPage(), this.myTraceViewer.getTree());
        this.myTraceViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                openEObjectAction.run();
            }
        });
    }
}

