/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.parser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.m2m.internal.qvt.oml.ast.env.InternalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.expressions.Constructor;
import org.eclipse.m2m.internal.qvt.oml.expressions.DirectionKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelType;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.eclipse.m2m.internal.qvt.oml.expressions.VarParameter;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.PathNameCS;
import org.eclipse.ocl.cst.TypeCS;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.lpg.BasicEnvironment;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.ocl.types.PrimitiveType;
import org.eclipse.ocl.util.OCLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtOperationalUtil {
    private QvtOperationalUtil() {
    }

    public static String getStringRepresentation(PathNameCS pathName, String pathSeparator) {
        return QvtOperationalParserUtil.getStringRepresentation(pathName, pathSeparator);
    }

    public static String getStringRepresentation(TypeCS typeCS) {
        return QvtOperationalParserUtil.getStringRepresentation(typeCS);
    }

    public static boolean isInvalid(Object value, EvaluationEnvironment<?, ?, ?, ?, ?> evalEnv) {
        InternalEvaluationEnv internEnv = (InternalEvaluationEnv)OCLUtil.getAdapter(evalEnv, InternalEvaluationEnv.class);
        return internEnv != null && value == internEnv.getInvalid();
    }

    public static Object getInvalid(EvaluationEnvironment<?, ?, ?, ?, ?> evalEnv) {
        InternalEvaluationEnv internEnv = (InternalEvaluationEnv)OCLUtil.getAdapter(evalEnv, InternalEvaluationEnv.class);
        return internEnv != null ? internEnv.getInvalid() : null;
    }

    public static boolean isUndefined(Object value, EvaluationEnvironment<?, ?, ?, ?, ?> evalEnv) {
        return value == null || QvtOperationalUtil.isInvalid(value, evalEnv);
    }

    public static boolean isCreateFromStringSupported(EClassifier type) {
        return QvtOperationalUtil.isPrimitiveType(type) || type instanceof EDataType;
    }

    public static boolean isPrimitiveType(Object type) {
        return type instanceof PrimitiveType;
    }

    public static boolean isInstantiable(EClass cls) {
        return cls != null && !cls.isAbstract() && !cls.isInterface();
    }

    public static boolean isInstantiable(EClassifier classifier) {
        if (classifier instanceof EClass) {
            return QvtOperationalUtil.isInstantiable((EClass)classifier);
        }
        return false;
    }

    public static boolean isMappingOperation(EOperation operation) {
        return operation instanceof MappingOperation;
    }

    public static boolean isConstructorOperation(EOperation operation) {
        return operation instanceof Constructor;
    }

    public static boolean isImperativeOperation(EOperation operation) {
        return operation instanceof ImperativeOperation;
    }

    public static boolean isModelParamEqual(ModelParameter param, ModelParameter importedParam, boolean isStrictCompare) {
        if (param.getKind() == DirectionKind.IN && importedParam.getKind() != DirectionKind.IN) {
            return false;
        }
        if (!isStrictCompare) {
            return true;
        }
        ModelType modelType = QvtOperationalUtil.getModelType(param);
        ModelType importedModelType = QvtOperationalUtil.getModelType(importedParam);
        if (modelType == null || importedModelType == null) {
            return false;
        }
        return QvtOperationalUtil.isCompatibleModelType(modelType, importedModelType);
    }

    public static boolean isCompatibleModelType(ModelType sourceType, ModelType targetType) {
        if (sourceType == targetType) {
            return true;
        }
        return sourceType.getMetamodel().containsAll(targetType.getMetamodel());
    }

    public static ModelType getModelType(ModelParameter modelParameter) {
        EClassifier eType = modelParameter.getEType();
        return eType instanceof ModelType ? (ModelType)eType : null;
    }

    public static boolean isAbstract(EClassifier eClassifier) {
        if (eClassifier instanceof EClass) {
            EClass eClass = (EClass)eClassifier;
            return eClass.isAbstract() || eClass.isInterface();
        }
        return false;
    }

    public static boolean hasAbstractOutputParameter(ImperativeOperation operation) {
        for (VarParameter nextParam : operation.getResult()) {
            if (nextParam.getEType() == null || !QvtOperationalUtil.isAbstract(nextParam.getEType())) continue;
            return true;
        }
        for (EParameter eParam : operation.getEParameters()) {
            VarParameter varParam;
            if (!(eParam instanceof VarParameter) || (varParam = (VarParameter)eParam).getEType() == null || !QvtOperationalUtil.isAbstract(varParam.getEType())) continue;
            return true;
        }
        return false;
    }

    public static void reportError(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env, String message, CSTNode node) {
        ((BasicEnvironment)OCLUtil.getAdapter(env, BasicEnvironment.class)).analyzerError(message, node.eClass().getName(), (Object)node);
    }

    public static void reportError(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env, String message, int startOffset, int endOffset) {
        ((BasicEnvironment)OCLUtil.getAdapter(env, BasicEnvironment.class)).analyzerError(message, "unknown", startOffset, endOffset);
    }

    public static void reportWarning(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env, String message, CSTNode node) {
        ((BasicEnvironment)OCLUtil.getAdapter(env, BasicEnvironment.class)).analyzerWarning(message, node.eClass().getName(), (Object)node);
    }

    public static void reportWarning(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env, String message, int startOffset, int endOffset) {
        ProblemHandler problemHandler = (ProblemHandler)OCLUtil.getAdapter(env, ProblemHandler.class);
        if (problemHandler != null) {
            problemHandler.analyzerProblem(ProblemHandler.Severity.WARNING, message, "unknown", startOffset, endOffset);
        }
    }

    public static List<ModelType> collectValidModelParamaterTypes(OperationalTransformation transformation) {
        ArrayList<ModelType> types = new ArrayList<ModelType>(transformation.getModelParameter().size());
        for (ModelParameter parameter : transformation.getModelParameter()) {
            EClassifier paramType = (EClassifier)parameter.getType();
            if (!(paramType instanceof ModelType)) continue;
            types.add((ModelType)paramType);
        }
        return types;
    }
}

