/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.outline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.cst.ClassifierDefCS;
import org.eclipse.m2m.internal.qvt.oml.cst.ImportCS;
import org.eclipse.m2m.internal.qvt.oml.cst.LocalPropertyCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingMethodCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingModuleCS;
import org.eclipse.m2m.internal.qvt.oml.cst.ModelTypeCS;
import org.eclipse.m2m.internal.qvt.oml.cst.ModulePropertyCS;
import org.eclipse.m2m.internal.qvt.oml.cst.TagCS;
import org.eclipse.m2m.internal.qvt.oml.cst.UnitCS;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.outline.OutlineNode;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.outline.QvtOutlineLabelProvider;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.PathNameCS;

public class QvtOutlineInput {
    private CompiledUnit myUnit;
    private Object[] myChildren;

    public QvtOutlineInput() {
        this(null);
    }

    public QvtOutlineInput(CompiledUnit unit) {
        this.myUnit = unit;
    }

    public void compilationUnitUpdated(CompiledUnit unit) {
        this.myUnit = unit;
        this.myChildren = null;
    }

    public Object[] getChildren() {
        if (this.myChildren == null) {
            ArrayList<ModuleDependentNode> children = new ArrayList<ModuleDependentNode>();
            if (this.getUnitCST() != null) {
                children.addAll(Arrays.asList(new ImportsNode(), new MetamodelsNode(), new TagsNode()));
                for (MappingModuleCS nextModule : this.getUnitCST().getModules()) {
                    children.add(new ModuleNode(nextModule, QvtOutlineInput.getModuleNodeIdentity(nextModule)));
                }
            }
            this.myChildren = children.toArray();
        }
        return this.myChildren;
    }

    private static String getModuleNodeIdentity(MappingModuleCS moduleCS) {
        return moduleCS != null ? QvtOutlineLabelProvider.getMappingModuleLabel(moduleCS) : "";
    }

    private UnitCS getUnitCST() {
        return this.myUnit != null ? this.myUnit.getUnitCST() : null;
    }

    private final class ImportsNode
    extends ModuleDependentNode {
        public ImportsNode() {
            super("imports", QvtOutlineInput.this, 1);
        }

        @Override
        protected List<OutlineNode> doGetChildren() {
            ArrayList<OutlineNode> result = new ArrayList<OutlineNode>();
            if (QvtOutlineInput.this.getUnitCST() == null) {
                return result;
            }
            for (ImportCS nextImportCS : QvtOperationalParserUtil.getImports((UnitCS)QvtOutlineInput.this.getUnitCST())) {
                PathNameCS importQName = nextImportCS.getPathNameCS();
                if (importQName == null) continue;
                OutlineNode childNode = new OutlineNode(QvtOutlineLabelProvider.getImportLabel(importQName), this, 10, (CSTNode)importQName);
                result.add(childNode);
            }
            return result;
        }
    }

    private final class MetamodelsNode
    extends ModuleDependentNode {
        public MetamodelsNode() {
            super("metamodels", QvtOutlineInput.this, 3);
        }

        @Override
        protected List<OutlineNode> doGetChildren() {
            ArrayList<OutlineNode> result = new ArrayList<OutlineNode>();
            if (QvtOutlineInput.this.myUnit.getUnitCST() == null) {
                return result;
            }
            for (ModelTypeCS modelTypeCS : QvtOperationalParserUtil.getModelTypes((UnitCS)QvtOutlineInput.this.getUnitCST())) {
                if (modelTypeCS == null || modelTypeCS.getPackageRefs().isEmpty()) continue;
                OutlineNode childNode = new OutlineNode(QvtOutlineLabelProvider.getMetamodelLabel(modelTypeCS), this, 2, (CSTNode)modelTypeCS);
                result.add(childNode);
            }
            return result;
        }
    }

    private abstract class ModuleDependentNode
    extends OutlineNode {
        protected ModuleDependentNode(String identity, Object parent, int type) {
            super(identity, parent, type);
        }

        protected ModuleDependentNode(String identity, Object parent, int type, CSTNode syntaxElement) {
            super(identity, parent, type, syntaxElement);
        }

        @Override
        public final List<OutlineNode> getChildren() {
            if (QvtOutlineInput.this.getUnitCST() == null) {
                return Collections.emptyList();
            }
            return this.doGetChildren();
        }

        protected abstract List<OutlineNode> doGetChildren();
    }

    private final class ModuleNode
    extends ModuleDependentNode {
        private MappingModuleCS moduleCS;

        public ModuleNode(MappingModuleCS moduleCS, String identity) {
            super(identity, QvtOutlineInput.this, 0);
            this.moduleCS = moduleCS;
        }

        @Override
        public CSTNode getSyntaxElement() {
            return this.moduleCS.getHeaderCS();
        }

        @Override
        protected List<OutlineNode> doGetChildren() {
            OutlineNode childNode;
            ArrayList<OutlineNode> result = new ArrayList<OutlineNode>();
            if (QvtOutlineInput.this.myUnit == null) {
                return result;
            }
            for (ClassifierDefCS classifierDefCS : this.moduleCS.getClassifierDefCS()) {
                childNode = new OwnedClassNode(classifierDefCS);
                result.add(childNode);
            }
            for (ModulePropertyCS prop : this.moduleCS.getProperties()) {
                childNode = new OutlineNode(QvtOutlineLabelProvider.getPropertyLabel(prop), this, 6, (CSTNode)prop);
                result.add(childNode);
            }
            for (MappingMethodCS method : this.moduleCS.getMethods()) {
                childNode = new OutlineNode(QvtOutlineLabelProvider.getMappingRuleLabel(method), this, 8, (CSTNode)method);
                result.add(childNode);
            }
            return result;
        }
    }

    private final class OwnedClassNode
    extends ModuleDependentNode {
        private ClassifierDefCS fClassifier;

        public OwnedClassNode(ClassifierDefCS classifierCS) {
            super(QvtOutlineLabelProvider.getClassifierLabel(classifierCS), QvtOutlineInput.this, 11, (CSTNode)classifierCS);
            this.fClassifier = classifierCS;
        }

        @Override
        protected List<OutlineNode> doGetChildren() {
            ArrayList<OutlineNode> result = new ArrayList<OutlineNode>();
            if (QvtOutlineInput.this.myUnit.getUnitCST() == null) {
                return result;
            }
            for (LocalPropertyCS prop : this.fClassifier.getProperties()) {
                OutlineNode childNode = new OutlineNode(QvtOutlineLabelProvider.getPropertyLabel((ModulePropertyCS)prop), this, 6, (CSTNode)prop);
                result.add(childNode);
            }
            return result;
        }
    }

    private final class TagsNode
    extends ModuleDependentNode {
        public TagsNode() {
            super("tags", QvtOutlineInput.this, 5);
        }

        @Override
        protected List<OutlineNode> doGetChildren() {
            ArrayList<OutlineNode> result = new ArrayList<OutlineNode>();
            if (QvtOutlineInput.this.getUnitCST() == null) {
                return result;
            }
            for (MappingModuleCS moduleCS : QvtOutlineInput.this.getUnitCST().getModules()) {
                for (TagCS next : moduleCS.getTags()) {
                    OutlineNode childNode = new OutlineNode(QvtOutlineLabelProvider.getTagLabel(next), this, 4, (CSTNode)next);
                    result.add(childNode);
                }
            }
            return result;
        }
    }
}

