/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.jdt.runtime.blackbox;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.blackbox.BlackboxUnitDescriptor;
import org.eclipse.m2m.internal.qvt.oml.blackbox.ResolutionContext;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.JavaBlackboxProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.URIUtils;
import org.eclipse.m2m.internal.qvt.oml.jdt.runtime.blackbox.JdtModuleHandle;
import org.eclipse.m2m.internal.qvt.oml.jdt.runtime.blackbox.ProjectClassLoader;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.ProjectDependencyTracker;

public class JdtBlackboxProvider
extends JavaBlackboxProvider {
    public static final String URI_BLACKBOX_JDT_QUERY = "jdt";
    private static Map<IProject, Map<String, JdtDescriptor>> descriptors = new HashMap<IProject, Map<String, JdtDescriptor>>();

    public Collection<? extends BlackboxUnitDescriptor> getUnitDescriptors(ResolutionContext resolutionContext) {
        IProject project = this.getProject(resolutionContext);
        if (project == null) {
            return Collections.emptyList();
        }
        Set referencedProjects = ProjectDependencyTracker.getAllReferencedProjects((IProject)project, (boolean)true);
        ArrayList<IProject> projects = new ArrayList<IProject>(referencedProjects.size() + 1);
        projects.add(project);
        projects.addAll(referencedProjects);
        ArrayList<BlackboxUnitDescriptor> descriptors = new ArrayList<BlackboxUnitDescriptor>();
        for (IProject p : projects) {
            List<String> classes = this.getAllClasses(p, resolutionContext);
            for (String qualifiedName : classes) {
                BlackboxUnitDescriptor jdtUnitDescriptor = this.getJdtUnitDescriptor(p, qualifiedName);
                if (jdtUnitDescriptor == null) continue;
                descriptors.add(jdtUnitDescriptor);
            }
        }
        return descriptors;
    }

    public BlackboxUnitDescriptor getUnitDescriptor(String qualifiedName, ResolutionContext resolutionContext) {
        IProject project = this.getProject(resolutionContext);
        if (project == null) {
            return null;
        }
        return this.getJdtUnitDescriptor(project, qualifiedName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BlackboxUnitDescriptor getJdtUnitDescriptor(IProject project, String qualifiedName) {
        Map<String, JdtDescriptor> projectDescriptors = descriptors.get(project);
        if (projectDescriptors != null) {
            if (projectDescriptors.containsKey(qualifiedName)) {
                return (BlackboxUnitDescriptor)projectDescriptors.get(qualifiedName);
            }
        } else {
            projectDescriptors = new HashMap<String, JdtDescriptor>();
            descriptors.put(project, projectDescriptors);
        }
        try {
            if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
                return null;
            }
        }
        catch (CoreException e) {
            return null;
        }
        final IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            ProjectClassLoader loader = ProjectClassLoader.getProjectClassLoader(javaProject);
            try {
                Class<?> moduleJavaClass = loader.loadClass(qualifiedName);
                JdtDescriptor descriptor = new JdtDescriptor(this, qualifiedName, moduleJavaClass){

                    protected String getFragment() {
                        return javaProject.getElementName();
                    }
                };
                projectDescriptors.put(qualifiedName, descriptor);
                return descriptor;
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            catch (NoClassDefFoundError e) {
                return null;
            }
        }
        catch (CoreException e2) {
            QvtPlugin.error((Throwable)e2);
            return null;
        }
        catch (MalformedURLException e3) {
            QvtPlugin.error((Throwable)e3);
        }
        return null;
    }

    private IProject getProject(ResolutionContext resolutionContext) {
        IResource resource = URIUtils.getResource((URI)resolutionContext.getURI());
        if (resource == null || !resource.exists()) {
            return null;
        }
        return resource.getProject();
    }

    private List<String> getAllClasses(IProject project, final ResolutionContext context) {
        final ArrayList<String> classes = new ArrayList<String>();
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IResource folder = ResourcesPlugin.getWorkspace().getRoot().findMember(javaProject.getOutputLocation());
            if (folder != null) {
                final String folderPath = folder.getFullPath().toString();
                folder.accept(new IResourceProxyVisitor(){

                    public boolean visit(IResourceProxy proxy) throws CoreException {
                        if (proxy.getType() == 2) {
                            return true;
                        }
                        if (proxy.getType() == 1 && proxy.getName().endsWith(".class") && !proxy.getName().contains("$")) {
                            String filePath = proxy.requestFullPath().toString();
                            if ((filePath = filePath.substring(0, filePath.length() - 6)).startsWith(folderPath)) {
                                filePath = filePath.substring(folderPath.length() + 1);
                            }
                            String fqn = filePath.replace('/', '.');
                            if (context.getImports().isEmpty() || context.getImports().contains(fqn)) {
                                classes.add(fqn);
                            }
                        }
                        return false;
                    }
                }, 0);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return classes;
    }

    public void cleanup() {
        ProjectClassLoader.resetAllProjectClassLoaders();
        descriptors.clear();
    }

    @Deprecated
    public static void clearDescriptors(IProject project) {
        descriptors.remove(project);
    }

    static boolean requiresReset(IJavaProject javaProject) {
        return descriptors.containsKey(javaProject.getProject()) || ProjectClassLoader.isProjectClassLoaderExisting(javaProject);
    }

    static void reset(IJavaProject javaProject) {
        ProjectClassLoader.resetProjectClassLoader(javaProject);
        descriptors.remove(javaProject.getProject());
    }

    private class JdtDescriptor
    extends JavaBlackboxProvider.JavaUnitDescriptor {
        private final Class<?> fModuleJavaClass;
        private volatile int hashCode;

        public JdtDescriptor(String unitQualifiedName, Class<?> moduleJavaClass) {
            super((JavaBlackboxProvider)JdtBlackboxProvider.this, unitQualifiedName);
            this.addModuleHandle(new JdtModuleHandle(unitQualifiedName, moduleJavaClass));
            this.fModuleJavaClass = moduleJavaClass;
        }

        protected String getUnitQuery() {
            return JdtBlackboxProvider.URI_BLACKBOX_JDT_QUERY;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof JdtDescriptor)) {
                return false;
            }
            JdtDescriptor other = (JdtDescriptor)((Object)obj);
            return this.getQualifiedName().equals(other.getQualifiedName()) && this.fModuleJavaClass.equals(other.fModuleJavaClass);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                result = 17;
                result = 31 * result + this.getQualifiedName().hashCode();
                this.hashCode = result = 31 * result + this.fModuleJavaClass.hashCode();
            }
            return result;
        }
    }
}

