/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.tests.qvt.oml.debugger;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.m2m.internal.tests.qvt.oml.debugger.MarkedTransformation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class Script {
    private final List<Command> myCommandList = new ArrayList<Command>();
    private Iterator<Command> myIterator;
    private final MarkedTransformation myMarkedTrans;
    private String myModule;
    private static final String RESUME_STRING = "resume";
    private static final String STEP_OVER_STRING = "stepOver";
    private static final String STEP_INTO_STRING = "stepInto";
    private static final String STEP_RETURN_STRING = "return";
    private static final String BREAKPOINT_STRING = "breakpoint";
    private static final String NONE_STRING = "none";
    public static final int RESUME_CODE = 1;
    public static final int STEP_OVER_CODE = 2;
    public static final int STEP_INTO_CODE = 3;
    public static final int STEP_RETURN_CODE = 4;
    public static final int BREAKPOINT_CODE = 5;
    public static final int NONE_CODE = 0;
    public static final int INVALID_CODE = -1;
    private static final String LINE = "line";
    private static final String CAUSE = "cause";
    private static final String UNKNOWN_COMMAND_MESSAGE = "Unknown command: {0}";
    private static final String UNKNOWN_NAME_MESSAGE = "Unknown marker name: {0} in {1}";
    private static final String INVALID_CAUSE_MESSAGE = "Invalid cause: {0} line=\"{1}\"";
    private static final String INVALID_COMMAND_MESSAGE = "Invalid command: {0}";

    public Script(String fileName, MarkedTransformation markedTrans) throws Exception {
        this.myMarkedTrans = markedTrans;
        this.myModule = fileName;
        this.parseFile(fileName);
        this.reset();
    }

    private void parseFile(String fileName) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(new ErrorHandler(){

            @Override
            public void error(SAXParseException arg0) throws SAXException {
                System.err.println(arg0);
            }

            @Override
            public void fatalError(SAXParseException arg0) throws SAXException {
                System.err.println(arg0);
            }

            @Override
            public void warning(SAXParseException arg0) throws SAXException {
                System.err.println(arg0);
            }
        });
        Document document = builder.parse(fileName);
        NodeList commands = document.getDocumentElement().getChildNodes();
        int prevCode = -1;
        int i = 0;
        while (i < commands.getLength()) {
            Node node = commands.item(i);
            if (node.getNodeType() == 1) {
                String command = node.getNodeName();
                int code = this.commandToCode(command);
                if (code == 5) {
                    throw new ScriptException(MessageFormat.format(INVALID_COMMAND_MESSAGE, command));
                }
                String markerName = node.getAttributes().getNamedItem(LINE).getNodeValue();
                int lineNumber = -1;
                if (Character.isDigit(markerName.charAt(0))) {
                    lineNumber = Integer.valueOf(markerName);
                } else {
                    MarkedTransformation.LineMarker myRec = this.myMarkedTrans.getLineMarker(markerName);
                    if (myRec == null) {
                        throw new ScriptException(MessageFormat.format(UNKNOWN_NAME_MESSAGE, markerName, this.myModule));
                    }
                    lineNumber = myRec.lineNumber;
                }
                Node causeNode = node.getAttributes().getNamedItem(CAUSE);
                int cause = this.commandToCode(causeNode.getNodeValue());
                if (cause == 0 && (cause = prevCode) == -1) {
                    throw new Exception(MessageFormat.format(INVALID_CAUSE_MESSAGE, command, markerName));
                }
                this.myCommandList.add(new Command(node.toString(), code, lineNumber, cause));
                prevCode = code;
            }
            ++i;
        }
    }

    private int commandToCode(String command) throws ScriptException {
        if (command.equals(RESUME_STRING)) {
            return 1;
        }
        if (command.equals(STEP_OVER_STRING)) {
            return 2;
        }
        if (command.equals(STEP_INTO_STRING)) {
            return 3;
        }
        if (command.equals(STEP_RETURN_STRING)) {
            return 4;
        }
        if (command.equals(BREAKPOINT_STRING)) {
            return 5;
        }
        if (command.equals(NONE_STRING)) {
            return 0;
        }
        throw new ScriptException(MessageFormat.format(UNKNOWN_COMMAND_MESSAGE, command));
    }

    public void reset() {
        this.myIterator = this.myCommandList.iterator();
    }

    public boolean hasNextCommand() {
        return this.myIterator.hasNext();
    }

    public Command nextCommand() {
        return this.myIterator.next();
    }

    public class Command {
        public final String command;
        public final int code;
        public final int lineNumber;
        public final int cause;

        public Command(String command, int code, int lineNumber, int cause) {
            this.command = command;
            this.code = code;
            this.lineNumber = lineNumber;
            this.cause = cause;
        }

        public int getEventDetail() {
            switch (this.cause) {
                case 2: {
                    return 2;
                }
                case 3: {
                    return 1;
                }
                case 4: {
                    return 4;
                }
                case 5: {
                    return 16;
                }
            }
            return 0;
        }

        public String toString() {
            return this.command;
        }
    }

    public class ScriptException
    extends Exception {
        private static final long serialVersionUID = 380437041238179652L;

        public ScriptException(String s) {
            super(s);
        }
    }
}

