/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.tests.qvt.oml.ui.editor;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.m2m.tests.qvt.oml.util.SourceAnnotationReader;

public class TestSourceAnnotationReader
extends TestCase {
    public TestSourceAnnotationReader(String name) {
        super(name);
    }

    public void testAnnotations() throws Exception {
        String source = "Aa/*<pos id='idval'/>*/Bb Cc/*<w code='5' refid='idval'>*/{contents}/*</w>*/Dd";
        SourceAnnotationReader reader = new SourceAnnotationReader(source);
        List annotations = reader.getAnnotations();
        TestSourceAnnotationReader.assertEquals((int)2, (int)annotations.size());
        SourceAnnotationReader.AnnotationData a1 = (SourceAnnotationReader.AnnotationData)annotations.get(0);
        TestSourceAnnotationReader.assertEquals((String)"pos", (String)a1.getName());
        TestSourceAnnotationReader.assertEquals((String)"idval", (String)a1.getAttrValue("id"));
        TestSourceAnnotationReader.assertEquals((int)reader.getSource().indexOf("Bb"), (int)a1.getAnnotatedRegion().getOffset());
        TestSourceAnnotationReader.assertEquals((int)a1.getAnnotatedRegion().getLength(), (int)0);
        SourceAnnotationReader.AnnotationData a2 = (SourceAnnotationReader.AnnotationData)annotations.get(1);
        TestSourceAnnotationReader.assertEquals((String)"w", (String)a2.getName());
        TestSourceAnnotationReader.assertEquals((String)"5", (String)a2.getAttrValue("code"));
        TestSourceAnnotationReader.assertEquals((String)"idval", (String)a2.getAttrValue("refid"));
        TestSourceAnnotationReader.assertEquals((String)"{contents}", (String)TestSourceAnnotationReader.getRegionContents(reader.getSource(), a2.getAnnotatedRegion()));
        TestSourceAnnotationReader.assertEquals((int)"{contents}".length(), (int)a2.getAnnotatedRegion().getLength());
        TestSourceAnnotationReader.assertEquals((char)'{', (char)reader.getSource().charAt(a2.getAnnotatedRegion().getOffset()));
    }

    private static String getRegionContents(String source, SourceAnnotationReader.RegionInfo region) {
        return source.substring(region.getOffset(), region.getOffset() + region.getLength());
    }
}

