/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.emf.util.ui.metamodel;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.EmfUtilUiPlugin;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.metamodel.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class MetamodelImageRegistry {
    public static final MetamodelImageRegistry INSTANCE = new MetamodelImageRegistry();
    private final Map<String, URL> myMetamodelURIToImageURLMap = new HashMap<String, URL>();
    private static final String EXTENSTION_POINT_ID = "metamodelImages";
    private static final String METAMODEL_IMAGE = "metamodelImage";
    private static final String METAMODEL_IMAGE__METAMODEL_URI = "metamodelURI";
    private static final String METAMODEL_IMAGE__IMAGE_PATH = "imagePath";
    private static final String IMAGE_KEY_PREFIX = "metamodelImage";

    private MetamodelImageRegistry() {
        IConfigurationElement[] metamodelImageElements;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.m2m.qvt.oml.emf.util.ui", EXTENSTION_POINT_ID);
        if (extensionPoint == null) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = metamodelImageElements = extensionPoint.getConfigurationElements();
        int n = metamodelImageElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement metamodelImageElement = iConfigurationElementArray[n2];
            if ("metamodelImage".equals(metamodelImageElement.getName())) {
                this.readMetamodelImage(metamodelImageElement);
            } else {
                MetamodelImageRegistry.log(4, NLS.bind((String)Messages.MetamodelImageRegistry_elementError, (Object)"metamodelImage", (Object)metamodelImageElement.getName()));
            }
            ++n2;
        }
    }

    public Image getImage(EPackage metamodel) {
        if (metamodel == null) {
            throw new IllegalArgumentException();
        }
        String metamodelURI = metamodel.getNsURI();
        return metamodelURI != null ? this.getImage(metamodelURI) : null;
    }

    public Image getImage(String metamodelURI) {
        if (metamodelURI == null) {
            throw new IllegalArgumentException();
        }
        String imageKey = this.getImageKey(metamodelURI);
        ImageRegistry imageRegistry = EmfUtilUiPlugin.getDefault().getImageRegistry();
        Image image = imageRegistry.get(imageKey);
        if (image == null) {
            URL url = this.myMetamodelURIToImageURLMap.get(metamodelURI);
            if (url == null) {
                return null;
            }
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)url);
            imageRegistry.put(imageKey, imageDescriptor);
            image = imageRegistry.get(imageKey);
        }
        return image;
    }

    private void readMetamodelImage(IConfigurationElement metamodelImageElement) {
        URL url;
        String metamodelURI = metamodelImageElement.getAttribute(METAMODEL_IMAGE__METAMODEL_URI);
        if (metamodelURI == null) {
            MetamodelImageRegistry.log(4, NLS.bind((String)Messages.MetamodelImageRegistry_elementAttributeError, (Object)"metamodelImage", (Object)METAMODEL_IMAGE__METAMODEL_URI));
            return;
        }
        String imagePath = metamodelImageElement.getAttribute(METAMODEL_IMAGE__IMAGE_PATH);
        if (imagePath == null) {
            MetamodelImageRegistry.log(4, NLS.bind((String)Messages.MetamodelImageRegistry_elementAttributeError, (Object)"metamodelImage", (Object)METAMODEL_IMAGE__IMAGE_PATH));
            return;
        }
        Bundle bundle = Platform.getBundle((String)metamodelImageElement.getNamespaceIdentifier());
        if (bundle == null) {
            MetamodelImageRegistry.log(4, Messages.MetamodelImageRegistry_imageURLError);
            return;
        }
        URL baseURL = bundle.getEntry("/");
        try {
            url = new URL(baseURL, imagePath);
        }
        catch (MalformedURLException e) {
            MetamodelImageRegistry.log(4, Messages.MetamodelImageRegistry_imageURLError, e);
            return;
        }
        this.myMetamodelURIToImageURLMap.put(metamodelURI, url);
    }

    private String getImageKey(String metamodelURI) {
        return "metamodelImage" + metamodelURI;
    }

    private static void log(int severity, String message) {
        MetamodelImageRegistry.log(severity, message, null);
    }

    private static void log(int severity, String message, Throwable t) {
        EmfUtilUiPlugin.getDefault().getLog().log((IStatus)new Status(severity, "org.eclipse.m2m.qvt.oml.emf.util.ui", 0, message, t));
    }
}

