/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.helper;

import java.util.MissingResourceException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class EObjectLabelProviderHelper {
    private static final String FEATURE_GENERATED_KEY_SUFFIX = "_feature";
    private static final String METACLASS_GENERATED_KEY_SUFFIX = "_type";
    private static final String GENERATED_KEY_PREFIX = "_UI_";
    private static final String METACLASS_DISPLAY_PREFIX = "[";
    private static final String METACLASS_DISPLAY_SUFFIX = "] ";

    protected static IItemLabelProvider getItemLabelProvider(EObject object_p) {
        if (object_p == null) {
            return null;
        }
        AdapterFactoryEditingDomain editingDomain = (AdapterFactoryEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)object_p);
        if (editingDomain == null) {
            return null;
        }
        return (IItemLabelProvider)editingDomain.getAdapterFactory().adapt((Notifier)object_p, IItemLabelProvider.class);
    }

    public static String getText(EObject object_p) {
        String label = "";
        IItemLabelProvider provider = EObjectLabelProviderHelper.getItemLabelProvider(object_p);
        if (provider != null) {
            label = provider.getText((Object)object_p);
        }
        return label;
    }

    public static Image getImage(EObject object_p) {
        Object image = null;
        IItemLabelProvider provider = EObjectLabelProviderHelper.getItemLabelProvider(object_p);
        if (provider != null) {
            image = provider.getImage((Object)object_p);
        }
        return image != null ? EObjectLabelProviderHelper.getImageFromObject(image) : null;
    }

    public static ImageDescriptor getImageDescriptor(EObject object_p) {
        Object image = null;
        IItemLabelProvider provider = EObjectLabelProviderHelper.getItemLabelProvider(object_p);
        if (provider != null) {
            image = provider.getImage((Object)object_p);
        }
        return image != null ? EObjectLabelProviderHelper.getImageDescriptorFromObject(image) : null;
    }

    public static Image getImageFromObject(Object image_p) {
        return ExtendedImageRegistry.getInstance().getImage(image_p);
    }

    public static ImageDescriptor getImageDescriptorFromObject(Object image_p) {
        return ExtendedImageRegistry.getInstance().getImageDescriptor(image_p);
    }

    public static String getMetaclassLabel(EObject object_p, boolean addBrackets_p) {
        String label = null;
        if (object_p == null) {
            return label;
        }
        AdapterFactoryEditingDomain editingDomain = (AdapterFactoryEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)object_p);
        if (editingDomain == null) {
            return label;
        }
        IItemLabelProvider provider = (IItemLabelProvider)editingDomain.getAdapterFactory().adapt((Notifier)object_p, IItemLabelProvider.class);
        if (provider instanceof ItemProviderAdapter) {
            label = EObjectLabelProviderHelper.getMetaclassLabel(object_p.eClass(), (ItemProviderAdapter)provider);
        }
        if (addBrackets_p) {
            label = METACLASS_DISPLAY_PREFIX + label + METACLASS_DISPLAY_SUFFIX;
        }
        return label;
    }

    public static String getMetaclassLabel(EClass class_p, ItemProviderAdapter provider_p) {
        String label = null;
        if (class_p == null || provider_p == null) {
            return label;
        }
        try {
            label = provider_p.getString(GENERATED_KEY_PREFIX + class_p.getName() + METACLASS_GENERATED_KEY_SUFFIX);
        }
        catch (MissingResourceException missingResourceException) {
            label = "<<MissingResourceException>> [" + class_p.getName() + "]";
        }
        return label;
    }

    public static String getFeatureLabel(EStructuralFeature feature_p, ItemProviderAdapter provider_p) {
        String label = null;
        if (feature_p == null || provider_p == null) {
            return label;
        }
        String featureKey = String.valueOf(feature_p.getEContainingClass().getName()) + "_" + feature_p.getName();
        label = provider_p.getString(GENERATED_KEY_PREFIX + featureKey + FEATURE_GENERATED_KEY_SUFFIX);
        return label;
    }
}

