/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.Query;
import org.eclipse.emf.teneo.annotations.pannotation.InheritanceType;
import org.eclipse.emf.teneo.hibernate.HbEntityDataStore;
import org.eclipse.emf.teneo.hibernate.HbStoreException;
import org.eclipse.emf.teneo.hibernate.SessionWrapper;
import org.hibernate.Session;
import org.hibernate.ejb.EntityManagerImpl;
import org.hibernate.engine.ForeignKeys;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.mapping.UnionSubclass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HbEntityManagerWrapper
implements SessionWrapper {
    private EntityManager entityManager = null;
    private final HbEntityDataStore hbEntityDataStore;
    private EntityTransaction entityTransaction = null;
    private FlushModeType flushMode = null;

    public HbEntityManagerWrapper(HbEntityDataStore hbEntityDataStore) {
        this.hbEntityDataStore = hbEntityDataStore;
    }

    public HbEntityManagerWrapper(HbEntityDataStore hbEntityDataStore, EntityManager entityManager) {
        this.hbEntityDataStore = hbEntityDataStore;
        this.entityManager = entityManager;
    }

    public Object getClassicSession() {
        if (this.entityManager == null) {
            this.entityManager = this.hbEntityDataStore.getEntityManagerFactory().createEntityManager();
        }
        return this.entityManager;
    }

    @Override
    public Object getSession() {
        if (this.entityManager == null) {
            this.entityManager = this.hbEntityDataStore.getEntityManagerFactory().createEntityManager();
        }
        return this.entityManager;
    }

    public EntityManager getEntityManager() {
        return (EntityManager)this.getSession();
    }

    @Override
    public void beginTransaction() {
        assert (this.entityTransaction == null);
        this.entityTransaction = this.getEntityManager().getTransaction();
        this.entityTransaction.begin();
    }

    @Override
    public void commitTransaction() {
        if (this.entityTransaction == null) {
            throw new IllegalStateException("EntityTransaction is null, call begin before commit!");
        }
        this.entityTransaction.commit();
        this.entityTransaction = null;
    }

    @Override
    public void rollbackTransaction() {
        if (this.entityTransaction == null) {
            throw new IllegalStateException("EntityTransaction is null, call begin before commit!");
        }
        this.entityTransaction.rollback();
        this.entityTransaction = null;
    }

    @Override
    public Object get(String entityName, Serializable id) {
        return ((EntityManagerImpl)this.getEntityManager()).getSession().get(entityName, id);
    }

    @Override
    public List<?> executeQuery(String qry) {
        Query query = this.getEntityManager().createQuery(qry);
        return query.getResultList();
    }

    @Override
    public List<?> executeQuery(String qry, boolean cacheable) {
        Query query = this.getEntityManager().createQuery(qry);
        return query.getResultList();
    }

    @Override
    public List<?> executeQuery(String qry, String entityParameter, Object entity) {
        Query query = this.getEntityManager().createQuery(qry);
        query.setParameter(entityParameter, entity);
        return query.getResultList();
    }

    @Override
    public List<?> executeQuery(String qry, List<Object> parameters) {
        Query query = this.getEntityManager().createQuery(qry);
        int pos = 1;
        for (Object obj : parameters) {
            query.setParameter(pos++, obj);
        }
        return query.getResultList();
    }

    @Override
    public List<?> executeQuery(String qry, Map<String, Object> namedParameters) {
        Query query = this.getEntityManager().createQuery(qry);
        for (Map.Entry<String, Object> entry : namedParameters.entrySet()) {
            query.setParameter(entry.getKey(), entry.getValue());
        }
        return query.getResultList();
    }

    @Override
    public boolean isEJB3EntityManager() {
        return true;
    }

    @Override
    public void restorePreviousFlushMode() {
        if (this.flushMode != null) {
            this.getEntityManager().setFlushMode(this.flushMode);
            this.flushMode = null;
        }
    }

    @Override
    public void setFlushModeManual() {
        this.flushMode = this.getEntityManager().getFlushMode();
        this.getEntityManager().setFlushMode(FlushModeType.COMMIT);
    }

    @Override
    public void close() {
        this.getEntityManager().close();
    }

    @Override
    public void saveOrUpdate(Object obj) {
        Session session = ((EntityManagerImpl)this.getEntityManager()).getSession();
        String entityName = this.hbEntityDataStore.getInterceptor().getEntityName(obj);
        if (((SessionImplementor)session).getPersistenceContext().isEntryFor(obj)) {
            this.getEntityManager().persist(obj);
        } else if (ForeignKeys.isNotTransient((String)entityName, (Object)obj, (Boolean)false, (SessionImplementor)((SessionImplementor)session)) || !ForeignKeys.isTransient((String)entityName, (Object)obj, (Boolean)false, (SessionImplementor)((SessionImplementor)session))) {
            session.saveOrUpdate(obj);
        } else {
            this.getEntityManager().persist(obj);
        }
    }

    @Override
    public void delete(Object obj) {
        this.getEntityManager().remove(obj);
    }

    @Override
    public void flush() {
        this.getEntityManager().flush();
    }

    @Override
    public boolean isTransactionActive() {
        return this.entityTransaction != null && this.entityTransaction.isActive();
    }

    @Override
    public void refresh(Object obj) {
        this.getEntityManager().refresh(obj);
    }

    @Override
    public boolean isInheritanceStrategy(Class<?> cls, InheritanceType strategy) {
        String name = cls.getName();
        String realName = name.substring(name.lastIndexOf(46) + 1, name.length() - 4);
        PersistentClass cmd = this.hbEntityDataStore.getConfiguration().getClassMapping(realName);
        if (strategy.equals((Object)InheritanceType.SINGLE_TABLE)) {
            return cmd instanceof SingleTableSubclass;
        }
        if (strategy.equals((Object)InheritanceType.JOINED)) {
            return cmd instanceof JoinedSubclass;
        }
        if (strategy.equals((Object)InheritanceType.TABLE_PER_CLASS)) {
            return cmd instanceof UnionSubclass;
        }
        throw new HbStoreException("Strategy: " + strategy.toString() + " not supported ");
    }

    @Override
    public void clear() {
        this.getEntityManager().clear();
    }

    @Override
    public void persist(Object obj) {
        this.getEntityManager().persist(obj);
    }

    @Override
    public Session getHibernateSession() {
        return (Session)this.getEntityManager().getDelegate();
    }
}

