/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping.econtainer;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import org.dom4j.Node;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.teneo.classloader.ClassLoaderResolver;
import org.eclipse.emf.teneo.classloader.StoreClassLoadException;
import org.eclipse.emf.teneo.hibernate.HbMapperException;
import org.eclipse.emf.teneo.hibernate.mapping.identifier.IdentifierCacheHandler;
import org.hibernate.EntityMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.TransientObjectException;
import org.hibernate.engine.ForeignKeys;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.impl.SessionImpl;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.type.AbstractType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.NullableType;
import org.hibernate.type.Type;
import org.hibernate.usertype.CompositeUserType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EContainerUserType
extends AbstractType
implements CompositeUserType,
AssociationType {
    private static final long serialVersionUID = 6385066726834417274L;
    private static final String ENCODING_SEPARATOR = ";";
    private static final String[] propertyNames = new String[]{"containerclass", "containerid"};
    private static final Type[] propertyTypes = new Type[]{Hibernate.STRING, Hibernate.STRING};
    private static final int[] sqlTypes = new int[]{12, 12};
    private final Hashtable<String, Constructor<?>> constructorCache = new Hashtable();
    private final Hashtable<String, Type> identifierTypeCache = new Hashtable();

    public String toLoggableString(Object value, SessionFactoryImplementor factory) throws HibernateException {
        return value != null ? "EContainer: " + value.getClass().getName() : "EContainer null value";
    }

    public Class<?> getReturnedClass() {
        return Object.class;
    }

    public Object deepCopy(Object value, EntityMode entityMode, SessionFactoryImplementor factory) throws HibernateException {
        return value;
    }

    public Object fromXMLNode(Node xml, Mapping factory) throws HibernateException {
        throw new UnsupportedOperationException("not supported for econtainer");
    }

    public int getColumnSpan(Mapping mapping) throws MappingException {
        return 2;
    }

    public String getName() {
        return "econtainer";
    }

    public boolean isDirty(Object old, Object current, boolean[] checkable, SessionImplementor session) throws HibernateException {
        return this.isDirty(old, current, session);
    }

    public Object nullSafeGet(ResultSet rs, String name, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        throw new UnsupportedOperationException("not supported for econtainer");
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, boolean[] settable, SessionImplementor session) throws HibernateException, SQLException {
        if (settable == null || settable[0]) {
            this.nullSafeSet(st, value, index, session);
        }
    }

    public Object replace(Object original, Object target, SessionImplementor session, Object owner, Map copyCache) throws HibernateException {
        return this.replace(original, target, session, owner);
    }

    public void setToXMLNode(Node node, Object value, SessionFactoryImplementor factory) throws HibernateException {
        throw new UnsupportedOperationException("not supported for econtainer");
    }

    public int[] sqlTypes(Mapping mapping) throws MappingException {
        return sqlTypes;
    }

    public boolean[] toColumnNullness(Object value, Mapping mapping) {
        boolean[] result = new boolean[this.getColumnSpan(mapping)];
        if (value != null) {
            int i = 0;
            while (i < result.length) {
                result[i] = true;
                ++i;
            }
        }
        return result;
    }

    public boolean isAnyType() {
        return true;
    }

    public boolean isAssociationType() {
        return true;
    }

    public boolean isComponentType() {
        return false;
    }

    public String getAssociatedEntityName(SessionFactoryImplementor factory) throws MappingException {
        throw new UnsupportedOperationException("Econtainer type is a generic type, no specific associated entity");
    }

    public Joinable getAssociatedJoinable(SessionFactoryImplementor factory) throws MappingException {
        throw new UnsupportedOperationException("Econtainer type is a generic type, no specific associated entity");
    }

    public ForeignKeyDirection getForeignKeyDirection() {
        return ForeignKeyDirection.FOREIGN_KEY_FROM_PARENT;
    }

    public String getLHSPropertyName() {
        return null;
    }

    public String getOnCondition(String alias, SessionFactoryImplementor factory, Map enabledFilters) throws MappingException {
        throw new UnsupportedOperationException("not supported for econtainer");
    }

    public String getRHSUniqueKeyPropertyName() {
        return null;
    }

    public boolean isAlwaysDirtyChecked() {
        return false;
    }

    public boolean isEmbeddedInXML() {
        return false;
    }

    public boolean useLHSPrimaryKey() {
        return false;
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return x == y;
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public boolean isMutable() {
        return false;
    }

    public Class<?> returnedClass() {
        return Object.class;
    }

    public Object assemble(Serializable cached, SessionImplementor session, Object owner) throws HibernateException {
        if (cached == null) {
            return null;
        }
        if (!(cached instanceof ContainerPointer)) {
            String entityName = session.bestGuessEntityName((Object)cached);
            Serializable idObject = this.getID(entityName, cached, session);
            return session.internalLoad(entityName, idObject, false, false);
        }
        ContainerPointer cp = (ContainerPointer)cached;
        return cp.getObject(session);
    }

    public Serializable disassemble(Object value, SessionImplementor session) throws HibernateException {
        if (value == null) {
            return null;
        }
        try {
            String entityName = session.bestGuessEntityName(value);
            Serializable idObject = this.getID(entityName, value, session);
            return new ContainerPointer(this.getIdentifierType(entityName, session), entityName, idObject.toString());
        }
        catch (TransientObjectException transientObjectException) {
            return null;
        }
    }

    public Serializable disassemble(Object value, SessionImplementor session, Object owner) throws HibernateException {
        return this.disassemble(value, session);
    }

    public String[] getPropertyNames() {
        return propertyNames;
    }

    public Type[] getPropertyTypes() {
        return propertyTypes;
    }

    public Object getPropertyValue(Object component, int property) throws HibernateException {
        EObject container = ((InternalEObject)component).eContainer();
        if (container == null) {
            return null;
        }
        if (property == 0) {
            return container.getClass().getName();
        }
        if (property == 1) {
            return IdentifierCacheHandler.getInstance().getID(container);
        }
        throw new HbMapperException("Property: " + property + " not supported in " + component.getClass().getName());
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        String cc = rs.getString(names[0]);
        if (cc == null) {
            return null;
        }
        String idStr = rs.getString(names[1]);
        if (idStr == null) {
            return null;
        }
        Object obj = session.internalLoad(cc, this.extractID(this.getIdentifierType(cc, session), idStr), false, false);
        return obj;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, 12);
            st.setNull(index + 1, 12);
        } else {
            String ename = session.bestGuessEntityName(value);
            st.setString(index, ename);
            st.setString(index + 1, this.createIDString(this.getIdentifierType(ename, session), this.getID(ename, value, session)));
        }
    }

    private Type getIdentifierType(String entityName, SessionImplementor session) {
        Type type = this.identifierTypeCache.get(entityName);
        if (type != null) {
            return type;
        }
        Type identifierType = ((SessionImpl)session).getFactory().getClassMetadata(entityName).getIdentifierType();
        this.identifierTypeCache.put(entityName, identifierType);
        return identifierType;
    }

    public Object replace(Object original, Object target, SessionImplementor session, Object owner) throws HibernateException {
        if (original == null) {
            return null;
        }
        String ename = session.bestGuessEntityName(original);
        Serializable id = this.getID(ename, original, session);
        return session.internalLoad(ename, id, false, false);
    }

    private Serializable getID(String entityName, Object value, SessionImplementor session) {
        Serializable result = ForeignKeys.getEntityIdentifierIfNotUnsaved((String)entityName, (Object)value, (SessionImplementor)session);
        if (result != null) {
            return result;
        }
        return (Serializable)IdentifierCacheHandler.getInstance().getID(value);
    }

    public void setPropertyValue(Object component, int property, Object value) throws HibernateException {
    }

    private Serializable extractID(Type type, String idString) {
        if (type instanceof NullableType) {
            NullableType ntype = (NullableType)type;
            return (Serializable)ntype.fromStringValue(idString);
        }
        String className = idString.substring(0, idString.indexOf(ENCODING_SEPARATOR));
        String strValue = idString.substring(1 + idString.indexOf(ENCODING_SEPARATOR));
        Constructor<Object> constructor = this.constructorCache.get(className);
        if (constructor == null) {
            try {
                Class clazz = ClassLoaderResolver.classForName((String)className);
                constructor = clazz.getConstructor(String.class);
            }
            catch (StoreClassLoadException storeClassLoadException) {
                throw new HbMapperException("Class " + className + " not found");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new HbMapperException("Class " + className + " does not have a constructor with a String parameter!");
            }
        }
        if (constructor == null) {
            throw new HbMapperException("Class " + className + " does not have a constructor with a String parameter!");
        }
        try {
            return (Serializable)constructor.newInstance(strValue);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new HbMapperException("Can not instantiate: " + className + " using value " + strValue);
        }
        catch (InstantiationException instantiationException) {
            throw new HbMapperException("Can not instantiate: " + className + " using value " + strValue);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new HbMapperException("Can not instantiate: " + className + " using value " + strValue);
        }
    }

    private String createIDString(Type type, Serializable id) {
        if (type instanceof NullableType) {
            NullableType ntype = (NullableType)type;
            return ntype.toString((Object)id);
        }
        return String.valueOf(id.getClass().getName()) + ENCODING_SEPARATOR + id.toString();
    }

    private class ContainerPointer
    implements Serializable {
        private static final long serialVersionUID = -2777938032663239346L;
        private final String container;
        private final Serializable id;

        ContainerPointer(Type type, String theContainer, String theIDStr) {
            this.container = theContainer;
            this.id = EContainerUserType.this.extractID(type, theIDStr);
        }

        private Object getObject(SessionImplementor session) {
            return session.internalLoad(this.container, this.id, false, false);
        }
    }
}

