/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.jpox.mapper.association;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pannotation.CascadeType;
import org.eclipse.emf.teneo.annotations.pannotation.OneToMany;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.jpox.elist.AnyFeatureMapEntry;
import org.eclipse.emf.teneo.jpox.mapper.MappingUtil;
import org.eclipse.emf.teneo.jpox.mapper.association.AssociationMapper;
import org.eclipse.emf.teneo.jpox.mapping.AnyTypeEObject;
import org.eclipse.emf.teneo.simpledom.Element;

public class OneToManyMapper
extends AssociationMapper
implements ExtensionPoint {
    protected static final Log log = LogFactory.getLog(OneToManyMapper.class);

    public void map(PAnnotatedEReference aReference, Element eclassElement) {
        boolean useJoin;
        log.debug((Object)("Processing one to many ereference: " + aReference.getModelElement().getName()));
        EReference eReference = (EReference)aReference.getModelElement();
        EList cascade = aReference.getOneToMany().getCascade();
        boolean cascadeRemove = cascade.contains(CascadeType.ALL) || cascade.contains(CascadeType.REMOVE);
        log.debug((Object)("Cascaderemove " + cascadeRemove));
        Element field = eclassElement.addElement("field");
        field.addAttribute("name", this.namingHandler.correctName(this.mappingContext, (EStructuralFeature)eReference)).addAttribute("persistence-modifier", "persistent");
        OneToMany otm = aReference.getOneToMany();
        if (otm.getMappedBy() != null && !aReference.getModelEReference().isContainment()) {
            field.addAttribute("mapped-by", otm.getMappedBy());
        }
        Element collection = field.addElement("collection");
        MappingUtil.addEagerLazyLoading(collection, otm.getFetch());
        boolean isWildcard = MappingUtil.isWildcard((EStructuralFeature)eReference);
        boolean bl = useJoin = aReference.getJoinTable() != null || isWildcard || eReference.getEReferenceType().getInstanceClass().equals(EObject.class) || eReference.getEReferenceType().getInstanceClass().equals(Object.class) || aReference.getEmbedded() != null;
        if (useJoin) {
            Element joinElement = field.addElement("join");
            if (aReference.getJoinTable() != null && aReference.getJoinTable().getName() != null) {
                field.addAttribute("table", aReference.getJoinTable().getName());
            }
            if (aReference.getJoinColumns() != null && aReference.getJoinColumns().size() > 0) {
                this.mappingContext.getJoinColumnMapper().map((List)aReference.getJoinColumns(), joinElement);
            }
        }
        boolean embedded = false;
        if (isWildcard) {
            assert (false);
            log.debug((Object)"Is wildcard using any feature entry, adding embedded tags");
            collection.addAttribute("element-type", AnyFeatureMapEntry.class.getName());
            MappingUtil.addFeatureMapEntryMapping(field);
            embedded = true;
            field.addAttribute("embedded", "true");
        } else if (eReference.getEReferenceType().getInstanceClass().equals(EObject.class)) {
            log.debug((Object)"Any type of eobject");
            collection.addAttribute("element-type", AnyTypeEObject.class.getName());
            MappingUtil.addAnytypeMapping(field);
            embedded = true;
            field.addAttribute("embedded", "true");
        } else if (eReference.getEReferenceType().getInstanceClass().equals(Object.class)) {
            log.debug((Object)"Any type of object");
            collection.addAttribute("element-type", Object.class.getName());
            MappingUtil.addAnytypeMapping(field);
            embedded = true;
            field.addAttribute("embedded", "true");
        } else {
            String targetEntity = aReference.getOneToMany().getTargetEntity();
            collection.addAttribute("element-type", MappingUtil.getImplNameOfEClass(targetEntity, this.mappingContext));
        }
        if (!embedded && aReference.getEmbedded() != null) {
            log.debug((Object)"Embedded annotation present");
            this.mappingContext.getEmbeddedMapper().map(aReference, field);
            embedded = true;
        }
        if (!embedded) {
            if (cascade.contains(CascadeType.ALL) || MappingUtil.isGroup((EStructuralFeature)eReference)) {
                collection.addAttribute("dependent-element", "true");
            } else {
                collection.addAttribute("dependent-element", "false");
            }
        }
        if (eReference.getEOpposite() == null && !useJoin && aReference.getJoinColumns() != null && aReference.getJoinColumns().size() > 0) {
            Element element = field.addElement("element");
            this.mappingContext.getJoinColumnMapper().map((List)aReference.getJoinColumns(), element);
        }
        Element order = field.addElement("order");
        if (aReference.getOrderBy() != null) {
            log.warn((Object)"JPOX does not support orderby ejb3, ignored");
        }
        order.addAttribute("column", this.namingHandler.getUniqueIndexColumnName((EStructuralFeature)eReference));
        if (eReference.getEOpposite() != null && eReference.getEOpposite().isContainment()) {
            field.addAttribute("delete-action", "cascade");
        } else {
            field.addAttribute("delete-action", "restrict");
        }
        if (!useJoin && cascadeRemove) {
            Element fk = field.addElement("foreign-key").addAttribute("delete-action", "cascade").addAttribute("update-action", "cascade");
            this.setFKName((PAnnotatedEStructuralFeature)aReference, fk);
        } else if (!useJoin) {
            Element fk = field.addElement("foreign-key").addAttribute("delete-action", "restrict").addAttribute("update-action", "cascade");
            this.setFKName((PAnnotatedEStructuralFeature)aReference, fk);
        }
    }
}

