/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.samples.emf.annotations.inheritancemapping;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum USState implements Enumerator
{
    AK_LITERAL(0, "AK", "AK"),
    AL_LITERAL(1, "AL", "AL"),
    AR_LITERAL(2, "AR", "AR");

    public static final int AK = 0;
    public static final int AL = 1;
    public static final int AR = 2;
    private static final USState[] VALUES_ARRAY;
    public static final List<USState> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new USState[]{AK_LITERAL, AL_LITERAL, AR_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static USState get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            USState result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static USState getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            USState result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static USState get(int value) {
        switch (value) {
            case 0: {
                return AK_LITERAL;
            }
            case 1: {
                return AL_LITERAL;
            }
            case 2: {
                return AR_LITERAL;
            }
        }
        return null;
    }

    private USState(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

