/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping.econtainer;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.teneo.PackageRegistryProvider;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.UserType;

public class EContainerFeatureIDUserType
implements UserType {
    private static final int[] SQL_TYPES = new int[]{12};
    private static final String SEPARATOR = "_;_";
    private EPackage.Registry registry = PackageRegistryProvider.getInstance().getPackageRegistry();

    public static String convertEContainerRelationToString(EClass eClass, EStructuralFeature eFeature) {
        StringBuilder result = new StringBuilder();
        String uri = eClass.getEPackage().getNsURI();
        String eClassifierName = eClass.getName();
        result.append(String.valueOf(uri) + SEPARATOR + eClassifierName);
        uri = eFeature.getEContainingClass().getEPackage().getNsURI();
        String eClassName = eFeature.getEContainingClass().getName();
        String eFeatureName = eFeature.getName();
        result.append(SEPARATOR + uri + SEPARATOR + eClassName + SEPARATOR + eFeatureName);
        return result.toString();
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        EContainerFeatureIDHolder holder = new EContainerFeatureIDHolder();
        holder.convertFromString((String)((Object)cached), this.registry);
        return holder;
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        if (value == null) {
            return null;
        }
        return ((EContainerFeatureIDHolder)value).convertToString();
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == null && y == null) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        if (x.getClass() != y.getClass()) {
            return false;
        }
        return x.equals(y);
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public boolean isMutable() {
        return false;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor sessionImplementor, Object owner) throws HibernateException, SQLException {
        String value = rs.getString(names[0]);
        if (rs.wasNull()) {
            return null;
        }
        EContainerFeatureIDHolder holder = new EContainerFeatureIDHolder();
        holder.convertFromString(value, this.registry);
        return holder;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, 12);
        } else {
            st.setString(index, ((EContainerFeatureIDHolder)value).convertToString());
        }
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public Class<?> returnedClass() {
        return EStructuralFeature.class;
    }

    public int[] sqlTypes() {
        return SQL_TYPES;
    }

    public static class EContainerFeatureIDHolder {
        private EClass eClass;
        private EStructuralFeature eFeature;

        public EStructuralFeature getEFeature() {
            return this.eFeature;
        }

        public void setEFeature(EStructuralFeature feature) {
            this.eFeature = feature;
        }

        public void convertFromString(String value, EPackage.Registry theRegistry) {
            String[] values = value.split(EContainerFeatureIDUserType.SEPARATOR);
            String nsuri = values[0];
            EPackage eContainerPackage = theRegistry.getEPackage(nsuri);
            String eContainerEClassName = values[1];
            this.eClass = (EClass)eContainerPackage.getEClassifier(eContainerEClassName);
            EPackage eFeaturePackage = theRegistry.getEPackage(values[2]);
            String eClassifierName = values[3];
            EClassifier eClassifier = eFeaturePackage.getEClassifier(eClassifierName);
            EClass eClass = (EClass)eClassifier;
            String eFeatureName = values[4];
            this.eFeature = eClass.getEStructuralFeature(eFeatureName);
        }

        public String convertToString() {
            return EContainerFeatureIDUserType.convertEContainerRelationToString(this.eClass, this.eFeature);
        }

        public EClass getEClass() {
            return this.eClass;
        }

        public void setEClass(EClass class1) {
            this.eClass = class1;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.eClass == null ? 0 : this.eClass.hashCode());
            result = 31 * result + (this.eFeature == null ? 0 : this.eFeature.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EContainerFeatureIDHolder other = (EContainerFeatureIDHolder)obj;
            if (this.eClass == null && other.eClass != null) {
                return false;
            }
            if (!this.eClass.equals(other.eClass)) {
                return false;
            }
            if (this.eFeature == null && other.eFeature != null) {
                return false;
            }
            return this.eFeature.equals(other.eFeature);
        }
    }
}

