/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping.elist;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.teneo.hibernate.LazyCollectionUtils;
import org.eclipse.emf.teneo.hibernate.mapping.elist.HbExtraLazyPersistableEList;
import org.eclipse.emf.teneo.hibernate.mapping.elist.HibernatePersistableEMap;
import org.eclipse.emf.teneo.mapping.elist.PersistableEList;
import org.eclipse.emf.teneo.util.StoreUtil;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.collection.internal.AbstractPersistentCollection;
import org.hibernate.collection.internal.PersistentList;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.collection.AbstractCollectionPersister;
import org.hibernate.type.EntityType;

public class HbExtraLazyPersistableEMap<K, V>
extends HibernatePersistableEMap<K, V> {
    private static final long serialVersionUID = 1L;

    public HbExtraLazyPersistableEMap(InternalEObject owner, EReference eref, List<BasicEMap.Entry<K, V>> list) {
        super(owner, eref, list);
    }

    public Iterator<Map.Entry<K, V>> iterator() {
        return LazyCollectionUtils.getPagedLoadingIterator(this, 100);
    }

    @Override
    public int size() {
        if (!this.isLoaded() && this.isHibernateListPresent()) {
            try {
                this.size = ((PersistentList)((PersistableEList)this.delegateEList).getDelegate()).size();
                return this.size;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return super.size();
    }

    public V get(Object key) {
        if (key != null && !this.isLoaded() && this.isHibernateListPresent()) {
            Session session = this.getSession();
            session.flush();
            AbstractPersistentCollection collection = (AbstractPersistentCollection)this.getDelegate();
            CollectionEntry collectionEntry = ((SessionImplementor)session).getPersistenceContext().getCollectionEntry((PersistentCollection)collection);
            AbstractCollectionPersister persister = (AbstractCollectionPersister)collectionEntry.getLoadedPersister();
            String entityName = ((EntityType)persister.getCollectionMetadata().getElementType()).getAssociatedEntityName();
            Query qry = session.createQuery("select e from " + entityName + " as e where e.key=:key and e." + StoreUtil.getExtraLazyInversePropertyName((EStructuralFeature)this.getEStructuralFeature()) + "=:owner");
            qry.setParameter("key", key);
            qry.setParameter("owner", (Object)this.getOwner());
            Object result = qry.uniqueResult();
            if (result instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)result;
                return entry.getValue();
            }
            return null;
        }
        return (V)super.get(key);
    }

    public V put(K key, V value) {
        if (!this.isLoaded() && this.isHibernateListPresent()) {
            Map.Entry entry = (Map.Entry)this.get(key);
            if (entry != null && entry instanceof BasicEMap.Entry) {
                Object result = this.putEntry((BasicEMap.Entry)entry, value);
                this.didModify((BasicEMap.Entry)entry, result);
                return (V)result;
            }
            BasicEMap.Entry newEntry = this.newEntry(this.hashOf(key), key, value);
            this.delegateEList.add((Object)newEntry);
            return null;
        }
        return (V)super.put(key, value);
    }

    @Override
    protected EList<BasicEMap.Entry<K, V>> createDelegateEList(InternalEObject owner, EStructuralFeature feature, List<BasicEMap.Entry<K, V>> delegateORMList) {
        return new HbExtraLazyPersistableEList<BasicEMap.Entry<K, V>>(owner, feature, delegateORMList){
            private static final long serialVersionUID = 1L;

            protected void didAdd(int index, BasicEMap.Entry<K, V> newObject) {
                HbExtraLazyPersistableEMap.this.doPut(newObject);
            }

            protected void didSet(int index, BasicEMap.Entry<K, V> newObject, BasicEMap.Entry<K, V> oldObject) {
                this.didRemove(index, oldObject);
                this.didAdd(index, newObject);
            }

            protected void didRemove(int index, BasicEMap.Entry<K, V> oldObject) {
                HbExtraLazyPersistableEMap.this.doRemove(oldObject);
            }

            protected void didClear(int size, Object[] oldObjects) {
                this.doClear();
            }

            protected void didMove(int index, BasicEMap.Entry<K, V> movedObject, int oldIndex) {
                HbExtraLazyPersistableEMap.this.doMove(movedObject);
            }
        };
    }

    public boolean remove(Object object) {
        return super.remove(object);
    }

    public boolean removeAll(Collection<?> collection) {
        return super.removeAll(collection);
    }

    public V removeKey(Object key) {
        return (V)super.removeKey(key);
    }

    private boolean isHibernateListPresent() {
        return this.getDelegate() instanceof AbstractPersistentCollection;
    }

    private Session getSession() {
        AbstractPersistentCollection persistentCollection = (AbstractPersistentCollection)this.getDelegate();
        SessionImplementor session = persistentCollection.getSession();
        return (Session)session;
    }
}

