/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.teneo.hibernate.EMFInterceptor;
import org.eclipse.emf.teneo.hibernate.HbDataStore;
import org.eclipse.emf.teneo.hibernate.HbHelper;
import org.eclipse.emf.teneo.hibernate.HbMapperException;
import org.eclipse.emf.teneo.hibernate.HbSessionWrapper;
import org.eclipse.emf.teneo.hibernate.HbUtil;
import org.eclipse.emf.teneo.hibernate.SessionWrapper;
import org.eclipse.emf.teneo.hibernate.mapping.identifier.IdentifierUtil;
import org.eclipse.emf.teneo.hibernate.resource.HbResource;
import org.eclipse.emf.teneo.resource.StoreResource;
import org.hibernate.FlushMode;
import org.hibernate.LockOptions;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.util.collections.IdentityMap;

public class HbResourceImpl
extends StoreResource
implements HbResource {
    private static Log log = LogFactory.getLog(HbResourceImpl.class);
    protected HbDataStore emfDataStore;

    public HbResourceImpl(URI uri) {
        super(uri);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating hibernateresource using uri: " + uri.toString()));
        }
        Map params = this.decodeQueryString(uri.query());
        String emfdsName = null;
        if (uri.query() == null && uri.fileExtension() != null) {
            if ("ehb".compareTo(uri.fileExtension()) == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Assuming this is a property file " + uri.toString()));
                }
                try {
                    URIConverter uriConverter = this.getURIConverter();
                    InputStream is = uriConverter.createInputStream(uri);
                    Properties props = new Properties();
                    props.load(is);
                    is.close();
                    emfdsName = props.getProperty("name");
                    this.emfDataStore = HbUtil.getCreateDataStore(props);
                    this.setDefinedQueries(this.getQueries(props));
                }
                catch (IOException e) {
                    throw new HbMapperException("Exception when reading properties from: " + uri.toString(), e);
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Trying fileextension: " + uri.fileExtension()));
                }
                emfdsName = uri.fileExtension();
            }
        } else if (params.get("dsname") != null) {
            emfdsName = this.getParam(params, "dsname", uri.query());
            this.setDefinedQueries(this.getQueries(params));
        }
        if (emfdsName == null) {
            throw new HbMapperException("The Resource can not be initialized using the querystring: " + uri.query() + ". Are all the required parameters present?");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Looking for emf data store using  " + emfdsName));
        }
        this.emfDataStore = HbHelper.INSTANCE.getDataStore(emfdsName);
        super.init(this.emfDataStore.getTopEntities());
    }

    public HbDataStore getEMFDataStore() {
        return this.emfDataStore;
    }

    @Override
    public Session getSession() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating session");
        }
        SessionFactory sessionFactory = this.emfDataStore.getSessionFactory();
        Session session = sessionFactory.openSession();
        session.setFlushMode(FlushMode.MANUAL);
        if (this.loadedEObjects.size() > 0) {
            session.beginTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Merging " + this.loadedEObjects.size() + " eobjects into new session "));
            }
            for (Object obj : this.loadedEObjects) {
                session.buildLockRequest(LockOptions.NONE).lock(obj);
            }
            session.getTransaction().commit();
        }
        return session;
    }

    @Override
    public SessionWrapper getSessionWrapper() {
        return new HbSessionWrapper(this.getEMFDataStore(), this.getSession());
    }

    @Override
    public void returnSessionWrapper(SessionWrapper sessionWrapper) {
        this.returnSession(sessionWrapper.getHibernateSession());
    }

    @Override
    public void returnSession(Session theSession) {
        Map.Entry[] collectionEntryArray;
        Map.Entry[] entryArray = collectionEntryArray = IdentityMap.concurrentEntries((Map)((SessionImplementor)theSession).getPersistenceContext().getCollectionEntries());
        int n = collectionEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            Map.Entry element = entryArray[n2];
            ((PersistentCollection)element.getKey()).unsetSession((SessionImplementor)theSession);
            ++n2;
        }
        theSession.close();
    }

    public Object[] getCrossReferencers(EObject referedTo) {
        Transaction tx = null;
        boolean err = true;
        Session mySession = this.getSession();
        try {
            tx = mySession.beginTransaction();
            Object[] result = this.emfDataStore.getCrossReferencers(mySession, (Object)referedTo);
            err = false;
            Object[] objectArray = result;
            return objectArray;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new HbMapperException("Exception when doing cross reference search " + this.emfDataStore.getName(), e);
        }
        finally {
            if (err) {
                if (tx != null) {
                    tx.rollback();
                }
                mySession.close();
            } else {
                tx.commit();
            }
        }
    }

    protected void saveResource(Map<?, ?> options) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Saving resource with uri: " + this.getURI()));
        }
        boolean err = true;
        Transaction tx = null;
        Session mySession = this.getSession();
        try {
            try {
                tx = mySession.beginTransaction();
                EList list = super.getContents();
                int i = 0;
                while (i < list.size()) {
                    Object obj = list.get(i);
                    mySession.saveOrUpdate(obj);
                    ++i;
                }
                for (Object obj : this.removedEObjects) {
                    if (IdentifierUtil.getID(obj, (SessionImplementor)mySession) == null) continue;
                    mySession.delete(obj);
                    EMFInterceptor.registerCollectionsForDereferencing((EObject)obj);
                }
                mySession.flush();
                err = false;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw new HbMapperException("Exception when saving resource " + this.emfDataStore.getName(), e);
            }
        }
        finally {
            if (err) {
                if (tx != null) {
                    tx.rollback();
                }
            } else {
                tx.commit();
            }
            this.returnSession(mySession);
        }
    }

    protected List<EObject> loadResource(Map<?, ?> options) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading resource: " + this.getURI().toString()));
        }
        Transaction tx = null;
        boolean err = true;
        Session mySession = this.getSession();
        try {
            tx = mySession.beginTransaction();
            List<EObject> storeList = this.loadFromStore(mySession);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loaded " + storeList.size() + " objects"));
            }
            err = false;
            List<EObject> list = storeList;
            return list;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new HbMapperException("Exception when saving resource " + this.emfDataStore.getName(), e);
        }
        finally {
            if (err) {
                if (tx != null) {
                    tx.rollback();
                }
            } else {
                tx.commit();
            }
            this.returnSession(mySession);
        }
    }

    protected void doUnload() {
        super.doUnload();
    }

    protected List<EObject> loadFromStore(Session sess) {
        if (this.definedQueriesPresent()) {
            return this.loadUsingDefinedQueries(sess);
        }
        return this.loadUsingTopClasses(sess);
    }

    private ArrayList<EObject> loadUsingTopClasses(Session sess) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading resource " + this.getURI() + " using top classes"));
        }
        ArrayList<EObject> readObjects = new ArrayList<EObject>();
        String[] stringArray = this.topClassNames;
        int n = this.topClassNames.length;
        int n2 = 0;
        while (n2 < n) {
            String topClassName = stringArray[n2];
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading objects using hql: FROM " + topClassName));
            }
            Query qry = sess.createQuery("FROM " + topClassName);
            for (EObject eobj : qry.list()) {
                if (eobj.eContainer() != null) continue;
                readObjects.add(eobj);
            }
            ++n2;
        }
        return readObjects;
    }

    private ArrayList<EObject> loadUsingDefinedQueries(Session sess) {
        String[] qrys;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading resource " + this.getURI() + " using defined queries"));
        }
        ArrayList<EObject> readObjects = new ArrayList<EObject>();
        String[] stringArray = qrys = this.getDefinedQueries();
        int n = qrys.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            Query qry = sess.createQuery(element);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading objects using hql: " + element));
            }
            for (Object obj : qry.list()) {
                readObjects.add((EObject)obj);
            }
            ++n2;
        }
        return readObjects;
    }
}

