/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapper;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.hibernate.mapper.AbstractMapper;
import org.eclipse.emf.teneo.hibernate.mapper.MappingException;
import org.eclipse.emf.teneo.simpledom.Element;

public class EmbeddedMapper
extends AbstractMapper
implements ExtensionPoint {
    private static final Log log = LogFactory.getLog(EmbeddedMapper.class);

    public void process(PAnnotatedEReference paReference) {
        log.debug((Object)("Processing embedded: " + paReference.toString()));
        this.getHbmContext().pushOverrideOnStack();
        this.getHbmContext().addAttributeOverrides(paReference.getAttributeOverrides());
        this.getHbmContext().addAssociationOverrides(paReference.getAssociationOverrides());
        this.getHbmContext().pushEmbeddingFeature((PAnnotatedEStructuralFeature)paReference);
        try {
            if (paReference.getManyToOne() != null) {
                this.processSingleEmbedded(paReference, paReference.getModelEReference().getEReferenceType());
            } else if (paReference.getOneToOne() != null) {
                this.processSingleEmbedded(paReference, paReference.getModelEReference().getEReferenceType());
            } else {
                if (paReference.getManyToMany() != null) {
                    throw new MappingException("ManyToMany can not be combined with Embedded " + paReference);
                }
                if (paReference.getOneToMany() == null) {
                    throw new MappingException("OneToMany must be set for embedded elist type: " + paReference);
                }
                this.processMultiEmbedded(paReference);
            }
        }
        finally {
            this.getHbmContext().popOverrideStack();
            this.getHbmContext().popEmbeddingFeature();
        }
    }

    private void processSingleEmbedded(PAnnotatedEReference paReference, EClass target) {
        log.debug((Object)("Processing single embedded: " + paReference.toString()));
        Element componentElement = this.getHbmContext().getCurrent().addElement("component").addAttribute("name", paReference.getModelEReference().getName());
        componentElement.addAttribute("class", this.getHbmContext().getInstanceClassName(target));
        Element meta1 = new Element("meta");
        meta1.addAttribute("attribute", "eclassName").addText(paReference.getEReferenceType().getName());
        meta1.addAttribute("inherit", "false");
        Element meta2 = new Element("meta");
        meta2.addAttribute("attribute", "epackage").addText(paReference.getEReferenceType().getEPackage().getNsURI());
        meta1.addAttribute("inherit", "false");
        componentElement.addElement(meta1);
        componentElement.addElement(meta2);
        this.getHbmContext().setCurrent(componentElement);
        try {
            PAnnotatedEClass componentAClass = paReference.getPaModel().getPAnnotated(paReference.getModelEReference().getEReferenceType());
            this.getHbmContext().processFeatures(this.getAllFeatures(componentAClass));
        }
        finally {
            this.getHbmContext().setCurrent(componentElement.getParent());
        }
        this.addAccessor(componentElement, this.hbmContext.getComponentPropertyHandlerName());
    }

    private void processMultiEmbedded(PAnnotatedEReference paReference) {
        log.debug((Object)("Processing multi embedded: " + paReference.toString()));
        this.getHbmContext().getFeatureMapper().getOneToManyMapper().process(paReference);
    }
}

