/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.eclipse.emf.teneo.hibernate.HbDataStore;
import org.eclipse.emf.teneo.hibernate.HbHelper;
import org.hibernate.Cache;
import org.hibernate.CustomEntityDirtinessStrategy;
import org.hibernate.EntityNameResolver;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.MappingException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.StatelessSession;
import org.hibernate.StatelessSessionBuilder;
import org.hibernate.TypeHelper;
import org.hibernate.cache.spi.QueryCache;
import org.hibernate.cache.spi.Region;
import org.hibernate.cache.spi.UpdateTimestampsCache;
import org.hibernate.cfg.Settings;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.SQLFunctionRegistry;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.query.spi.QueryPlanCache;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.engine.spi.SessionBuilderImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.spi.SQLExceptionConverter;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.internal.NamedQueryRepository;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.stat.Statistics;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.Type;
import org.hibernate.type.TypeResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HbBaseSessionDataStore
extends HbDataStore
implements SessionFactory,
SessionFactoryImplementor {
    private static final long serialVersionUID = 1L;
    private SessionFactory sessionFactory;

    @Override
    public void close() {
        if (this.isInitialized()) {
            this.closeSessionFactory();
            HbHelper.INSTANCE.deRegisterDataStore(this);
        }
    }

    @Override
    public SessionFactory getSessionFactory() {
        if (!this.isInitialized()) {
            this.initialize();
        }
        return this.sessionFactory;
    }

    protected void closeSessionFactory() {
        if (this.sessionFactory != null && !this.sessionFactory.isClosed()) {
            this.sessionFactory.close();
            this.sessionFactory = null;
        }
        this.setInitialized(false);
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void evict(Class persistentClass, Serializable id) throws HibernateException {
        this.getSessionFactory().evict(persistentClass, id);
    }

    public void evict(Class persistentClass) throws HibernateException {
        this.getSessionFactory().evict(persistentClass);
    }

    public void evictCollection(String roleName, Serializable id) throws HibernateException {
        this.getSessionFactory().evictCollection(roleName, id);
    }

    public void evictCollection(String roleName) throws HibernateException {
        this.getSessionFactory().evictCollection(roleName);
    }

    public void evictEntity(String entityName, Serializable id) throws HibernateException {
        this.getSessionFactory().evictEntity(entityName, id);
    }

    public void evictEntity(String entityName) throws HibernateException {
        this.getSessionFactory().evictEntity(entityName);
    }

    public void evictQueries() throws HibernateException {
        this.getSessionFactory().evictQueries();
    }

    public void evictQueries(String cacheRegion) throws HibernateException {
        this.getSessionFactory().evictQueries(cacheRegion);
    }

    public Map getAllClassMetadata() throws HibernateException {
        return this.getSessionFactory().getAllClassMetadata();
    }

    public Map getAllCollectionMetadata() throws HibernateException {
        return this.getSessionFactory().getAllCollectionMetadata();
    }

    public ClassMetadata getClassMetadata(Class persistentClass) throws HibernateException {
        return this.getSessionFactory().getClassMetadata(persistentClass);
    }

    public ClassMetadata getClassMetadata(String entityName) throws HibernateException {
        return this.getSessionFactory().getClassMetadata(entityName);
    }

    public CollectionMetadata getCollectionMetadata(String roleName) throws HibernateException {
        return this.getSessionFactory().getCollectionMetadata(roleName);
    }

    public Session getCurrentSession() throws HibernateException {
        return this.getSessionFactory().getCurrentSession();
    }

    public Set getDefinedFilterNames() {
        return this.getSessionFactory().getDefinedFilterNames();
    }

    public FilterDefinition getFilterDefinition(String filterName) throws HibernateException {
        return this.getSessionFactory().getFilterDefinition(filterName);
    }

    public Reference getReference() throws NamingException {
        return this.getSessionFactory().getReference();
    }

    public Statistics getStatistics() {
        return this.getSessionFactory().getStatistics();
    }

    public boolean isClosed() {
        return this.getSessionFactory().isClosed();
    }

    public Session openSession() throws HibernateException {
        return this.getSessionFactory().openSession();
    }

    public Session openSession(Connection connection, Interceptor interceptor) {
        return ((SessionFactoryImpl)this.getSessionFactory()).withOptions().interceptor(interceptor).connection(connection).openSession();
    }

    public Session openSession(Connection connection) {
        return ((SessionFactoryImpl)this.getSessionFactory()).withOptions().connection(connection).openSession();
    }

    public Session openSession(Interceptor interceptor) throws HibernateException {
        return ((SessionFactoryImpl)this.getSessionFactory()).withOptions().interceptor(interceptor).openSession();
    }

    public StatelessSession openStatelessSession() {
        return this.getSessionFactory().openStatelessSession();
    }

    public StatelessSession openStatelessSession(Connection connection) {
        return this.getSessionFactory().openStatelessSession(connection);
    }

    public SessionFactoryImplementor getSessionFactoryImplementor() {
        return (SessionFactoryImplementor)this.getSessionFactory();
    }

    public void addObserver(SessionFactoryObserver arg0) {
        this.getSessionFactoryImplementor().addObserver(arg0);
    }

    public boolean containsFetchProfileDefinition(String arg0) {
        return this.getSessionFactoryImplementor().containsFetchProfileDefinition(arg0);
    }

    public Map getAllSecondLevelCacheRegions() {
        return this.getSessionFactoryImplementor().getAllSecondLevelCacheRegions();
    }

    public Cache getCache() {
        return this.getSessionFactoryImplementor().getCache();
    }

    public CollectionPersister getCollectionPersister(String arg0) throws MappingException {
        return this.getSessionFactoryImplementor().getCollectionPersister(arg0);
    }

    public Set<String> getCollectionRolesByEntityParticipant(String arg0) {
        return this.getSessionFactoryImplementor().getCollectionRolesByEntityParticipant(arg0);
    }

    @Deprecated
    public ConnectionProvider getConnectionProvider() {
        return this.getSessionFactoryImplementor().getConnectionProvider();
    }

    public CurrentTenantIdentifierResolver getCurrentTenantIdentifierResolver() {
        return this.getSessionFactoryImplementor().getCurrentTenantIdentifierResolver();
    }

    public CustomEntityDirtinessStrategy getCustomEntityDirtinessStrategy() {
        return this.getSessionFactoryImplementor().getCustomEntityDirtinessStrategy();
    }

    public Dialect getDialect() {
        return this.getSessionFactoryImplementor().getDialect();
    }

    public EntityNotFoundDelegate getEntityNotFoundDelegate() {
        return this.getSessionFactoryImplementor().getEntityNotFoundDelegate();
    }

    public EntityPersister getEntityPersister(String arg0) throws MappingException {
        return this.getSessionFactoryImplementor().getEntityPersister(arg0);
    }

    public FetchProfile getFetchProfile(String arg0) {
        return this.getSessionFactoryImplementor().getFetchProfile(arg0);
    }

    public IdentifierGenerator getIdentifierGenerator(String arg0) {
        return this.getSessionFactoryImplementor().getIdentifierGenerator(arg0);
    }

    @Deprecated
    public IdentifierGeneratorFactory getIdentifierGeneratorFactory() {
        return this.getSessionFactoryImplementor().getIdentifierGeneratorFactory();
    }

    public String getIdentifierPropertyName(String arg0) throws MappingException {
        return this.getSessionFactoryImplementor().getIdentifierPropertyName(arg0);
    }

    public Type getIdentifierType(String arg0) throws MappingException {
        return this.getSessionFactoryImplementor().getIdentifierType(arg0);
    }

    public String[] getImplementors(String arg0) throws MappingException {
        return this.getSessionFactoryImplementor().getImplementors(arg0);
    }

    public String getImportedClassName(String arg0) {
        return this.getSessionFactoryImplementor().getImportedClassName(arg0);
    }

    public JdbcServices getJdbcServices() {
        return this.getSessionFactoryImplementor().getJdbcServices();
    }

    public NamedQueryDefinition getNamedQuery(String arg0) {
        return this.getSessionFactoryImplementor().getNamedQuery(arg0);
    }

    public NamedSQLQueryDefinition getNamedSQLQuery(String arg0) {
        return this.getSessionFactoryImplementor().getNamedSQLQuery(arg0);
    }

    public Region getNaturalIdCacheRegion(String arg0) {
        return this.getSessionFactoryImplementor().getNaturalIdCacheRegion(arg0);
    }

    public Properties getProperties() {
        return this.getSessionFactoryImplementor().getProperties();
    }

    public QueryCache getQueryCache() {
        return this.getSessionFactoryImplementor().getQueryCache();
    }

    public QueryCache getQueryCache(String arg0) throws HibernateException {
        return this.getSessionFactoryImplementor().getQueryCache(arg0);
    }

    public QueryPlanCache getQueryPlanCache() {
        return this.getSessionFactoryImplementor().getQueryPlanCache();
    }

    public Type getReferencedPropertyType(String arg0, String arg1) throws MappingException {
        return this.getSessionFactoryImplementor().getReferencedPropertyType(arg0, arg1);
    }

    public ResultSetMappingDefinition getResultSetMapping(String arg0) {
        return this.getSessionFactoryImplementor().getResultSetMapping(arg0);
    }

    public String[] getReturnAliases(String arg0) throws HibernateException {
        return this.getSessionFactoryImplementor().getReturnAliases(arg0);
    }

    public Type[] getReturnTypes(String arg0) throws HibernateException {
        return this.getSessionFactoryImplementor().getReturnTypes(arg0);
    }

    public SQLExceptionConverter getSQLExceptionConverter() {
        return this.getSessionFactoryImplementor().getSQLExceptionConverter();
    }

    public SqlExceptionHelper getSQLExceptionHelper() {
        return this.getSessionFactoryImplementor().getSQLExceptionHelper();
    }

    public Region getSecondLevelCacheRegion(String arg0) {
        return this.getSessionFactoryImplementor().getSecondLevelCacheRegion(arg0);
    }

    public ServiceRegistryImplementor getServiceRegistry() {
        return this.getSessionFactoryImplementor().getServiceRegistry();
    }

    public SessionFactory.SessionFactoryOptions getSessionFactoryOptions() {
        return this.getSessionFactoryImplementor().getSessionFactoryOptions();
    }

    public Settings getSettings() {
        return this.getSessionFactoryImplementor().getSettings();
    }

    public SQLFunctionRegistry getSqlFunctionRegistry() {
        return this.getSessionFactoryImplementor().getSqlFunctionRegistry();
    }

    public StatisticsImplementor getStatisticsImplementor() {
        return this.getSessionFactoryImplementor().getStatisticsImplementor();
    }

    public TypeHelper getTypeHelper() {
        return this.getSessionFactoryImplementor().getTypeHelper();
    }

    public TypeResolver getTypeResolver() {
        return this.getSessionFactoryImplementor().getTypeResolver();
    }

    public UpdateTimestampsCache getUpdateTimestampsCache() {
        return this.getSessionFactoryImplementor().getUpdateTimestampsCache();
    }

    public Session openTemporarySession() throws HibernateException {
        return this.getSessionFactoryImplementor().openTemporarySession();
    }

    public SessionBuilderImplementor withOptions() {
        return this.getSessionFactoryImplementor().withOptions();
    }

    public StatelessSessionBuilder withStatelessOptions() {
        return this.getSessionFactoryImplementor().withStatelessOptions();
    }

    public Map<String, CollectionPersister> getCollectionPersisters() {
        return this.getSessionFactoryImplementor().getCollectionPersisters();
    }

    public Map<String, EntityPersister> getEntityPersisters() {
        return this.getSessionFactoryImplementor().getEntityPersisters();
    }

    public NamedQueryRepository getNamedQueryRepository() {
        return this.getSessionFactoryImplementor().getNamedQueryRepository();
    }

    public Iterable<EntityNameResolver> iterateEntityNameResolvers() {
        return this.getSessionFactoryImplementor().iterateEntityNameResolvers();
    }

    public void registerNamedQueryDefinition(String arg0, NamedQueryDefinition arg1) {
        this.getSessionFactoryImplementor().registerNamedQueryDefinition(arg0, arg1);
    }

    public void registerNamedSQLQueryDefinition(String arg0, NamedSQLQueryDefinition arg1) {
        this.getSessionFactoryImplementor().registerNamedSQLQueryDefinition(arg0, arg1);
    }
}

