/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapper;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pannotation.CascadeType;
import org.eclipse.emf.teneo.annotations.pannotation.JoinColumn;
import org.eclipse.emf.teneo.annotations.pannotation.OneToOne;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.hibernate.hbmodel.HbAnnotatedEReference;
import org.eclipse.emf.teneo.hibernate.mapper.AbstractAssociationMapper;
import org.eclipse.emf.teneo.simpledom.Element;

public class OneToOneMapper
extends AbstractAssociationMapper
implements ExtensionPoint {
    private static final Log log = LogFactory.getLog(OneToOneMapper.class);

    public void process(PAnnotatedEReference paReference) {
        PAnnotatedEReference opposite = this.getOtherSide(paReference);
        if (opposite != null) {
            if (!paReference.getPrimaryKeyJoinColumns().isEmpty() || !opposite.getPrimaryKeyJoinColumns().isEmpty()) {
                this.createOneToOne(paReference);
            } else if (paReference.getOneToOne().getMappedBy() != null) {
                this.createOneToOne(paReference);
            } else {
                this.createManyToOne(paReference);
            }
        } else {
            this.createManyToOne(paReference);
        }
    }

    private void createManyToOne(PAnnotatedEReference paReference) {
        HbAnnotatedEReference hbReference;
        boolean isAny;
        log.debug((Object)("Generating many to one mapping for onetoone" + paReference));
        OneToOne oto = paReference.getOneToOne();
        EReference eref = paReference.getModelEReference();
        String specifiedName = oto.getTargetEntity();
        if (specifiedName == null) {
            specifiedName = this.getHbmContext().getEntityName(eref.getEReferenceType());
        }
        boolean bl = isAny = (hbReference = (HbAnnotatedEReference)paReference).getAny() != null || hbReference.getAnyMetaDef() != null || this.isEObject(oto.getTargetEntity());
        if (isAny) {
            String assocName = this.getHbmContext().getPropertyName(hbReference.getModelEStructuralFeature());
            Element anyElement = this.createAny(assocName, hbReference, hbReference.getAny(), hbReference.getAnyMetaDef(), false);
            this.getHbmContext().getCurrent().add(anyElement);
            return;
        }
        Element associationElement = this.addManyToOne(this.getHbmContext().getCurrent(), paReference, specifiedName, false);
        this.addAccessor(associationElement);
        this.addCascadesForSingle(associationElement, this.getCascades(hbReference.getHbCascade(), (List<CascadeType>)oto.getCascade()));
        boolean isNullable = oto.isOptional() || this.getHbmContext().isDoForceOptional((PAnnotatedEStructuralFeature)paReference) || this.getHbmContext().isCurrentElementFeatureMap();
        associationElement.addAttribute("not-null", isNullable ? "false" : "true");
        this.addLazyProxy(associationElement, oto.getFetch(), paReference);
        if (hbReference.getHbFetch() != null) {
            associationElement.addAttribute("fetch", hbReference.getHbFetch().getValue().getName().toLowerCase());
        }
        this.addForeignKeyAttribute(associationElement, (PAnnotatedEStructuralFeature)paReference);
        this.addLazyProxy(associationElement, oto.getFetch(), paReference);
        List<JoinColumn> joinColumns = this.getJoinColumns(paReference);
        this.addJoinColumns(paReference, associationElement, joinColumns, isNullable);
        if (!isNullable) {
            associationElement.addAttribute("unique", "true");
        }
    }

    private void createOneToOne(PAnnotatedEReference paReference) {
        boolean addConstrained;
        boolean primaryKeyJoin;
        OneToOne oto;
        String targetName;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generating one to one bidirectional inverse mapping for " + paReference));
        }
        if ((targetName = (oto = paReference.getOneToOne()).getTargetEntity()) == null) {
            targetName = this.getHbmContext().getEntityName(paReference.getEReferenceType());
        }
        HbAnnotatedEReference hbReference = (HbAnnotatedEReference)paReference;
        EReference eref = paReference.getModelEReference();
        EReference otherSide = eref.getEOpposite();
        Element associationElement = this.addOneToOne(paReference, this.getHbmContext().getPropertyName((EStructuralFeature)eref), targetName);
        this.addAccessor(associationElement);
        this.addForeignKeyAttribute(associationElement, (PAnnotatedEStructuralFeature)paReference);
        this.addCascadesForSingle(associationElement, this.getCascades(hbReference.getHbCascade(), (List<CascadeType>)oto.getCascade()));
        this.addLazyProxy(associationElement, oto.getFetch(), paReference);
        if (hbReference.getHbFetch() != null) {
            associationElement.addAttribute("fetch", hbReference.getHbFetch().getValue().getName().toLowerCase());
        }
        boolean bl = primaryKeyJoin = !paReference.getPrimaryKeyJoinColumns().isEmpty() || otherSide != null && !this.getOtherSide(paReference).getPrimaryKeyJoinColumns().isEmpty();
        if (!primaryKeyJoin && otherSide != null && oto.getMappedBy() != null) {
            associationElement.addAttribute("property-ref", this.getHbmContext().getPropertyName((EStructuralFeature)otherSide));
        }
        boolean bl2 = addConstrained = !paReference.getPrimaryKeyJoinColumns().isEmpty();
        if (!addConstrained && otherSide == null) {
            addConstrained = eref.isRequired();
        } else if (!addConstrained && otherSide != null) {
            PAnnotatedEReference aOpposite = paReference.getPaModel().getPAnnotated(otherSide);
            boolean bl3 = addConstrained = aOpposite.getManyToOne() != null && eref.isRequired();
            if (!addConstrained) {
                boolean bl4 = addConstrained = eref.isRequired() && aOpposite.getPrimaryKeyJoinColumns().isEmpty() && aOpposite.getOneToOne() != null && aOpposite.getOneToOne().getMappedBy() == null;
            }
        }
        if (addConstrained) {
            associationElement.addAttribute("constrained", "true");
        }
    }
}

