/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.tests;

import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.examples.extlibrary.Book;
import org.eclipse.emf.examples.extlibrary.BookCategory;
import org.eclipse.emf.examples.extlibrary.EXTLibraryFactory;
import org.eclipse.emf.examples.extlibrary.EXTLibraryPackage;
import org.eclipse.emf.examples.extlibrary.Library;
import org.eclipse.emf.transaction.DemultiplexingListener;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.tests.AbstractTest;
import org.eclipse.emf.transaction.tests.fixtures.ItemDefaultPublicationDateTrigger;
import org.eclipse.emf.transaction.tests.fixtures.LibraryDefaultBookTrigger;
import org.eclipse.emf.transaction.tests.fixtures.LibraryDefaultNameTrigger;
import org.eclipse.emf.transaction.tests.fixtures.TestCommand;
import org.eclipse.emf.transaction.tests.fixtures.TestListener;

public class ResourceSetListenersTest
extends AbstractTest {
    private TestListener listener;

    public ResourceSetListenersTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(ResourceSetListenersTest.class, "Resource Set Listener Framework Tests");
    }

    public void test_postcommit() {
        try {
            Book book = (Book)this.find("root/Root Book");
            ResourceSetListenersTest.assertNotNull((Object)book);
            String newTitle = "New Title";
            SetCommand cmd = new SetCommand((EditingDomain)this.domain, (EObject)book, (EStructuralFeature)EXTLibraryPackage.eINSTANCE.getBook_Title(), (Object)newTitle);
            this.domain.getCommandStack().execute((Command)cmd);
            ResourceSetListenersTest.assertNotNull((Object)this.listener.postcommit);
            ResourceSetListenersTest.assertNotNull((Object)this.listener.postcommit.getTransaction());
            ResourceSetListenersTest.assertFalse((boolean)this.listener.postcommit.getTransaction().isActive());
            ResourceSetListenersTest.assertSame((Object)this.domain, (Object)this.listener.postcommit.getEditingDomain());
            List<Notification> notifications = this.listener.postcommitNotifications;
            ResourceSetListenersTest.assertNotNull(notifications);
            ResourceSetListenersTest.assertEquals((int)1, (int)notifications.size());
            Notification notification = notifications.get(0);
            ResourceSetListenersTest.assertSame((Object)book, (Object)notification.getNotifier());
            ResourceSetListenersTest.assertSame((Object)EXTLibraryPackage.eINSTANCE.getBook_Title(), (Object)notification.getFeature());
            ResourceSetListenersTest.assertSame((Object)newTitle, (Object)notification.getNewValue());
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void test_postcommit_nestedChange() {
        try {
            this.startReading();
            final Book book = (Book)this.find("root/Root Book");
            this.commit();
            ResourceSetListenersTest.assertNotNull((Object)book);
            String newTitle = "New Title";
            TestCommand cmd = new TestCommand(){

                public void execute() {
                    try {
                        ResourceSetListenersTest.this.startWriting();
                        book.setTitle("New Title");
                        ResourceSetListenersTest.this.commit();
                        ResourceSetListenersTest.assertNull((Object)((ResourceSetListenersTest)ResourceSetListenersTest.this).listener.postcommit);
                    }
                    catch (Exception e) {
                        ResourceSetListenersTest.this.fail(e);
                    }
                }
            };
            this.domain.getCommandStack().execute((Command)cmd);
            ResourceSetListenersTest.assertNotNull((Object)this.listener.postcommit);
            ResourceSetListenersTest.assertNotNull((Object)this.listener.postcommit.getTransaction());
            ResourceSetListenersTest.assertFalse((boolean)this.listener.postcommit.getTransaction().isActive());
            ResourceSetListenersTest.assertSame((Object)this.domain, (Object)this.listener.postcommit.getEditingDomain());
            List<Notification> notifications = this.listener.postcommitNotifications;
            ResourceSetListenersTest.assertNotNull(notifications);
            ResourceSetListenersTest.assertEquals((int)1, (int)notifications.size());
            Notification notification = notifications.get(0);
            ResourceSetListenersTest.assertSame((Object)book, (Object)notification.getNotifier());
            ResourceSetListenersTest.assertSame((Object)EXTLibraryPackage.eINSTANCE.getBook_Title(), (Object)notification.getFeature());
            ResourceSetListenersTest.assertSame((Object)"New Title", (Object)notification.getNewValue());
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void test_postcommit_ordering() {
        try {
            this.startReading();
            final Book book = (Book)this.find("root/Root Book");
            ResourceSetListenersTest.assertNotNull((Object)book);
            this.commit();
            String newTitle = "New Title";
            TestCommand cmd = new TestCommand(){

                public void execute() {
                    try {
                        book.setCategory(BookCategory.BIOGRAPHY_LITERAL);
                        ResourceSetListenersTest.this.startWriting();
                        book.setTitle("New Title");
                        ResourceSetListenersTest.this.commit();
                        book.setPages(500);
                    }
                    catch (Exception e) {
                        ResourceSetListenersTest.this.fail(e);
                    }
                }
            };
            this.domain.getCommandStack().execute((Command)cmd);
            ResourceSetListenersTest.assertNotNull((Object)this.listener.postcommit);
            ResourceSetListenersTest.assertNotNull((Object)this.listener.postcommit.getTransaction());
            ResourceSetListenersTest.assertFalse((boolean)this.listener.postcommit.getTransaction().isActive());
            ResourceSetListenersTest.assertSame((Object)this.domain, (Object)this.listener.postcommit.getEditingDomain());
            List<Notification> notifications = this.listener.postcommitNotifications;
            ResourceSetListenersTest.assertNotNull(notifications);
            ResourceSetListenersTest.assertEquals((int)3, (int)notifications.size());
            Notification notification = notifications.get(0);
            ResourceSetListenersTest.assertSame((Object)book, (Object)notification.getNotifier());
            ResourceSetListenersTest.assertSame((Object)EXTLibraryPackage.eINSTANCE.getBook_Category(), (Object)notification.getFeature());
            ResourceSetListenersTest.assertSame((Object)BookCategory.BIOGRAPHY_LITERAL, (Object)notification.getNewValue());
            notification = notifications.get(1);
            ResourceSetListenersTest.assertSame((Object)book, (Object)notification.getNotifier());
            ResourceSetListenersTest.assertSame((Object)EXTLibraryPackage.eINSTANCE.getBook_Title(), (Object)notification.getFeature());
            ResourceSetListenersTest.assertSame((Object)"New Title", (Object)notification.getNewValue());
            notification = notifications.get(2);
            ResourceSetListenersTest.assertSame((Object)book, (Object)notification.getNotifier());
            ResourceSetListenersTest.assertSame((Object)EXTLibraryPackage.eINSTANCE.getBook_Pages(), (Object)notification.getFeature());
            ResourceSetListenersTest.assertEquals((Object)new Integer(500), (Object)notification.getNewValue());
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void test_postcommit_readOnly() {
        this.startReading();
        final Book book = (Book)this.find("root/Root Book");
        ResourceSetListenersTest.assertNotNull((Object)book);
        this.commit();
        TestListener testListener = new TestListener(){

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                try {
                    ResourceSetListenersTest.this.domain.runExclusive(new Runnable(){

                        public void run() {
                        }
                    });
                }
                catch (Exception e) {
                    ResourceSetListenersTest.this.fail(e);
                }
                try {
                    ResourceSetListenersTest.this.domain.getCommandStack().execute((Command)new TestCommand(){

                        public void execute() {
                        }
                    });
                    ResourceSetListenersTest.fail((String)"Should have thrown IllegalStateException");
                }
                catch (Exception e) {
                    ResourceSetListenersTest.trace("Got expected exception: " + e.getLocalizedMessage());
                }
                try {
                    book.setCategory(BookCategory.BIOGRAPHY_LITERAL);
                    ResourceSetListenersTest.fail((String)"Should have thrown IllegalStateException");
                }
                catch (Exception e) {
                    ResourceSetListenersTest.trace("Got expected exception: " + e.getLocalizedMessage());
                }
            }
        };
        try {
            try {
                this.domain.addResourceSetListener((ResourceSetListener)testListener);
                String newTitle = "New Title";
                SetCommand cmd = new SetCommand((EditingDomain)this.domain, (EObject)book, (EStructuralFeature)EXTLibraryPackage.eINSTANCE.getBook_Title(), (Object)newTitle);
                this.domain.getCommandStack().execute((Command)cmd);
            }
            catch (Exception e) {
                this.fail(e);
                this.domain.removeResourceSetListener((ResourceSetListener)testListener);
            }
        }
        finally {
            this.domain.removeResourceSetListener((ResourceSetListener)testListener);
        }
    }

    public void test_precommit() {
        try {
            this.startReading();
            Book book = (Book)this.find("root/Root Book");
            ResourceSetListenersTest.assertNotNull((Object)book);
            this.commit();
            String newTitle = "New Title";
            SetCommand cmd = new SetCommand((EditingDomain)this.domain, (EObject)book, (EStructuralFeature)EXTLibraryPackage.eINSTANCE.getBook_Title(), (Object)newTitle);
            this.domain.getCommandStack().execute((Command)cmd);
            ResourceSetListenersTest.assertNotNull((Object)this.listener.precommit);
            ResourceSetListenersTest.assertNotNull((Object)this.listener.precommit.getTransaction());
            ResourceSetListenersTest.assertFalse((boolean)this.listener.precommit.getTransaction().isActive());
            ResourceSetListenersTest.assertSame((Object)this.domain, (Object)this.listener.precommit.getEditingDomain());
            List<Notification> notifications = this.listener.precommitNotifications;
            ResourceSetListenersTest.assertNotNull(notifications);
            ResourceSetListenersTest.assertEquals((int)1, (int)notifications.size());
            Notification notification = notifications.get(0);
            ResourceSetListenersTest.assertSame((Object)book, (Object)notification.getNotifier());
            ResourceSetListenersTest.assertSame((Object)EXTLibraryPackage.eINSTANCE.getBook_Title(), (Object)notification.getFeature());
            ResourceSetListenersTest.assertSame((Object)newTitle, (Object)notification.getNewValue());
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void test_precommit_nestedChange() {
        try {
            this.startReading();
            final Book book = (Book)this.find("root/Root Book");
            ResourceSetListenersTest.assertNotNull((Object)book);
            this.commit();
            String newTitle = "New Title";
            TestCommand cmd = new TestCommand(){

                public void execute() {
                    try {
                        ResourceSetListenersTest.this.startWriting();
                        book.setTitle("New Title");
                        ResourceSetListenersTest.this.commit();
                        ResourceSetListenersTest.this.listener.reset();
                    }
                    catch (Exception e) {
                        ResourceSetListenersTest.this.fail(e);
                    }
                }
            };
            this.domain.getCommandStack().execute((Command)cmd);
            ResourceSetListenersTest.assertNull((Object)this.listener.precommit);
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void test_precommit_nestedChange2() {
        try {
            this.startReading();
            final Book book = (Book)this.find("root/Root Book");
            ResourceSetListenersTest.assertNotNull((Object)book);
            this.commit();
            String newTitle = "New Title";
            TestCommand cmd = new TestCommand(){

                public void execute() {
                    try {
                        book.setCategory(BookCategory.BIOGRAPHY_LITERAL);
                        ResourceSetListenersTest.this.startWriting();
                        book.setTitle("New Title");
                        ResourceSetListenersTest.this.commit();
                        ResourceSetListenersTest.assertNotNull((Object)((ResourceSetListenersTest)ResourceSetListenersTest.this).listener.precommit);
                        ResourceSetListenersTest.assertNotNull((Object)((ResourceSetListenersTest)ResourceSetListenersTest.this).listener.precommit.getTransaction());
                        ResourceSetListenersTest.assertFalse((boolean)((ResourceSetListenersTest)ResourceSetListenersTest.this).listener.precommit.getTransaction().isActive());
                        ResourceSetListenersTest.assertSame((Object)ResourceSetListenersTest.this.domain, (Object)((ResourceSetListenersTest)ResourceSetListenersTest.this).listener.precommit.getEditingDomain());
                        List<Notification> notifications = ((ResourceSetListenersTest)ResourceSetListenersTest.this).listener.precommitNotifications;
                        ResourceSetListenersTest.assertNotNull(notifications);
                        ResourceSetListenersTest.assertEquals((int)1, (int)notifications.size());
                        Notification notification = notifications.get(0);
                        ResourceSetListenersTest.assertSame((Object)book, (Object)notification.getNotifier());
                        ResourceSetListenersTest.assertSame((Object)EXTLibraryPackage.eINSTANCE.getBook_Title(), (Object)notification.getFeature());
                        ResourceSetListenersTest.assertSame((Object)"New Title", (Object)notification.getNewValue());
                        ResourceSetListenersTest.this.listener.reset();
                    }
                    catch (Exception e) {
                        ResourceSetListenersTest.this.fail(e);
                    }
                }
            };
            this.domain.getCommandStack().execute((Command)cmd);
            ResourceSetListenersTest.assertNotNull((Object)this.listener.precommit);
            ResourceSetListenersTest.assertNotNull((Object)this.listener.precommit.getTransaction());
            ResourceSetListenersTest.assertFalse((boolean)this.listener.precommit.getTransaction().isActive());
            ResourceSetListenersTest.assertSame((Object)this.domain, (Object)this.listener.precommit.getEditingDomain());
            List<Notification> notifications = this.listener.precommitNotifications;
            ResourceSetListenersTest.assertNotNull(notifications);
            ResourceSetListenersTest.assertEquals((int)1, (int)notifications.size());
            Notification notification = notifications.get(0);
            ResourceSetListenersTest.assertSame((Object)book, (Object)notification.getNotifier());
            ResourceSetListenersTest.assertSame((Object)EXTLibraryPackage.eINSTANCE.getBook_Category(), (Object)notification.getFeature());
            ResourceSetListenersTest.assertSame((Object)BookCategory.BIOGRAPHY_LITERAL, (Object)notification.getNewValue());
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void test_precommit_readOnly() {
        this.startReading();
        final Book book = (Book)this.find("root/Root Book");
        ResourceSetListenersTest.assertNotNull((Object)book);
        this.commit();
        TestListener testListener = new TestListener(){

            public Command transactionAboutToCommit(ResourceSetChangeEvent event) {
                try {
                    ResourceSetListenersTest.this.domain.runExclusive(new Runnable(){

                        public void run() {
                        }
                    });
                }
                catch (Exception e) {
                    ResourceSetListenersTest.this.fail(e);
                }
                try {
                    ResourceSetListenersTest.this.domain.getCommandStack().execute((Command)new TestCommand(){

                        public void execute() {
                        }
                    });
                    ResourceSetListenersTest.fail((String)"Should have thrown IllegalStateException");
                }
                catch (Exception e) {
                    ResourceSetListenersTest.trace("Got expected exception: " + e.getLocalizedMessage());
                }
                try {
                    book.setCategory(BookCategory.BIOGRAPHY_LITERAL);
                    ResourceSetListenersTest.fail((String)"Should have thrown IllegalStateException");
                }
                catch (Exception e) {
                    ResourceSetListenersTest.trace("Got expected exception: " + e.getLocalizedMessage());
                }
                return null;
            }
        };
        try {
            try {
                this.domain.addResourceSetListener((ResourceSetListener)testListener);
                String newTitle = "New Title";
                SetCommand cmd = new SetCommand((EditingDomain)this.domain, (EObject)book, (EStructuralFeature)EXTLibraryPackage.eINSTANCE.getBook_Title(), (Object)newTitle);
                this.domain.getCommandStack().execute((Command)cmd);
            }
            catch (Exception e) {
                this.fail(e);
                this.domain.removeResourceSetListener((ResourceSetListener)testListener);
            }
        }
        finally {
            this.domain.removeResourceSetListener((ResourceSetListener)testListener);
        }
    }

    public void test_precommit_cannotClose() {
        this.startReading();
        Book book = (Book)this.find("root/Root Book");
        ResourceSetListenersTest.assertNotNull((Object)book);
        this.commit();
        TestListener testListener = new TestListener(){

            public Command transactionAboutToCommit(ResourceSetChangeEvent event) {
                try {
                    event.getTransaction().commit();
                    ResourceSetListenersTest.fail((String)"Should have thrown IllegalStateException");
                }
                catch (Exception e) {
                    ResourceSetListenersTest.trace("Got expected exception: " + e.getLocalizedMessage());
                }
                try {
                    event.getTransaction().rollback();
                    ResourceSetListenersTest.fail((String)"Should have thrown IllegalStateException");
                }
                catch (Exception e) {
                    ResourceSetListenersTest.trace("Got expected exception: " + e.getLocalizedMessage());
                }
                return null;
            }
        };
        try {
            try {
                this.domain.addResourceSetListener((ResourceSetListener)testListener);
                String newTitle = "New Title";
                SetCommand cmd = new SetCommand((EditingDomain)this.domain, (EObject)book, (EStructuralFeature)EXTLibraryPackage.eINSTANCE.getBook_Title(), (Object)newTitle);
                this.domain.getCommandStack().execute((Command)cmd);
            }
            catch (Exception e) {
                this.fail(e);
                this.domain.removeResourceSetListener((ResourceSetListener)testListener);
            }
        }
        finally {
            this.domain.removeResourceSetListener((ResourceSetListener)testListener);
        }
    }

    public void test_triggerCommands() {
        this.domain.addResourceSetListener((ResourceSetListener)new LibraryDefaultNameTrigger());
        this.domain.addResourceSetListener((ResourceSetListener)new LibraryDefaultBookTrigger());
        this.startWriting();
        Library newLibrary = EXTLibraryFactory.eINSTANCE.createLibrary();
        this.root.getBranches().add((Object)newLibrary);
        ResourceSetListenersTest.assertNull((Object)newLibrary.getName());
        ResourceSetListenersTest.assertTrue((boolean)newLibrary.getBranches().isEmpty());
        this.commit();
        this.startReading();
        ResourceSetListenersTest.assertEquals((String)"New Library", (String)newLibrary.getName());
        ResourceSetListenersTest.assertEquals((int)1, (int)newLibrary.getBooks().size());
        ResourceSetListenersTest.assertEquals((String)"New Book", (String)((Book)newLibrary.getBooks().get(0)).getTitle());
        this.commit();
    }

    public void test_triggerCommands_cascading() {
        this.domain.addResourceSetListener((ResourceSetListener)new LibraryDefaultBookTrigger());
        this.domain.addResourceSetListener((ResourceSetListener)new ItemDefaultPublicationDateTrigger());
        this.startWriting();
        Library newLibrary = EXTLibraryFactory.eINSTANCE.createLibrary();
        this.root.getBranches().add((Object)newLibrary);
        ResourceSetListenersTest.assertNull((Object)newLibrary.getName());
        ResourceSetListenersTest.assertTrue((boolean)newLibrary.getBranches().isEmpty());
        this.commit();
        this.startReading();
        ResourceSetListenersTest.assertEquals((int)1, (int)newLibrary.getBooks().size());
        Book book = (Book)newLibrary.getBooks().get(0);
        ResourceSetListenersTest.assertEquals((String)"New Book", (String)book.getTitle());
        ResourceSetListenersTest.assertNotNull((Object)book.getPublicationDate());
        this.commit();
    }

    public void test_postcommitIncludesTriggerChanges() {
        this.domain.addResourceSetListener((ResourceSetListener)new LibraryDefaultBookTrigger());
        this.domain.addResourceSetListener((ResourceSetListener)new ItemDefaultPublicationDateTrigger());
        this.startWriting();
        TestListener testListener = new TestListener();
        this.domain.addResourceSetListener((ResourceSetListener)testListener);
        Library newLibrary = EXTLibraryFactory.eINSTANCE.createLibrary();
        this.root.getBranches().add((Object)newLibrary);
        ResourceSetListenersTest.assertNull((Object)newLibrary.getName());
        ResourceSetListenersTest.assertTrue((boolean)newLibrary.getBranches().isEmpty());
        this.commit();
        ResourceSetListenersTest.assertNotNull((Object)testListener.postcommit);
        ResourceSetListenersTest.assertNotNull(testListener.postcommitNotifications);
        ResourceSetListenersTest.assertEquals((int)4, (int)testListener.postcommitNotifications.size());
    }

    public void test_unbatchedNotifications() {
        try {
            Resource newRes = this.domain.createResource("/tmp/test_unbatched.extlibrary");
            ResourceSetListenersTest.assertNotNull((Object)this.listener.postcommit);
            List<Notification> notifications = this.listener.postcommitNotifications;
            ResourceSetListenersTest.assertNotNull(notifications);
            ResourceSetListenersTest.assertEquals((int)1, (int)notifications.size());
            Notification notification = notifications.get(0);
            ResourceSetListenersTest.assertSame((Object)this.domain.getResourceSet(), (Object)notification.getNotifier());
            ResourceSetListenersTest.assertEquals((int)3, (int)notification.getEventType());
            ResourceSetListenersTest.assertEquals((int)0, (int)notification.getFeatureID(null));
            ResourceSetListenersTest.assertSame((Object)newRes, (Object)notification.getNewValue());
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void test_unbatchedNotifications_reuseEvents_128445() {
        try {
            this.testResource.unload();
            class Listener
            extends ResourceSetListenerImpl {
                ResourceSetChangeEvent lastEvent = null;
                List<Notification> lastNotifications = null;
                int count = 0;

                Listener() {
                }

                public void resourceSetChanged(ResourceSetChangeEvent event) {
                    ++this.count;
                    if (this.lastEvent == null) {
                        this.lastEvent = event;
                        this.lastNotifications = event.getNotifications();
                    } else {
                        ResourceSetListenersTest.assertSame((Object)this.lastEvent, (Object)event);
                        ResourceSetListenersTest.assertSame(this.lastNotifications, (Object)event.getNotifications());
                        ResourceSetListenersTest.assertEquals((int)1, (int)this.lastNotifications.size());
                    }
                }
            }
            Listener localListener = new Listener();
            this.domain.addResourceSetListener((ResourceSetListener)localListener);
            this.testResource.load(Collections.EMPTY_MAP);
            ResourceSetListenersTest.assertTrue((localListener.count > 1 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void test_readNotifications_cascading() {
        final Resource[] newRes = new Resource[1];
        TestListener testListener = new TestListener(){

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                URI uri = URI.createFileURI((String)"/tmp/test_readCascade.extlibrary");
                if (ResourceSetListenersTest.this.domain.getResourceSet().getResource(uri, false) == null) {
                    ResourceSetListenersTest.this.listener.reset();
                    newRes[0] = ResourceSetListenersTest.this.domain.getResourceSet().createResource(uri);
                }
            }
        };
        this.domain.addResourceSetListener((ResourceSetListener)testListener);
        try {
            this.startWriting();
            Library newLibrary = EXTLibraryFactory.eINSTANCE.createLibrary();
            this.root.getBranches().add((Object)newLibrary);
            this.commit();
            ResourceSetListenersTest.assertNotNull((Object)newRes[0]);
            ResourceSetListenersTest.assertNotNull((Object)this.listener.postcommit);
            List<Notification> notifications = this.listener.postcommitNotifications;
            ResourceSetListenersTest.assertNotNull(notifications);
            ResourceSetListenersTest.assertEquals((int)1, (int)notifications.size());
            Notification notification = notifications.get(0);
            ResourceSetListenersTest.assertSame((Object)this.domain.getResourceSet(), (Object)notification.getNotifier());
            ResourceSetListenersTest.assertEquals((int)3, (int)notification.getEventType());
            ResourceSetListenersTest.assertEquals((int)0, (int)notification.getFeatureID(null));
            ResourceSetListenersTest.assertSame((Object)newRes[0], (Object)notification.getNewValue());
        }
        finally {
            this.domain.removeResourceSetListener((ResourceSetListener)testListener);
        }
    }

    public void test_precommit_aggregated_121508() {
        try {
            class AggregatedListener
            extends TestListener {
                int count = 0;

                AggregatedListener() {
                }

                public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
                    ++this.count;
                    return super.transactionAboutToCommit(event);
                }

                public void reset() {
                    super.reset();
                    this.count = 0;
                }

                public boolean isAggregatePrecommitListener() {
                    return true;
                }
            }
            AggregatedListener localListener = new AggregatedListener();
            this.domain.addResourceSetListener((ResourceSetListener)localListener);
            this.startReading();
            Book book = (Book)this.find("root/Root Book");
            ResourceSetListenersTest.assertNotNull((Object)book);
            this.commit();
            String newTitle1 = "New Title1";
            String newTitle2 = "New Title2";
            this.startWriting();
            book.setTitle(newTitle1);
            this.startWriting();
            book.setTitle(newTitle2);
            this.commit();
            this.commit();
            ResourceSetListenersTest.assertNotNull((Object)localListener.precommit);
            ResourceSetListenersTest.assertNotNull((Object)localListener.precommit.getTransaction());
            ResourceSetListenersTest.assertEquals((int)1, (int)localListener.count);
            List notifications = localListener.precommitNotifications;
            ResourceSetListenersTest.assertNotNull((Object)notifications);
            ResourceSetListenersTest.assertEquals((int)2, (int)notifications.size());
            Notification notification = (Notification)notifications.get(0);
            ResourceSetListenersTest.assertSame((Object)book, (Object)notification.getNotifier());
            ResourceSetListenersTest.assertSame((Object)EXTLibraryPackage.eINSTANCE.getBook_Title(), (Object)notification.getFeature());
            ResourceSetListenersTest.assertSame((Object)newTitle1, (Object)notification.getNewValue());
            notification = (Notification)notifications.get(1);
            ResourceSetListenersTest.assertSame((Object)book, (Object)notification.getNotifier());
            ResourceSetListenersTest.assertSame((Object)EXTLibraryPackage.eINSTANCE.getBook_Title(), (Object)notification.getFeature());
            ResourceSetListenersTest.assertSame((Object)newTitle2, (Object)notification.getNewValue());
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void test_precommit_aggregatedCascade_121508() {
        try {
            String newTitle1 = "New Title1";
            String newTitle2 = "New Title2";
            class AggregatedListener
            extends TestListener {
                int count = 0;

                AggregatedListener() {
                }

                public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
                    ++this.count;
                    super.transactionAboutToCommit(event);
                    if (this.count < 2) {
                        List notifications = event.getNotifications();
                        ResourceSetListenersTest.assertNotNull((Object)notifications);
                        ResourceSetListenersTest.assertEquals((int)1, (int)notifications.size());
                        Notification notification = (Notification)notifications.get(0);
                        ResourceSetListenersTest.assertSame((Object)EXTLibraryPackage.eINSTANCE.getBook_Title(), (Object)notification.getFeature());
                        ResourceSetListenersTest.assertSame((Object)"New Title1", (Object)notification.getNewValue());
                        Book book = (Book)notification.getNotifier();
                        return new SetCommand((EditingDomain)ResourceSetListenersTest.this.domain, (EObject)book, (EStructuralFeature)EXTLibraryPackage.eINSTANCE.getBook_Title(), (Object)"New Title2");
                    }
                    return null;
                }

                public void reset() {
                    super.reset();
                    this.count = 0;
                }

                public boolean isAggregatePrecommitListener() {
                    return true;
                }
            }
            AggregatedListener localListener = new AggregatedListener();
            this.domain.addResourceSetListener((ResourceSetListener)localListener);
            this.startReading();
            Book book = (Book)this.find("root/Root Book");
            ResourceSetListenersTest.assertNotNull((Object)book);
            this.commit();
            this.startWriting();
            book.setTitle("New Title1");
            this.commit();
            ResourceSetListenersTest.assertNotNull((Object)localListener.precommit);
            ResourceSetListenersTest.assertNotNull((Object)localListener.precommit.getTransaction());
            ResourceSetListenersTest.assertEquals((int)2, (int)localListener.count);
            List notifications = localListener.precommitNotifications;
            ResourceSetListenersTest.assertNotNull((Object)notifications);
            ResourceSetListenersTest.assertEquals((int)1, (int)notifications.size());
            Notification notification = (Notification)notifications.get(0);
            ResourceSetListenersTest.assertSame((Object)book, (Object)notification.getNotifier());
            ResourceSetListenersTest.assertSame((Object)EXTLibraryPackage.eINSTANCE.getBook_Title(), (Object)notification.getFeature());
            ResourceSetListenersTest.assertSame((Object)"New Title2", (Object)notification.getNewValue());
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void test_rollback_resourceChangePropagation_uri_145321() {
        Resource test1 = this.domain.getResourceSet().createResource(URI.createURI((String)"http://foo1.xmi"));
        Book book = EXTLibraryFactory.eINSTANCE.createBook();
        this.startWriting();
        test1.getContents().add((Object)book);
        this.commit();
        class ResourceListener
        extends DemultiplexingListener {
            boolean wasCalled;

            ResourceListener() {
            }

            protected void handleNotification(TransactionalEditingDomain domain, Notification notification) {
                this.wasCalled = true;
            }
        }
        ResourceListener listener = new ResourceListener();
        this.domain.addResourceSetListener((ResourceSetListener)listener);
        this.startWriting();
        book.setTitle("foo");
        this.rollback();
        ResourceSetListenersTest.assertNull((Object)book.getTitle());
        ResourceSetListenersTest.assertFalse((boolean)listener.wasCalled);
    }

    public void test_rollback_noEvents_145321() {
        Resource test1 = this.domain.getResourceSet().createResource(URI.createURI((String)"http://foo1.xmi"));
        Book book = EXTLibraryFactory.eINSTANCE.createBook();
        class ResourceListener
        extends DemultiplexingListener {
            private final ResourceSet interestingResourceSet;
            private final Book interestingBook;
            boolean changed;

            ResourceListener(ResourceSet resourceSet, Book book) {
                this.interestingResourceSet = resourceSet;
                this.interestingBook = book;
            }

            protected void handleNotification(TransactionalEditingDomain domain, Notification notification) {
                Object notifier = notification.getNotifier();
                if (notifier == this.interestingResourceSet) {
                    int featureID = notification.getFeatureID(ResourceSet.class);
                    switch (featureID) {
                        case 0: {
                            this.changed = true;
                        }
                    }
                } else if (notifier == this.interestingBook) {
                    ResourceSetListenersTest.fail((String)"Should not have received notification of contents change");
                }
            }
        }
        ResourceListener listener = new ResourceListener(this.domain.getResourceSet(), book);
        this.domain.addResourceSetListener((ResourceSetListener)listener);
        this.startWriting();
        test1.getContents().add((Object)book);
        book.setTitle("foo");
        this.rollback();
        ResourceSetListenersTest.assertNull((Object)book.getTitle());
        ResourceSetListenersTest.assertFalse((boolean)listener.changed);
    }

    public void test_rollback_resourceChangePropagation_created_145321() {
        Resource test1 = this.domain.getResourceSet().createResource(URI.createURI((String)"http://foo1.xmi"));
        Book book = EXTLibraryFactory.eINSTANCE.createBook();
        class ResourceListener
        extends DemultiplexingListener {
            private final ResourceSet interestingResourceSet;
            private final Book interestingBook;
            boolean changed;

            ResourceListener(ResourceSet resourceSet, Book book) {
                this.interestingResourceSet = resourceSet;
                this.interestingBook = book;
            }

            protected void handleNotification(TransactionalEditingDomain domain, Notification notification) {
                Object notifier = notification.getNotifier();
                if (notifier == this.interestingResourceSet) {
                    int featureID = notification.getFeatureID(ResourceSet.class);
                    switch (featureID) {
                        case 0: {
                            this.changed = true;
                        }
                    }
                } else if (notifier == this.interestingBook) {
                    ResourceSetListenersTest.fail((String)"Should not have received notification of contents change");
                }
            }
        }
        ResourceListener listener = new ResourceListener(this.domain.getResourceSet(), book);
        this.domain.addResourceSetListener((ResourceSetListener)listener);
        this.startWriting();
        test1.getContents().add((Object)book);
        book.setTitle("foo");
        URI newURI = URI.createURI((String)"http://newfoo.xmi");
        this.domain.getResourceSet().createResource(newURI);
        this.rollback();
        ResourceSetListenersTest.assertNull((Object)book.getTitle());
        ResourceSetListenersTest.assertNotNull((Object)this.domain.getResourceSet().getResource(newURI, false));
        ResourceSetListenersTest.assertTrue((boolean)listener.changed);
    }

    public void test_rollback_resourceChangePropagation_loaded_145321() {
        Resource test1 = this.domain.getResourceSet().createResource(URI.createURI((String)"http://foo1.xmi"));
        Book book = EXTLibraryFactory.eINSTANCE.createBook();
        class ResourceListener
        extends DemultiplexingListener {
            private final Resource interestingResource;
            private final Book interestingBook;
            boolean changed;

            ResourceListener(Resource resource, Book book) {
                this.interestingResource = resource;
                this.interestingBook = book;
            }

            protected void handleNotification(TransactionalEditingDomain domain, Notification notification) {
                Object notifier = notification.getNotifier();
                if (notifier == this.interestingResource) {
                    int featureID = notification.getFeatureID(Resource.class);
                    switch (featureID) {
                        case 4: {
                            this.changed = true;
                        }
                    }
                } else if (notifier == this.interestingBook) {
                    ResourceSetListenersTest.fail((String)"Should not have received notification of contents change");
                }
            }
        }
        ResourceListener listener = new ResourceListener(test1, book);
        this.domain.addResourceSetListener((ResourceSetListener)listener);
        this.startWriting();
        test1.getContents().add((Object)book);
        book.setTitle("foo");
        this.rollback();
        ResourceSetListenersTest.assertNull((Object)book.getTitle());
        ResourceSetListenersTest.assertTrue((boolean)test1.isLoaded());
        ResourceSetListenersTest.assertTrue((boolean)listener.changed);
    }

    public void test_rollback_resourceChangePropagation_unloaded_145321() {
        Resource test1 = this.domain.getResourceSet().createResource(URI.createURI((String)"http://foo1.xmi"));
        Book book = EXTLibraryFactory.eINSTANCE.createBook();
        this.startWriting();
        test1.getContents().add((Object)book);
        this.commit();
        class ResourceListener
        extends DemultiplexingListener {
            private final Resource interestingResource;
            private final Book interestingBook;
            boolean changed;

            ResourceListener(Resource resource, Book book) {
                this.interestingResource = resource;
                this.interestingBook = book;
            }

            protected void handleNotification(TransactionalEditingDomain domain, Notification notification) {
                Object notifier = notification.getNotifier();
                if (notifier == this.interestingResource) {
                    int featureID = notification.getFeatureID(Resource.class);
                    switch (featureID) {
                        case 4: {
                            this.changed = true;
                        }
                    }
                } else if (notifier == this.interestingBook) {
                    ResourceSetListenersTest.fail((String)"Should not have received notification of contents change");
                }
            }
        }
        ResourceListener listener = new ResourceListener(test1, book);
        this.domain.addResourceSetListener((ResourceSetListener)listener);
        this.startWriting();
        book.setTitle("foo");
        test1.unload();
        this.rollback();
        ResourceSetListenersTest.assertNull((Object)book.getTitle());
        ResourceSetListenersTest.assertTrue((boolean)listener.changed);
    }

    public void test_recordingCommandsAsTriggers_bug157103() {
        this.domain.addResourceSetListener((ResourceSetListener)new LibraryDefaultNameTrigger(){

            protected Command trigger(TransactionalEditingDomain domain, Notification notification) {
                RecordingCommand result = null;
                final Library newLibrary = (Library)notification.getNewValue();
                if (newLibrary.getName() == null || newLibrary.getName().length() == 0) {
                    result = new RecordingCommand(domain){

                        protected void doExecute() {
                            newLibrary.setName("New Library");
                        }
                    };
                }
                return result;
            }
        });
        final Library[] newLibrary = new Library[1];
        this.domain.getCommandStack().execute((Command)new RecordingCommand(this.domain){

            protected void doExecute() {
                newLibrary[0] = EXTLibraryFactory.eINSTANCE.createLibrary();
                ResourceSetListenersTest.this.root.getBranches().add((Object)newLibrary[0]);
                ResourceSetListenersTest.assertNull((Object)newLibrary[0].getName());
            }
        });
        this.startReading();
        ResourceSetListenersTest.assertEquals((String)"New Library", (String)newLibrary[0].getName());
        this.commit();
        this.domain.getCommandStack().undo();
        ResourceSetListenersTest.assertFalse((boolean)this.root.getBranches().contains((Object)newLibrary[0]));
        ResourceSetListenersTest.assertNull((Object)newLibrary[0].eResource());
        ResourceSetListenersTest.assertNull((Object)newLibrary[0].getName());
        this.domain.getCommandStack().redo();
        ResourceSetListenersTest.assertTrue((boolean)this.root.getBranches().contains((Object)newLibrary[0]));
        ResourceSetListenersTest.assertEquals((String)"New Library", (String)newLibrary[0].getName());
    }

    public void test_internalListenerNotifications_177642() {
        class LocalListener
        extends ResourceSetListenerImpl {
            private int setCount;
            private int unsetCount;

            LocalListener() {
            }

            void assertTarget(TransactionalEditingDomain domain) {
                ResourceSetListenersTest.assertSame((Object)domain, (Object)this.getTarget());
            }

            void assertSetCount(int count) {
                ResourceSetListenersTest.assertEquals((int)count, (int)this.setCount);
            }

            void assertUnsetCount(int count) {
                ResourceSetListenersTest.assertEquals((int)count, (int)this.unsetCount);
            }

            public void setTarget(TransactionalEditingDomain domain) {
                super.setTarget(domain);
                ++this.setCount;
            }

            public void unsetTarget(TransactionalEditingDomain domain) {
                ++this.unsetCount;
                super.unsetTarget(domain);
            }
        }
        LocalListener l = new LocalListener();
        this.domain.addResourceSetListener((ResourceSetListener)l);
        l.assertSetCount(1);
        l.assertTarget(this.domain);
        l.assertUnsetCount(0);
        this.domain.addResourceSetListener((ResourceSetListener)l);
        l.assertSetCount(1);
        l.assertTarget(this.domain);
        l.assertUnsetCount(0);
        this.domain.removeResourceSetListener((ResourceSetListener)l);
        l.assertSetCount(1);
        l.assertTarget(null);
        l.assertUnsetCount(1);
        this.domain.removeResourceSetListener((ResourceSetListener)l);
        l.assertSetCount(1);
        l.assertTarget(null);
        l.assertUnsetCount(1);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.testResource.setTrackingModification(false);
        this.listener = new TestListener();
        this.domain.addResourceSetListener((ResourceSetListener)this.listener);
    }

    protected void doTearDown() throws Exception {
        this.domain.removeResourceSetListener((ResourceSetListener)this.listener);
        this.listener = null;
        super.doTearDown();
    }
}

