/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.tests;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.examples.extlibrary.Book;
import org.eclipse.emf.examples.extlibrary.EXTLibraryFactory;
import org.eclipse.emf.examples.extlibrary.EXTLibraryPackage;
import org.eclipse.emf.examples.extlibrary.Writer;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.TransactionImpl;
import org.eclipse.emf.transaction.tests.AbstractTest;
import org.eclipse.emf.transaction.tests.ValidationRollbackTest;
import org.eclipse.emf.transaction.tests.fixtures.TestListener;
import org.eclipse.emf.transaction.util.TransactionUtil;

public class TransactionOptionsTest
extends AbstractTest {
    public TransactionOptionsTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(TransactionOptionsTest.class, "Transaction Options Tests");
    }

    public void test_noNotifications() {
        TestListener listener = new TestListener();
        this.domain.addResourceSetListener((ResourceSetListener)listener);
        this.startWriting("silent");
        Book book = (Book)this.find("root/Root Book");
        TransactionOptionsTest.assertNotNull((Object)book);
        String newTitle = "New Title";
        Writer newAuthor = (Writer)this.find("root/level1/Level1 Writer");
        TransactionOptionsTest.assertNotNull((Object)newAuthor);
        book.setTitle("New Title");
        newAuthor.getBooks().add((Object)book);
        this.commit();
        TransactionOptionsTest.assertNull((Object)listener.postcommit);
    }

    public void test_noTriggers() {
        TestListener listener = new TestListener();
        this.domain.addResourceSetListener((ResourceSetListener)listener);
        this.startWriting("no_triggers");
        Book book = (Book)this.find("root/Root Book");
        TransactionOptionsTest.assertNotNull((Object)book);
        String newTitle = "New Title";
        Writer newAuthor = (Writer)this.find("root/level1/Level1 Writer");
        TransactionOptionsTest.assertNotNull((Object)newAuthor);
        book.setTitle("New Title");
        newAuthor.getBooks().add((Object)book);
        this.commit();
        TransactionOptionsTest.assertNull((Object)listener.precommit);
    }

    public void test_noValidation() {
        try {
            ValidationRollbackTest.validationEnabled = true;
            this.startWriting("no_validation");
            Book book = (Book)this.find("root/Root Book");
            TransactionOptionsTest.assertNotNull((Object)book);
            book.setTitle(null);
            this.commit();
            this.startReading();
            TransactionOptionsTest.assertNull((Object)book.getTitle());
            this.commit();
        }
        finally {
            ValidationRollbackTest.validationEnabled = false;
        }
    }

    public void test_noUndo() {
        this.startWriting("no_undo");
        InternalTransaction tx = this.getActiveTransaction();
        Book book = (Book)this.find("root/Root Book");
        TransactionOptionsTest.assertNotNull((Object)book);
        String newTitle = "New Title";
        Writer newAuthor = (Writer)this.find("root/level1/Level1 Writer");
        TransactionOptionsTest.assertNotNull((Object)newAuthor);
        book.setTitle("New Title");
        newAuthor.getBooks().add((Object)book);
        this.commit();
        TransactionOptionsTest.assertTrue((boolean)tx.getChangeDescription().isEmpty());
    }

    public void test_noUndo_recordingCommand() {
        RecordingCommand cmd = new RecordingCommand(this.domain){

            protected void doExecute() {
                Book book = (Book)TransactionOptionsTest.this.find("root/Root Book");
                TransactionOptionsTest.assertNotNull((Object)book);
                String newTitle = "New Title";
                Writer newAuthor = (Writer)TransactionOptionsTest.this.find("root/level1/Level1 Writer");
                TransactionOptionsTest.assertNotNull((Object)newAuthor);
                book.setTitle("New Title");
                newAuthor.getBooks().add((Object)book);
            }
        };
        try {
            this.getCommandStack().execute((Command)cmd, this.makeOptions("no_undo"));
        }
        catch (Exception e) {
            this.fail(e);
        }
        TransactionOptionsTest.assertTrue((boolean)this.getCommandStack().canUndo());
        this.getCommandStack().undo();
        this.startReading();
        Book book = (Book)this.find("root/New Title");
        TransactionOptionsTest.assertNotNull((Object)book.getTitle());
        TransactionOptionsTest.assertSame((Object)this.find("root/level1/Level1 Writer"), (Object)book.getAuthor());
        this.commit();
    }

    public void test_noUndo_regularCommand() {
        this.startReading();
        Book book = (Book)this.find("root/Root Book");
        TransactionOptionsTest.assertNotNull((Object)book);
        String newTitle = "New Title";
        SetCommand cmd = new SetCommand((EditingDomain)this.domain, (EObject)book, (EStructuralFeature)EXTLibraryPackage.eINSTANCE.getBook_Title(), (Object)"New Title");
        this.commit();
        try {
            this.getCommandStack().execute((Command)cmd, this.makeOptions("no_undo"));
        }
        catch (Exception e) {
            this.fail(e);
        }
        TransactionOptionsTest.assertTrue((boolean)this.getCommandStack().canUndo());
    }

    public void test_unprotected() {
        TestListener listener = new TestListener();
        this.domain.addResourceSetListener((ResourceSetListener)listener);
        this.startReading();
        Book book = (Book)this.find("root/Root Book");
        TransactionOptionsTest.assertNotNull((Object)book);
        String newTitle = "New Title";
        Writer newAuthor = (Writer)this.find("root/level1/Level1 Writer");
        TransactionOptionsTest.assertNotNull((Object)newAuthor);
        this.startWriting("unprotected");
        book.setTitle("New Title");
        newAuthor.getBooks().add((Object)book);
        this.commit();
        TransactionOptionsTest.assertSame((Object)"New Title", (Object)book.getTitle());
        TransactionOptionsTest.assertSame((Object)newAuthor, (Object)book.getAuthor());
        this.commit();
        TransactionOptionsTest.assertNotNull((Object)listener.postcommit);
        TransactionOptionsTest.assertNotNull(listener.postcommitNotifications);
        TransactionOptionsTest.assertEquals((int)3, (int)listener.postcommitNotifications.size());
    }

    public void test_nested_noNotifications_124334() {
        TestListener listener = new TestListener();
        this.domain.addResourceSetListener((ResourceSetListener)listener);
        this.startWriting();
        this.startWriting("silent");
        Book book = (Book)this.find("root/Root Book");
        TransactionOptionsTest.assertNotNull((Object)book);
        String newTitle = "New Title";
        Writer newAuthor = (Writer)this.find("root/level1/Level1 Writer");
        TransactionOptionsTest.assertNotNull((Object)newAuthor);
        book.setTitle("New Title");
        newAuthor.getBooks().add((Object)book);
        this.commit();
        this.commit();
        TransactionOptionsTest.assertNull((Object)listener.postcommit);
    }

    public void test_nested_unvalidatedPostCommit_124334() {
        TestListener listener = new TestListener();
        this.domain.addResourceSetListener((ResourceSetListener)listener);
        this.startWriting();
        this.startWriting("no_validation");
        Book book = (Book)this.find("root/Root Book");
        TransactionOptionsTest.assertNotNull((Object)book);
        String newTitle = null;
        Writer newAuthor = (Writer)this.find("root/level1/Level1 Writer");
        TransactionOptionsTest.assertNotNull((Object)newAuthor);
        book.setTitle(newTitle);
        newAuthor.getBooks().add((Object)book);
        this.commit();
        this.commit();
        TransactionOptionsTest.assertNotNull((Object)listener.postcommit);
    }

    public void test_nested_unvalidated_124334() {
        this.startWriting();
        InternalTransaction tx = this.getActiveTransaction();
        this.startWriting("no_validation");
        Book book1 = (Book)this.find("root/Root Book");
        TransactionOptionsTest.assertNotNull((Object)book1);
        Book book2 = (Book)this.find("root/level1/Level1 Book");
        TransactionOptionsTest.assertNotNull((Object)book2);
        String newTitle = null;
        book1.setTitle(newTitle);
        this.commit();
        book2.setTitle(newTitle);
        try {
            tx.commit();
            TransactionOptionsTest.fail((String)"Should have rolled back because of outer transaction validation");
        }
        catch (RollbackException e) {
            Collection<IStatus> errors = this.findValidationStatuses(e.getStatus(), 4);
            TransactionOptionsTest.assertEquals((int)1, (int)errors.size());
        }
    }

    public void test_transactionOptionInheritance_135569() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        this.startWriting();
        Map active = this.getActiveTransaction().getOptions();
        TransactionOptionsTest.assertTrue((boolean)this.getActiveTransaction().getOptions().isEmpty());
        this.startWriting();
        active = this.getActiveTransaction().getOptions();
        TransactionOptionsTest.assertTrue((boolean)this.getActiveTransaction().getOptions().isEmpty());
        this.commit();
        this.commit();
        options.put("no_undo", Boolean.TRUE);
        Object marker = new Object();
        options.put("my own option", marker);
        this.startWriting(options);
        active = this.getActiveTransaction().getOptions();
        TransactionOptionsTest.assertSame((Object)Boolean.TRUE, active.get("no_undo"));
        TransactionOptionsTest.assertSame((Object)marker, active.get("my own option"));
        this.startWriting();
        active = this.getActiveTransaction().getOptions();
        TransactionOptionsTest.assertSame((Object)Boolean.TRUE, active.get("no_undo"));
        TransactionOptionsTest.assertSame((Object)marker, active.get("my own option"));
        this.commit();
        this.commit();
        options.put("no_undo", Boolean.TRUE);
        marker = new Object();
        options.put("my own option", marker);
        this.startWriting(options);
        options.put("no_undo", Boolean.FALSE);
        Object marker2 = new Object();
        options.put("my own option", marker2);
        active = this.getActiveTransaction().getOptions();
        TransactionOptionsTest.assertSame((Object)Boolean.TRUE, active.get("no_undo"));
        TransactionOptionsTest.assertSame((Object)marker, active.get("my own option"));
        this.startWriting(options);
        active = this.getActiveTransaction().getOptions();
        TransactionOptionsTest.assertSame((Object)Boolean.FALSE, active.get("no_undo"));
        TransactionOptionsTest.assertSame((Object)marker2, active.get("my own option"));
        this.commit();
        this.commit();
    }

    public void test_notificationsNotRetainedAfterCommit_152335() {
        this.startWriting();
        InternalTransaction tx = this.getActiveTransaction();
        Book book = (Book)this.find("root/Root Book");
        TransactionOptionsTest.assertNotNull((Object)book);
        String newTitle = "New Title";
        Writer newAuthor = (Writer)this.find("root/level1/Level1 Writer");
        TransactionOptionsTest.assertNotNull((Object)newAuthor);
        book.setTitle("New Title");
        newAuthor.getBooks().add((Object)book);
        TransactionOptionsTest.assertFalse((boolean)tx.getNotifications().isEmpty());
        this.commit();
        TransactionOptionsTest.assertTrue((boolean)tx.getNotifications().isEmpty());
    }

    public void test_noNotificationsInSilentUnprotected_152335() {
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("silent", Boolean.TRUE);
        options.put("unprotected", Boolean.TRUE);
        this.startWriting(options);
        InternalTransaction tx = this.getActiveTransaction();
        Book book = (Book)this.find("root/Root Book");
        TransactionOptionsTest.assertNotNull((Object)book);
        String newTitle = "New Title";
        Writer newAuthor = (Writer)this.find("root/level1/Level1 Writer");
        TransactionOptionsTest.assertNotNull((Object)newAuthor);
        book.setTitle("New Title");
        newAuthor.getBooks().add((Object)book);
        TransactionOptionsTest.assertTrue((boolean)tx.getNotifications().isEmpty());
        this.commit();
        TransactionOptionsTest.assertTrue((boolean)tx.getNotifications().isEmpty());
    }

    public void test_childrenOfSilentUnprotected_152332() {
        TestListener listener = new TestListener();
        this.domain.addResourceSetListener((ResourceSetListener)listener);
        this.startWriting();
        Book book = (Book)this.find("root/Root Book");
        TransactionOptionsTest.assertNotNull((Object)book);
        String newTitle = "New Title";
        book.setTitle("New Title");
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("silent", Boolean.TRUE);
        options.put("unprotected", Boolean.TRUE);
        this.startWriting(options);
        this.startWriting();
        Writer newAuthor = (Writer)this.find("root/level1/Level1 Writer");
        TransactionOptionsTest.assertNotNull((Object)newAuthor);
        newAuthor.getBooks().add((Object)book);
        this.commit();
        this.commit();
        this.commit();
        TransactionOptionsTest.assertEquals((String)"New Title", (String)book.getTitle());
        TransactionOptionsTest.assertSame((Object)newAuthor, (Object)book.getAuthor());
        TransactionOptionsTest.assertNotNull(listener.postcommitNotifications);
        TransactionOptionsTest.assertEquals((int)1, (int)listener.postcommitNotifications.size());
        Notification notification = listener.postcommitNotifications.get(0);
        TransactionOptionsTest.assertSame((Object)EXTLibraryPackage.Literals.BOOK__TITLE, (Object)notification.getFeature());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_optionsInheritedAtActivationTime_() {
        final Object sync = new Object();
        String bogusOption = "**bogus**option**";
        Runnable run = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = sync;
                synchronized (object) {
                    TransactionOptionsTest.this.startWriting("**bogus**option**");
                    sync.notifyAll();
                    try {
                        sync.wait();
                    }
                    catch (Exception e) {
                        TransactionOptionsTest.fail((String)"Wait failed in thread");
                    }
                    TransactionOptionsTest.this.commit();
                    try {
                        sync.notifyAll();
                    }
                    catch (Exception e) {
                        TransactionOptionsTest.fail((String)"Wait failed in thread");
                    }
                }
            }
        };
        Object object = sync;
        synchronized (object) {
            Thread t = new Thread(run);
            t.setDaemon(true);
            t.start();
            try {
                sync.wait();
            }
            catch (Exception e) {
                TransactionOptionsTest.fail((String)"Wait failed on main");
            }
        }
        TransactionImpl tx = new TransactionImpl(this.domain, false, null);
        TransactionOptionsTest.assertFalse((boolean)tx.getOptions().containsKey("**bogus**option**"));
        Object object2 = sync;
        synchronized (object2) {
            sync.notifyAll();
            try {
                sync.wait();
            }
            catch (Exception e) {
                TransactionOptionsTest.fail((String)"Wait failed on main");
            }
        }
    }

    public void test_defaultTransactionOptions() {
        TransactionalEditingDomain.DefaultOptions defaults = (TransactionalEditingDomain.DefaultOptions)TransactionUtil.getAdapter((TransactionalEditingDomain)this.domain, TransactionalEditingDomain.DefaultOptions.class);
        defaults.setDefaultTransactionOptions(Collections.singletonMap("silent", Boolean.TRUE));
        TestListener l = new TestListener();
        this.domain.addResourceSetListener((ResourceSetListener)l);
        this.getCommandStack().execute((Command)new AddCommand((EditingDomain)this.domain, (EObject)this.root, (EStructuralFeature)EXTLibraryPackage.Literals.LIBRARY__WRITERS, (Object)EXTLibraryFactory.eINSTANCE.createWriter()));
        TransactionOptionsTest.assertNull((String)"Shouldn't have received notifications", (Object)l.postcommit);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.testResource.setTrackingModification(false);
        ValidationRollbackTest.validationEnabled = true;
    }

    protected void doTearDown() throws Exception {
        ValidationRollbackTest.validationEnabled = false;
        super.doTearDown();
    }
}

