/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.util.tests;

import java.lang.reflect.Field;
import java.util.concurrent.CountDownLatch;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.tests.AbstractTest;
import org.eclipse.emf.transaction.tests.fixtures.JobListener;
import org.eclipse.emf.transaction.util.Lock;
import org.eclipse.ui.PlatformUI;

public class LockTest
extends TestCase {
    private Lock lock;
    private Object monitor;
    private volatile boolean interrupted;

    public LockTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(LockTest.class, "Transaction Lock Tests");
    }

    public void test_depth() {
        LockTest.assertNull((Object)this.lock.getOwner());
        LockTest.assertEquals((int)0, (int)this.lock.getDepth());
    }

    public void test_acquire() {
        try {
            this.lock.acquire(false);
            this.lock.acquire(false);
            this.lock.release();
            this.lock.release();
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_waitForAcquire() {
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        Object object = LockTest.this.monitor;
                        synchronized (object) {
                            LockTest.this.lock.acquire(false);
                            LockTest.this.monitor.notifyAll();
                        }
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {
                        LockTest.fail();
                        if (LockTest.this.lock != null) {
                            LockTest.this.lock.release();
                        }
                    }
                }
                finally {
                    if (LockTest.this.lock != null) {
                        LockTest.this.lock.release();
                    }
                }
            }
        });
        try {
            long start = System.currentTimeMillis();
            Object object = this.monitor;
            synchronized (object) {
                t.start();
                this.monitor.wait();
            }
            this.lock.acquire(false);
            LockTest.assertTrue((System.currentTimeMillis() - start >= 1000L ? 1 : 0) != 0);
            this.lock.release();
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_waitForAcquire_timeout() {
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        Object object = LockTest.this.monitor;
                        synchronized (object) {
                            LockTest.this.lock.acquire(false);
                            LockTest.this.monitor.notifyAll();
                        }
                        Thread.sleep(5000L);
                    }
                    catch (Exception e) {
                        LockTest.fail();
                        if (LockTest.this.lock != null) {
                            LockTest.this.lock.release();
                        }
                    }
                }
                finally {
                    if (LockTest.this.lock != null) {
                        LockTest.this.lock.release();
                    }
                }
            }
        });
        t.setDaemon(true);
        try {
            Object object = this.monitor;
            synchronized (object) {
                t.start();
                this.monitor.wait();
            }
            LockTest.assertFalse((boolean)this.lock.acquire(1000L, false));
            LockTest.assertEquals((int)0, (int)this.lock.getDepth());
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_uiSafeWaitForAcquire() {
        if (!PlatformUI.isWorkbenchRunning()) {
            AbstractTest.trace("*** Test skipped because not running in a workbench ***");
            return;
        }
        final int longInterval = PlatformUI.getWorkbench().getProgressService().getLongOperationTime();
        final boolean[] syncRunnableFinished = new boolean[1];
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        Object object = LockTest.this.monitor;
                        synchronized (object) {
                            LockTest.this.lock.acquire(false);
                            LockTest.this.monitor.notifyAll();
                        }
                        Thread.sleep(longInterval);
                        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                            public void run() {
                                syncRunnableFinished[0] = true;
                            }
                        });
                        Thread.sleep(longInterval);
                    }
                    catch (Exception e) {
                        LockTest.fail();
                        if (LockTest.this.lock != null) {
                            LockTest.this.lock.release();
                        }
                    }
                }
                finally {
                    if (LockTest.this.lock != null) {
                        LockTest.this.lock.release();
                    }
                }
            }
        });
        try {
            long start = System.currentTimeMillis();
            Object object = this.monitor;
            synchronized (object) {
                t.start();
                this.monitor.wait();
            }
            this.lock.uiSafeAcquire(false);
            LockTest.assertTrue((System.currentTimeMillis() - start >= (long)longInterval ? 1 : 0) != 0);
            LockTest.assertTrue((boolean)syncRunnableFinished[0]);
            this.lock.release();
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_yield() {
        final boolean[] token = new boolean[1];
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        Object object = LockTest.this.monitor;
                        synchronized (object) {
                            LockTest.this.monitor.notifyAll();
                        }
                        LockTest.this.lock.acquire(false);
                        object = LockTest.this.monitor;
                        synchronized (object) {
                            token[0] = true;
                            LockTest.this.monitor.notify();
                        }
                    }
                    catch (Exception e) {
                        LockTest.fail();
                        if (LockTest.this.lock != null) {
                            LockTest.this.lock.release();
                        }
                    }
                }
                finally {
                    if (LockTest.this.lock != null) {
                        LockTest.this.lock.release();
                    }
                }
            }
        });
        try {
            this.lock.acquire(false);
            Object object = this.monitor;
            synchronized (object) {
                t.start();
                this.monitor.wait();
            }
            Thread.sleep(500L);
            LockTest.assertTrue((boolean)this.lock.yield());
            object = this.monitor;
            synchronized (object) {
                this.lock.release();
                this.monitor.wait();
                LockTest.assertTrue((boolean)token[0]);
            }
            this.lock.acquire(false);
            this.lock.release();
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_yieldExclusion() {
        final boolean[] token = new boolean[1];
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        Object object = LockTest.this.monitor;
                        synchronized (object) {
                            LockTest.this.monitor.notifyAll();
                        }
                        LockTest.this.lock.acquire(true);
                        object = LockTest.this.monitor;
                        synchronized (object) {
                            token[0] = true;
                            LockTest.this.monitor.notify();
                        }
                    }
                    catch (Exception e) {
                        LockTest.fail();
                        if (LockTest.this.lock != null) {
                            LockTest.this.lock.release();
                        }
                    }
                }
                finally {
                    if (LockTest.this.lock != null) {
                        LockTest.this.lock.release();
                    }
                }
            }
        });
        try {
            this.lock.acquire(false);
            Object object = this.monitor;
            synchronized (object) {
                t.start();
                this.monitor.wait();
            }
            Thread.sleep(500L);
            LockTest.assertFalse((boolean)this.lock.yield());
            object = this.monitor;
            synchronized (object) {
                this.lock.release();
                this.monitor.wait();
                LockTest.assertTrue((boolean)token[0]);
            }
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void test_yield_noneWaiting() {
        try {
            this.lock.acquire(false);
            LockTest.assertFalse((boolean)this.lock.yield());
            this.lock.release();
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_interrupt_acquire() {
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Object object = LockTest.this.monitor;
                    synchronized (object) {
                        LockTest.this.monitor.notifyAll();
                    }
                    LockTest.this.lock.acquire(false);
                }
                catch (InterruptedException e) {
                    LockTest.this.interrupted = true;
                }
                catch (Exception e) {
                    LockTest.fail();
                }
            }
        });
        try {
            this.lock.acquire(false);
            Object object = this.monitor;
            synchronized (object) {
                t.start();
                this.monitor.wait();
            }
            Thread.sleep(500L);
            t.interrupt();
            Thread.sleep(500L);
            this.lock.release();
            LockTest.assertTrue((boolean)this.interrupted);
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void test_interrupt_acquire_alreadyInterrupted() {
        try {
            Thread.currentThread().interrupt();
            this.lock.acquire(false);
            LockTest.fail((String)"Should have thrown InterruptedException");
        }
        catch (InterruptedException e) {
            AbstractTest.trace("Got the expected InterruptedException");
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_interrupt_uiSafeAcquire_jobInterrupted() {
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Object object = LockTest.this.monitor;
                    synchronized (object) {
                        LockTest.this.monitor.notifyAll();
                    }
                    LockTest.this.lock.uiSafeAcquire(false);
                }
                catch (InterruptedException e) {
                    LockTest.this.interrupted = true;
                }
                catch (Exception e) {
                    LockTest.this.fail(e);
                }
            }
        });
        JobListener jl = new JobListener();
        try {
            try {
                this.lock.acquire(false);
                Job.getJobManager().addJobChangeListener((IJobChangeListener)jl);
                Object object = this.monitor;
                synchronized (object) {
                    t.start();
                    this.monitor.wait();
                }
                Job acquireJob = jl.waitUntilRunning();
                Thread.sleep(500L);
                acquireJob.getThread().interrupt();
                Thread.sleep(500L);
                this.lock.release();
                jl.waitUntilDone();
                t.join();
                LockTest.assertTrue((boolean)this.interrupted);
            }
            catch (Exception e) {
                this.fail(e);
                Job.getJobManager().removeJobChangeListener((IJobChangeListener)jl);
            }
        }
        finally {
            Job.getJobManager().removeJobChangeListener((IJobChangeListener)jl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_interrupt_uiSafeAcquire_jobCancelled() {
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Object object = LockTest.this.monitor;
                    synchronized (object) {
                        LockTest.this.monitor.notifyAll();
                    }
                    LockTest.this.lock.uiSafeAcquire(false);
                }
                catch (InterruptedException e) {
                    LockTest.this.interrupted = true;
                }
                catch (Exception e) {
                    LockTest.fail();
                }
            }
        });
        JobListener jl = new JobListener();
        try {
            try {
                this.lock.acquire(false);
                Job.getJobManager().addJobChangeListener((IJobChangeListener)jl);
                Object object = this.monitor;
                synchronized (object) {
                    t.start();
                    this.monitor.wait();
                }
                Job acquireJob = jl.waitUntilRunning();
                Thread.sleep(500L);
                acquireJob.cancel();
                jl.waitUntilDone();
                this.lock.release();
                t.join();
                LockTest.assertTrue((boolean)this.interrupted);
            }
            catch (Exception e) {
                this.fail(e);
                Job.getJobManager().removeJobChangeListener((IJobChangeListener)jl);
            }
        }
        finally {
            Job.getJobManager().removeJobChangeListener((IJobChangeListener)jl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_uiSafeWaitForAcquire_implicitJob_bug162141() {
        if (!PlatformUI.isWorkbenchRunning()) {
            AbstractTest.trace("*** Test skipped because not running in a workbench ***");
            return;
        }
        ISchedulingRule rule = new ISchedulingRule(){

            public boolean isConflicting(ISchedulingRule rule) {
                return rule == this;
            }

            public boolean contains(ISchedulingRule rule) {
                return rule == this;
            }
        };
        TransactionalEditingDomain domain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain();
        this.lock = this.getLock(domain);
        final int longInterval = PlatformUI.getWorkbench().getProgressService().getLongOperationTime();
        final boolean[] syncRunnableFinished = new boolean[1];
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        Object object = LockTest.this.monitor;
                        synchronized (object) {
                            LockTest.this.lock.acquire(false);
                            LockTest.this.monitor.notifyAll();
                        }
                        Thread.sleep(longInterval);
                        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                            public void run() {
                                syncRunnableFinished[0] = true;
                            }
                        });
                        Thread.sleep(longInterval);
                    }
                    catch (Exception e) {
                        LockTest.fail();
                        if (LockTest.this.lock != null) {
                            LockTest.this.lock.release();
                        }
                    }
                }
                finally {
                    if (LockTest.this.lock != null) {
                        LockTest.this.lock.release();
                    }
                }
            }
        });
        try {
            try {
                long start = System.currentTimeMillis();
                Object object = this.monitor;
                synchronized (object) {
                    t.start();
                    this.monitor.wait();
                }
                Job.getJobManager().beginRule(rule, null);
                try {
                    this.lock.uiSafeAcquire(false);
                    LockTest.assertTrue((System.currentTimeMillis() - start >= (long)longInterval ? 1 : 0) != 0);
                    LockTest.assertTrue((boolean)syncRunnableFinished[0]);
                    this.lock.release();
                }
                finally {
                    Job.getJobManager().endRule(rule);
                }
            }
            catch (Exception e) {
                this.fail(e);
                domain.dispose();
            }
        }
        finally {
            domain.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void test_uiSafeWaitForAcquire_explicitJob_beginRule_262175() {
        TransactionalEditingDomain domain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain();
        final CountDownLatch latch = new CountDownLatch(1);
        this.lock = this.getLock(domain);
        final boolean[] status = new boolean[1];
        Job job = new Job("TestJob"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                ISchedulingRule rule = new ISchedulingRule(){

                    public boolean contains(ISchedulingRule rule) {
                        return rule == this;
                    }

                    public boolean isConflicting(ISchedulingRule rule) {
                        return rule == this;
                    }
                };
                Job.getJobManager().beginRule(rule, (IProgressMonitor)new NullProgressMonitor());
                try {
                    try {
                        latch.countDown();
                        LockTest.this.lock.uiSafeAcquire(false);
                        boolean[] blArray = status;
                        synchronized (status) {
                            status[0] = true;
                            // ** MonitorExit[var3_3] (shouldn't be in output)
                        }
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    LockTest.this.lock.release();
                    Job.getJobManager().endRule(rule);
                }
                {
                    return Status.OK_STATUS;
                }
            }
        };
        try {
            this.lock.acquire(true);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        try {
            try {
                job.schedule();
                latch.await();
                Thread.sleep(1000L);
                this.lock.release();
                try {
                    job.join();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (InterruptedException e) {
                this.fail(e);
                boolean[] blArray = status;
                synchronized (status) {
                    LockTest.assertTrue((String)"Job did not acquire a rule", (boolean)status[0]);
                    // ** MonitorExit[var7_8] (shouldn't be in output)
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            boolean[] blArray = status;
            synchronized (status) {
                LockTest.assertTrue((String)"Job did not acquire a rule", (boolean)status[0]);
                // ** MonitorExit[var7_9] (shouldn't be in output)
                throw throwable;
            }
        }
        boolean[] blArray = status;
        synchronized (status) {
            LockTest.assertTrue((String)"Job did not acquire a rule", (boolean)status[0]);
            // ** MonitorExit[var7_10] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_uiSafeWaitForAcquire_beginRuleThrows_bug205857() {
        IWorkspaceRoot rule = ResourcesPlugin.getWorkspace().getRoot();
        TransactionalEditingDomain domain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain();
        this.lock = this.getLock(domain);
        Thread t = new Thread(new Runnable((ISchedulingRule)rule){
            private final /* synthetic */ ISchedulingRule val$rule;
            {
                this.val$rule = iSchedulingRule;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        Object object = LockTest.this.monitor;
                        synchronized (object) {
                            LockTest.this.monitor.notifyAll();
                        }
                        LockTest.this.lock.uiSafeAcquire(false);
                        LockTest.fail((String)"Should have thrown InterruptedException");
                    }
                    catch (InterruptedException e) {
                        System.out.println("Got expected exception: " + e.getLocalizedMessage());
                        Job.getJobManager().endRule(this.val$rule);
                    }
                    catch (Exception e) {
                        LockTest.this.fail(e);
                        Job.getJobManager().endRule(this.val$rule);
                    }
                }
                finally {
                    Job.getJobManager().endRule(this.val$rule);
                }
            }
        });
        try {
            try {
                Job.getJobManager().beginRule((ISchedulingRule)rule, null);
                this.lock.acquire(false);
                Object object = this.monitor;
                synchronized (object) {
                    t.start();
                    this.monitor.wait();
                }
                Thread.sleep(50L);
                Job.getJobManager().transferRule((ISchedulingRule)rule, t);
                Thread.sleep(250L);
                this.lock.release();
                t.join();
                Thread.sleep(250L);
                Thread owner = this.lock.getOwner();
                if (owner != null) {
                    LockTest.fail((String)("Lock still owned by thread " + owner.getName()));
                }
            }
            catch (Exception e) {
                this.fail(e);
                domain.dispose();
            }
        }
        finally {
            domain.dispose();
        }
    }

    protected void setUp() throws Exception {
        AbstractTest.trace("===> Begin : " + this.getName());
        this.lock = new Lock();
        this.monitor = new Object();
    }

    protected void tearDown() throws Exception {
        this.lock = null;
        this.monitor = null;
        this.interrupted = false;
        AbstractTest.trace("===> End   : " + this.getName());
    }

    protected void fail(Exception e) {
        e.printStackTrace();
        LockTest.fail((String)("Should not have thrown: " + e.getLocalizedMessage()));
    }

    private Lock getLock(TransactionalEditingDomain domain) {
        Lock result = null;
        Field field = null;
        try {
            try {
                Class<?> clazz = domain.getClass();
                field = clazz.getDeclaredField("transactionLock");
                field.setAccessible(true);
                result = (Lock)field.get(domain);
            }
            catch (Exception e) {
                LockTest.fail((String)("Could not access transactionLock field: " + e.getLocalizedMessage()));
                if (field != null) {
                    field.setAccessible(false);
                }
            }
        }
        finally {
            if (field != null) {
                field.setAccessible(false);
            }
        }
        return result;
    }
}

