/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.workspace.tests;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.examples.extlibrary.Book;
import org.eclipse.emf.examples.extlibrary.EXTLibraryFactory;
import org.eclipse.emf.examples.extlibrary.EXTLibraryPackage;
import org.eclipse.emf.examples.extlibrary.Library;
import org.eclipse.emf.examples.extlibrary.Writer;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.TriggerListener;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.emf.workspace.tests.AbstractTest;
import org.eclipse.emf.workspace.tests.fixtures.ItemDefaultPublicationDateTrigger;
import org.eclipse.emf.workspace.tests.fixtures.LibraryDefaultBookTrigger;
import org.eclipse.emf.workspace.tests.fixtures.LibraryDefaultNameTrigger;
import org.eclipse.emf.workspace.tests.fixtures.TestCommand;
import org.eclipse.emf.workspace.tests.fixtures.TestUndoContext;

public class EMFCommandOperationTest
extends AbstractTest {
    public EMFCommandOperationTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(EMFCommandOperationTest.class, "EMF Command Operation Tests");
    }

    public void test_execute_undo_redo() {
        this.startReading();
        Book book = (Book)this.find("root/Root Book");
        EMFCommandOperationTest.assertNotNull((Object)book);
        String oldTitle = book.getTitle();
        Writer oldAuthor = book.getAuthor();
        String newTitle = "New Title";
        Writer newAuthor = (Writer)this.find("root/level1/Level1 Writer");
        EMFCommandOperationTest.assertNotNull((Object)newAuthor);
        this.commit();
        TestUndoContext ctx = new TestUndoContext();
        SetCommand cmd = new SetCommand((EditingDomain)this.domain, (EObject)book, (EStructuralFeature)EXTLibraryPackage.eINSTANCE.getBook_Title(), (Object)"New Title");
        cmd = cmd.chain((Command)new AddCommand((EditingDomain)this.domain, (EObject)newAuthor, (EStructuralFeature)EXTLibraryPackage.eINSTANCE.getWriter_Books(), (Object)book));
        EMFCommandOperation oper = new EMFCommandOperation(this.domain, (Command)cmd);
        try {
            oper.addContext((IUndoContext)ctx);
            this.history.execute((IUndoableOperation)oper, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        EMFCommandOperationTest.assertSame((Object)"New Title", (Object)book.getTitle());
        EMFCommandOperationTest.assertSame((Object)newAuthor, (Object)book.getAuthor());
        this.commit();
        try {
            EMFCommandOperationTest.assertTrue((boolean)this.history.canUndo((IUndoContext)ctx));
            this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        EMFCommandOperationTest.assertSame((Object)oldTitle, (Object)book.getTitle());
        EMFCommandOperationTest.assertSame((Object)oldAuthor, (Object)book.getAuthor());
        this.commit();
        try {
            EMFCommandOperationTest.assertTrue((boolean)this.history.canRedo((IUndoContext)ctx));
            this.history.redo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        EMFCommandOperationTest.assertSame((Object)"New Title", (Object)book.getTitle());
        EMFCommandOperationTest.assertSame((Object)newAuthor, (Object)book.getAuthor());
        this.commit();
    }

    public void test_triggerCommands() {
        this.domain.addResourceSetListener((ResourceSetListener)new LibraryDefaultNameTrigger());
        this.domain.addResourceSetListener((ResourceSetListener)new LibraryDefaultBookTrigger());
        Library newLibrary = EXTLibraryFactory.eINSTANCE.createLibrary();
        TestUndoContext ctx = new TestUndoContext();
        AddCommand cmd = new AddCommand((EditingDomain)this.domain, (EObject)this.root, (EStructuralFeature)EXTLibraryPackage.eINSTANCE.getLibrary_Branches(), (Object)newLibrary);
        EMFCommandOperation oper = new EMFCommandOperation(this.domain, (Command)cmd);
        try {
            oper.addContext((IUndoContext)ctx);
            this.history.execute((IUndoableOperation)oper, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        EMFCommandOperationTest.assertEquals((String)"New Library", (String)newLibrary.getName());
        EMFCommandOperationTest.assertEquals((int)1, (int)newLibrary.getBooks().size());
        EMFCommandOperationTest.assertEquals((String)"New Book", (String)((Book)newLibrary.getBooks().get(0)).getTitle());
        this.commit();
        try {
            EMFCommandOperationTest.assertTrue((boolean)this.history.canUndo((IUndoContext)ctx));
            this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        EMFCommandOperationTest.assertFalse((boolean)this.root.getBranches().contains((Object)newLibrary));
        this.commit();
        try {
            EMFCommandOperationTest.assertTrue((boolean)this.history.canRedo((IUndoContext)ctx));
            this.history.redo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        EMFCommandOperationTest.assertTrue((boolean)this.root.getBranches().contains((Object)newLibrary));
        EMFCommandOperationTest.assertEquals((String)"New Library", (String)newLibrary.getName());
        EMFCommandOperationTest.assertEquals((int)1, (int)newLibrary.getBooks().size());
        EMFCommandOperationTest.assertEquals((String)"New Book", (String)((Book)newLibrary.getBooks().get(0)).getTitle());
        this.commit();
    }

    public void test_triggerCommands_cascading() {
        this.domain.addResourceSetListener((ResourceSetListener)new LibraryDefaultBookTrigger());
        this.domain.addResourceSetListener((ResourceSetListener)new ItemDefaultPublicationDateTrigger());
        Library newLibrary = EXTLibraryFactory.eINSTANCE.createLibrary();
        TestUndoContext ctx = new TestUndoContext();
        AddCommand cmd = new AddCommand((EditingDomain)this.domain, (EObject)this.root, (EStructuralFeature)EXTLibraryPackage.eINSTANCE.getLibrary_Branches(), (Object)newLibrary);
        EMFCommandOperation oper = new EMFCommandOperation(this.domain, (Command)cmd);
        try {
            oper.addContext((IUndoContext)ctx);
            this.history.execute((IUndoableOperation)oper, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        EMFCommandOperationTest.assertEquals((int)1, (int)newLibrary.getBooks().size());
        Book book = (Book)newLibrary.getBooks().get(0);
        EMFCommandOperationTest.assertEquals((String)"New Book", (String)book.getTitle());
        EMFCommandOperationTest.assertNotNull((Object)book.getPublicationDate());
        this.commit();
        try {
            EMFCommandOperationTest.assertTrue((boolean)this.history.canUndo((IUndoContext)ctx));
            this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        EMFCommandOperationTest.assertFalse((boolean)this.root.getBranches().contains((Object)newLibrary));
        this.commit();
        try {
            EMFCommandOperationTest.assertTrue((boolean)this.history.canRedo((IUndoContext)ctx));
            this.history.redo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        EMFCommandOperationTest.assertTrue((boolean)this.root.getBranches().contains((Object)newLibrary));
        EMFCommandOperationTest.assertEquals((int)1, (int)newLibrary.getBooks().size());
        book = (Book)newLibrary.getBooks().get(0);
        EMFCommandOperationTest.assertEquals((String)"New Book", (String)book.getTitle());
        EMFCommandOperationTest.assertNotNull((Object)book.getPublicationDate());
        this.commit();
    }

    public void test_RecordingCommand_execute_undo_redo() {
        this.startReading();
        final Book book = (Book)this.find("root/Root Book");
        EMFCommandOperationTest.assertNotNull((Object)book);
        String oldTitle = book.getTitle();
        Writer oldAuthor = book.getAuthor();
        String newTitle = "New Title";
        final Writer newAuthor = (Writer)this.find("root/level1/Level1 Writer");
        EMFCommandOperationTest.assertNotNull((Object)newAuthor);
        this.commit();
        TestUndoContext ctx = new TestUndoContext();
        RecordingCommand cmd = new RecordingCommand(this.domain){

            protected void doExecute() {
                book.setTitle("New Title");
                newAuthor.getBooks().add((Object)book);
            }
        };
        EMFCommandOperation oper = new EMFCommandOperation(this.domain, (Command)cmd);
        try {
            oper.addContext((IUndoContext)ctx);
            this.history.execute((IUndoableOperation)oper, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        EMFCommandOperationTest.assertSame((Object)"New Title", (Object)book.getTitle());
        EMFCommandOperationTest.assertSame((Object)newAuthor, (Object)book.getAuthor());
        this.commit();
        try {
            EMFCommandOperationTest.assertTrue((boolean)this.history.canUndo((IUndoContext)ctx));
            this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        EMFCommandOperationTest.assertSame((Object)oldTitle, (Object)book.getTitle());
        EMFCommandOperationTest.assertSame((Object)oldAuthor, (Object)book.getAuthor());
        this.commit();
        try {
            EMFCommandOperationTest.assertTrue((boolean)this.history.canRedo((IUndoContext)ctx));
            this.history.redo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        EMFCommandOperationTest.assertSame((Object)"New Title", (Object)book.getTitle());
        EMFCommandOperationTest.assertSame((Object)newAuthor, (Object)book.getAuthor());
        this.commit();
    }

    public void test_RecordingCommand_triggerCommands() {
        this.domain.addResourceSetListener((ResourceSetListener)new LibraryDefaultNameTrigger());
        this.domain.addResourceSetListener((ResourceSetListener)new LibraryDefaultBookTrigger());
        final Library newLibrary = EXTLibraryFactory.eINSTANCE.createLibrary();
        TestUndoContext ctx = new TestUndoContext();
        RecordingCommand cmd = new RecordingCommand(this.domain){

            protected void doExecute() {
                EMFCommandOperationTest.this.root.getBranches().add((Object)newLibrary);
            }
        };
        EMFCommandOperation oper = new EMFCommandOperation(this.domain, (Command)cmd);
        try {
            oper.addContext((IUndoContext)ctx);
            this.history.execute((IUndoableOperation)oper, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        EMFCommandOperationTest.assertEquals((String)"New Library", (String)newLibrary.getName());
        EMFCommandOperationTest.assertEquals((int)1, (int)newLibrary.getBooks().size());
        EMFCommandOperationTest.assertEquals((String)"New Book", (String)((Book)newLibrary.getBooks().get(0)).getTitle());
        this.commit();
        try {
            EMFCommandOperationTest.assertTrue((boolean)this.history.canUndo((IUndoContext)ctx));
            this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        EMFCommandOperationTest.assertFalse((boolean)this.root.getBranches().contains((Object)newLibrary));
        this.commit();
        try {
            EMFCommandOperationTest.assertTrue((boolean)this.history.canRedo((IUndoContext)ctx));
            this.history.redo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        EMFCommandOperationTest.assertTrue((boolean)this.root.getBranches().contains((Object)newLibrary));
        EMFCommandOperationTest.assertEquals((String)"New Library", (String)newLibrary.getName());
        EMFCommandOperationTest.assertEquals((int)1, (int)newLibrary.getBooks().size());
        EMFCommandOperationTest.assertEquals((String)"New Book", (String)((Book)newLibrary.getBooks().get(0)).getTitle());
        this.commit();
    }

    public void test_validation() {
        IStatus status;
        Writer oldAuthor;
        String oldTitle;
        Book book;
        block5: {
            this.startReading();
            book = (Book)this.find("root/Root Book");
            EMFCommandOperationTest.assertNotNull((Object)book);
            oldTitle = book.getTitle();
            oldAuthor = book.getAuthor();
            Object newTitle = null;
            Writer newAuthor = (Writer)this.find("root/level1/Level1 Writer");
            EMFCommandOperationTest.assertNotNull((Object)newAuthor);
            this.commit();
            TestUndoContext ctx = new TestUndoContext();
            SetCommand cmd = new SetCommand((EditingDomain)this.domain, (EObject)book, (EStructuralFeature)EXTLibraryPackage.eINSTANCE.getBook_Title(), newTitle);
            cmd = cmd.chain((Command)new AddCommand((EditingDomain)this.domain, (EObject)newAuthor, (EStructuralFeature)EXTLibraryPackage.eINSTANCE.getWriter_Books(), (Object)book));
            EMFCommandOperation oper = new EMFCommandOperation(this.domain, (Command)cmd);
            status = null;
            try {
                try {
                    validationEnabled = true;
                    oper.addContext((IUndoContext)ctx);
                    status = this.history.execute((IUndoableOperation)oper, (IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException e) {
                    this.fail((Exception)((Object)e));
                    validationEnabled = false;
                    break block5;
                }
            }
            catch (Throwable throwable) {
                validationEnabled = false;
                throw throwable;
            }
            validationEnabled = false;
        }
        EMFCommandOperationTest.assertNotNull(status);
        EMFCommandOperationTest.assertTrue((boolean)status.matches(4));
        status = this.findValidationStatus(status, 4);
        EMFCommandOperationTest.assertNotNull((Object)status);
        this.startReading();
        EMFCommandOperationTest.assertSame((Object)oldTitle, (Object)book.getTitle());
        EMFCommandOperationTest.assertSame((Object)oldAuthor, (Object)book.getAuthor());
        this.commit();
    }

    public void test_nonredoableCommand_138287() {
        TestCommand.Redoable cmd = new TestCommand.Redoable(){

            public void execute() {
            }

            @Override
            public boolean canRedo() {
                return false;
            }
        };
        this.getCommandStack().execute((Command)cmd);
        EMFCommandOperationTest.assertTrue((boolean)this.getCommandStack().canUndo());
        this.getCommandStack().undo();
        EMFCommandOperationTest.assertFalse((boolean)this.getCommandStack().canRedo());
    }

    public void test_nonredoableTriggerCommand_138287() {
        this.domain.addResourceSetListener((ResourceSetListener)new TriggerListener(){

            protected Command trigger(TransactionalEditingDomain domain, Notification notification) {
                return new TestCommand.Redoable(){

                    public void execute() {
                    }

                    @Override
                    public boolean canRedo() {
                        return false;
                    }
                };
            }
        });
        Library newLibrary = EXTLibraryFactory.eINSTANCE.createLibrary();
        Command cmd = AddCommand.create((EditingDomain)this.domain, (Object)this.root, (Object)EXTLibraryPackage.Literals.LIBRARY__BRANCHES, (Object)newLibrary);
        this.getCommandStack().execute(cmd);
        EMFCommandOperationTest.assertTrue((boolean)this.getCommandStack().canUndo());
        this.getCommandStack().undo();
        EMFCommandOperationTest.assertFalse((boolean)this.getCommandStack().canRedo());
    }

    public void test_undoRecordingCommandWithRecordingCommandTrigger_218276() {
        final Book[] book = new Book[]{(Book)this.find("root/Root Book")};
        int newCopies = 30;
        final RecordingCommand trigger = new RecordingCommand(this.domain, "Test Trigger"){

            protected void doExecute() {
                book[0].setCopies(30);
            }
        };
        ResourceSetListenerImpl listener = new ResourceSetListenerImpl(){

            public boolean isPrecommitOnly() {
                return true;
            }

            public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
                CompoundCommand result = new CompoundCommand();
                for (Notification next : event.getNotifications()) {
                    if (next.getFeature() != EXTLibraryPackage.Literals.BOOK__TITLE) continue;
                    return trigger;
                }
                return result;
            }
        };
        try {
            try {
                this.domain.addResourceSetListener((ResourceSetListener)listener);
                String newTitle = "New Title";
                this.getCommandStack().execute((Command)new RecordingCommand(this.domain, "Test"){

                    protected void doExecute() {
                        book[0].setTitle("New Title");
                    }
                });
                EMFCommandOperationTest.assertEquals((String)"Wrong number of copies on execute", (int)30, (int)book[0].getCopies());
                this.getCommandStack().undo();
                EMFCommandOperationTest.assertFalse((String)"Wrong number of copies on undo", (book[0].getCopies() == 30 ? 1 : 0) != 0);
                this.getCommandStack().redo();
                EMFCommandOperationTest.assertEquals((String)"Wrong number of copies on redo", (int)30, (int)book[0].getCopies());
            }
            catch (Exception e) {
                this.fail(e);
                this.domain.removeResourceSetListener((ResourceSetListener)listener);
            }
        }
        finally {
            this.domain.removeResourceSetListener((ResourceSetListener)listener);
        }
    }

    public void test_undoNestedRecordingCommandWithRecordingCommandTrigger_218276() {
        final Book[] book = new Book[]{(Book)this.find("root/Root Book")};
        int newCopies = 30;
        final RecordingCommand trigger = new RecordingCommand(this.domain, "Test Trigger"){

            protected void doExecute() {
                book[0].setCopies(30);
            }
        };
        ResourceSetListenerImpl listener = new ResourceSetListenerImpl(){

            public boolean isPrecommitOnly() {
                return true;
            }

            public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
                CompoundCommand result = new CompoundCommand();
                for (Notification next : event.getNotifications()) {
                    if (next.getFeature() != EXTLibraryPackage.Literals.BOOK__TITLE) continue;
                    return trigger;
                }
                return result;
            }
        };
        try {
            try {
                this.domain.addResourceSetListener((ResourceSetListener)listener);
                String newTitle = "New Title";
                CompoundCommand cc = new CompoundCommand("Test");
                cc.append((Command)new RecordingCommand(this.domain, "Test"){

                    protected void doExecute() {
                        book[0].setTitle("New Title");
                    }
                });
                this.getCommandStack().execute((Command)cc);
                EMFCommandOperationTest.assertEquals((String)"Wrong number of copies on execute", (int)30, (int)book[0].getCopies());
                this.getCommandStack().undo();
                EMFCommandOperationTest.assertFalse((String)"Wrong number of copies on undo", (book[0].getCopies() == 30 ? 1 : 0) != 0);
                this.getCommandStack().redo();
                EMFCommandOperationTest.assertEquals((String)"Wrong number of copies on redo", (int)30, (int)book[0].getCopies());
            }
            catch (Exception e) {
                this.fail(e);
                this.domain.removeResourceSetListener((ResourceSetListener)listener);
            }
        }
        finally {
            this.domain.removeResourceSetListener((ResourceSetListener)listener);
        }
    }
}

