/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.annotations;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.teneo.PersistenceOptions;
import org.eclipse.emf.teneo.annotations.mapper.AbstractAnnotator;
import org.eclipse.emf.teneo.annotations.mapper.OneToManyReferenceAnnotator;
import org.eclipse.emf.teneo.annotations.mapper.StoreMappingException;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference;
import org.eclipse.emf.teneo.hibernate.annotations.HbAnnotationUtil;
import org.eclipse.emf.teneo.hibernate.hbannotation.Cache;
import org.eclipse.emf.teneo.hibernate.hbannotation.CacheConcurrencyStrategy;
import org.eclipse.emf.teneo.hibernate.hbannotation.HbannotationFactory;
import org.eclipse.emf.teneo.hibernate.hbmodel.HbAnnotatedEReference;

public class HbOneToManyReferenceAnnotator
extends OneToManyReferenceAnnotator {
    protected static final Log log = LogFactory.getLog(HbOneToManyReferenceAnnotator.class);
    private String defaultCacheStrategy = CacheConcurrencyStrategy.NONE.getName();

    public void annotate(PAnnotatedEReference aReference) {
        boolean hasCache;
        boolean isCollectionOfElements;
        boolean bl = isCollectionOfElements = aReference instanceof HbAnnotatedEReference && ((HbAnnotatedEReference)aReference).getHbCollectionOfElements() != null;
        if (this.getPersistenceOptions().alwaysMapListAsIdBag() && aReference.getModelEReference().isMany() && aReference.getOneToMany() == null && !aReference.getModelEReference().isContainment()) {
            ((HbAnnotatedEReference)aReference).setHbIdBag(HbannotationFactory.eINSTANCE.createIdBag());
        }
        if (this.getPersistenceOptions().isAddIndexForForeignKey()) {
            HbAnnotationUtil.setIndex(aReference, (AbstractAnnotator)this);
        }
        if (!isCollectionOfElements) {
            super.annotate(aReference);
        }
        boolean bl2 = hasCache = ((HbAnnotatedEReference)aReference).getHbCache() != null;
        if (!hasCache && this.defaultCacheStrategy.compareToIgnoreCase(CacheConcurrencyStrategy.NONE.getName()) != 0) {
            CacheConcurrencyStrategy ccs = CacheConcurrencyStrategy.getByName(this.defaultCacheStrategy);
            if (ccs == null) {
                throw new StoreMappingException("The default cache strategy: " + this.defaultCacheStrategy + " is not one of the allowed values (uppercase) " + "as defined in the JPA Hibernate Annotation Extensions.");
            }
            log.debug((Object)("Setting cache strategy " + this.defaultCacheStrategy + " on " + aReference.getModelEReference().getName()));
            Cache cache = HbannotationFactory.eINSTANCE.createCache();
            cache.setUsage(ccs);
            ((HbAnnotatedEReference)aReference).setHbCache(cache);
        }
    }

    public void setPersistenceOptions(PersistenceOptions persistenceOptions) {
        super.setPersistenceOptions(persistenceOptions);
        this.defaultCacheStrategy = persistenceOptions.getDefaultCacheStrategy();
    }
}

