/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision.delta;

import java.io.IOException;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOFeatureDeltaImpl;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CDOSingleValueFeatureDeltaImpl
extends CDOFeatureDeltaImpl
implements CDOFeatureDelta {
    private int index;
    private Object newValue;

    public CDOSingleValueFeatureDeltaImpl(CDOFeature feature, int index, Object value) {
        super(feature);
        this.index = index;
        this.newValue = value;
    }

    public CDOSingleValueFeatureDeltaImpl(ExtendedDataInput in, CDOClass cdoClass) throws IOException {
        super(in, cdoClass);
        this.index = in.readInt();
        this.newValue = this.getFeature().getType().readValue(in, cdoClass.getPackageManager().getCDOIDObjectFactory());
    }

    public int getIndex() {
        return this.index;
    }

    public Object getValue() {
        return this.newValue;
    }

    @Override
    public void write(ExtendedDataOutput out, CDOClass cdoClass, CDOIDProvider idProvider) throws IOException {
        super.write(out, cdoClass, idProvider);
        out.writeInt(this.index);
        if (this.newValue != null && this.getFeature().isReference()) {
            this.newValue = idProvider.provideCDOID(this.newValue);
        }
        this.getFeature().getType().writeValue(out, this.newValue);
    }

    @Override
    public void adjustReferences(Map<CDOIDTemp, CDOID> idMappings) {
        if (this.newValue instanceof CDOID) {
            this.newValue = CDORevisionUtil.remapID(this.newValue, idMappings);
        }
    }
}

