/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.model;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.emf.cdo.common.model.CDOClassInfo;
import org.eclipse.emf.cdo.common.model.CDOPackageInfo;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.internal.common.messages.Messages;
import org.eclipse.emf.cdo.internal.common.model.CDOClassInfoImpl;
import org.eclipse.emf.cdo.internal.common.model.CDOPackageInfoImpl;
import org.eclipse.emf.cdo.internal.common.model.CDOPackageUnitImpl;
import org.eclipse.emf.cdo.internal.common.model.CDOTypeImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CDOModelUtil {
    public static final String CORE_PACKAGE_URI = "http://www.eclipse.org/emf/2002/Ecore";
    public static final String RESOURCE_PACKAGE_URI = "http://www.eclipse.org/emf/CDO/Eresource/2.0.0";
    public static final String RESOURCE_NODE_CLASS_NAME = "CDOResourceNode";
    public static final String RESOURCE_FOLDER_CLASS_NAME = "CDOResourceFolder";
    public static final String RESOURCE_CLASS_NAME = "CDOResource";
    public static final String ROOT_CLASS_NAME = "EObject";
    private static CDOType[] coreTypes;

    static {
        ArrayList<CDOType> types = new ArrayList<CDOType>();
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEBigDecimal(), CDOType.BIG_DECIMAL);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEBigInteger(), CDOType.BIG_INTEGER);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEBooleanObject(), CDOType.BOOLEAN_OBJECT);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEBoolean(), CDOType.BOOLEAN);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEByteArray(), CDOType.BYTE_ARRAY);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEByteObject(), CDOType.BYTE_OBJECT);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEByte(), CDOType.BYTE);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getECharacterObject(), CDOType.CHARACTER_OBJECT);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEChar(), CDOType.CHAR);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEDate(), CDOType.DATE);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEDoubleObject(), CDOType.DOUBLE_OBJECT);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEDouble(), CDOType.DOUBLE);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEFloatObject(), CDOType.FLOAT_OBJECT);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEFloat(), CDOType.FLOAT);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEIntegerObject(), CDOType.INTEGER_OBJECT);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEInt(), CDOType.INT);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEJavaClass(), null);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEJavaObject(), null);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getELongObject(), CDOType.LONG_OBJECT);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getELong(), CDOType.LONG);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEShortObject(), CDOType.SHORT_OBJECT);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEShort(), CDOType.SHORT);
        CDOModelUtil.registerCoreType(types, (EClassifier)EcorePackage.eINSTANCE.getEString(), CDOType.STRING);
        coreTypes = types.toArray(new CDOType[types.size()]);
    }

    private static void registerCoreType(List<CDOType> types, EClassifier classifier, CDOType type) {
        int index = classifier.getClassifierID();
        while (index >= types.size()) {
            types.add(null);
        }
        types.set(index, type);
    }

    private CDOModelUtil() {
    }

    public static boolean isCorePackage(EPackage ePackage) {
        return CORE_PACKAGE_URI.equals(ePackage.getNsURI());
    }

    public static boolean isResourcePackage(EPackage ePackage) {
        return RESOURCE_PACKAGE_URI.equals(ePackage.getNsURI());
    }

    public static boolean isSystemPackage(EPackage ePackage) {
        return CDOModelUtil.isCorePackage(ePackage) || CDOModelUtil.isResourcePackage(ePackage);
    }

    public static boolean isResource(EClass eClass) {
        return CDOModelUtil.isResourcePackage(eClass.getEPackage()) && RESOURCE_CLASS_NAME.equals(eClass.getName());
    }

    public static boolean isResourceFolder(EClass eClass) {
        return CDOModelUtil.isResourcePackage(eClass.getEPackage()) && RESOURCE_FOLDER_CLASS_NAME.equals(eClass.getName());
    }

    public static boolean isResourceNode(EClass eClass) {
        return CDOModelUtil.isResourcePackage(eClass.getEPackage()) && (RESOURCE_NODE_CLASS_NAME.equals(eClass.getName()) || RESOURCE_CLASS_NAME.equals(eClass.getName()) || RESOURCE_FOLDER_CLASS_NAME.equals(eClass.getName()));
    }

    public static boolean isRoot(EClass eClass) {
        return CDOModelUtil.isCorePackage(eClass.getEPackage()) && ROOT_CLASS_NAME.equals(eClass.getName());
    }

    public static CDOType getType(EStructuralFeature feature) {
        if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
            return CDOType.FEATURE_MAP_ENTRY;
        }
        return CDOModelUtil.getType(feature.getEType());
    }

    public static CDOType getType(int typeID) {
        return CDOTypeImpl.getType(typeID);
    }

    public static CDOType getType(EClassifier classifier) {
        EDataType eDataType;
        CDOType type;
        if (classifier instanceof EClass) {
            return CDOType.OBJECT;
        }
        if (classifier instanceof EEnum) {
            return CDOType.ENUM;
        }
        if (CDOModelUtil.isCorePackage(classifier.getEPackage()) && (type = CDOModelUtil.getCoreType((EClassifier)(eDataType = (EDataType)classifier))) != null) {
            return type;
        }
        return CDOType.CUSTOM;
    }

    public static CDOType getCoreType(EClassifier eDataType) {
        int index = eDataType.getClassifierID();
        if (index >= 0 && index < coreTypes.length) {
            return coreTypes[index];
        }
        return null;
    }

    public static CDOType getPrimitiveType(Class<? extends Object> primitiveType) {
        if (primitiveType == String.class) {
            return CDOType.STRING;
        }
        if (primitiveType == Boolean.class) {
            return CDOType.BOOLEAN;
        }
        if (primitiveType == Integer.class) {
            return CDOType.INT;
        }
        if (primitiveType == Double.class) {
            return CDOType.DOUBLE;
        }
        if (primitiveType == Float.class) {
            return CDOType.FLOAT;
        }
        if (primitiveType == Long.class) {
            return CDOType.LONG;
        }
        if (primitiveType == Date.class) {
            return CDOType.DATE;
        }
        if (primitiveType == Byte.class) {
            return CDOType.BYTE;
        }
        if (primitiveType == Character.class) {
            return CDOType.CHAR;
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOModelUtil.7"), primitiveType));
    }

    public static CDOPackageInfo getPackageInfo(Object value, CDOPackageRegistry packageRegistry) {
        CDOPackageInfo packageInfo;
        if (value instanceof EPackage) {
            return packageRegistry.getPackageInfo((EPackage)value);
        }
        if (value instanceof CDOPackageInfo && (packageInfo = (CDOPackageInfo)value).getPackageUnit().getPackageRegistry() == packageRegistry) {
            return packageInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CDOClassInfo getClassInfo(EClass eClass) {
        EClass eClass2 = eClass;
        synchronized (eClass2) {
            EList adapters = eClass.eAdapters();
            CDOClassInfo classInfo = (CDOClassInfo)EcoreUtil.getAdapter((List)adapters, CDOClassInfo.class);
            if (classInfo == null) {
                classInfo = new CDOClassInfoImpl();
                adapters.add((Object)classInfo);
            }
            return classInfo;
        }
    }

    public static EStructuralFeature[] getAllPersistentFeatures(EClass eClass) {
        CDOClassInfo classInfo = CDOModelUtil.getClassInfo(eClass);
        return classInfo.getAllPersistentFeatures();
    }

    public static CDOPackageUnit createPackageUnit() {
        return new CDOPackageUnitImpl();
    }

    public static CDOPackageInfo createPackageInfo() {
        return new CDOPackageInfoImpl();
    }

    public static void writePackage(ExtendedDataOutput out, EPackage ePackage, boolean zipped, EPackage.Registry packageRegistry) throws IOException {
        byte[] bytes = EMFUtil.getEPackageBytes(ePackage, zipped, packageRegistry);
        out.writeString(ePackage.getNsURI());
        out.writeBoolean(zipped);
        out.writeByteArray(bytes);
    }

    public static EPackage readPackage(ExtendedDataInput in, EPackage.Registry packageRegistry) throws IOException {
        String uri = in.readString();
        boolean zipped = in.readBoolean();
        byte[] bytes = in.readByteArray();
        return EMFUtil.createEPackage(uri, bytes, zipped, packageRegistry);
    }
}

