/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.common.model.CDOModelElement;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.model.resource.CDOResourceClass;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.server.db.IAttributeMapping;
import org.eclipse.emf.cdo.server.db.IClassMapping;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreReader;
import org.eclipse.emf.cdo.server.db.IDBStoreWriter;
import org.eclipse.emf.cdo.server.db.IReferenceMapping;
import org.eclipse.emf.cdo.server.internal.db.AttributeMapping;
import org.eclipse.emf.cdo.server.internal.db.DBStore;
import org.eclipse.emf.cdo.server.internal.db.MappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.ReferenceMapping;
import org.eclipse.emf.cdo.server.internal.db.ServerInfo;
import org.eclipse.emf.cdo.server.internal.db.ToMany;
import org.eclipse.emf.cdo.server.internal.db.ToOneReferenceMapping;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassMapping
implements IClassMapping {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, ClassMapping.class);
    private MappingStrategy mappingStrategy;
    private CDOClass cdoClass;
    private IDBTable table;
    private Set<IDBTable> affectedTables = new HashSet<IDBTable>();
    private List<IAttributeMapping> attributeMappings;
    private List<IReferenceMapping> referenceMappings;
    private String selectPrefix;

    public ClassMapping(MappingStrategy mappingStrategy, CDOClass cdoClass, CDOFeature[] features) {
        this.mappingStrategy = mappingStrategy;
        this.cdoClass = cdoClass;
        this.table = this.addTable(cdoClass.getName());
        this.initTable(this.table, this.hasFullRevisionInfo());
        if (features != null) {
            this.attributeMappings = this.createAttributeMappings(features);
            this.referenceMappings = this.createReferenceMappings(features);
            CDOResourceClass resourceClass = cdoClass.getPackageManager().getCDOResourcePackage().getCDOResourceClass();
            if (cdoClass == resourceClass) {
                for (IAttributeMapping attributeMapping : this.attributeMappings) {
                    if (attributeMapping.getFeature() != resourceClass.getCDOPathFeature()) continue;
                    IDBField versionField = this.table.getField("cdo_version");
                    IDBField pathField = attributeMapping.getField();
                    pathField.setPrecision(760);
                    pathField.setNotNull(true);
                    this.table.addIndex(IDBIndex.Type.UNIQUE, new IDBField[]{versionField, pathField});
                    break;
                }
            }
        }
        this.selectPrefix = this.createSelectPrefix();
    }

    @Override
    public MappingStrategy getMappingStrategy() {
        return this.mappingStrategy;
    }

    @Override
    public CDOClass getCDOClass() {
        return this.cdoClass;
    }

    @Override
    public IDBTable getTable() {
        return this.table;
    }

    @Override
    public Set<IDBTable> getAffectedTables() {
        return this.affectedTables;
    }

    protected void initTable(IDBTable table, boolean full) {
        table.addField("cdo_id", DBType.BIGINT, true);
        table.addField("cdo_version", DBType.INTEGER, true);
        if (full) {
            table.addField("cdo_class", DBType.INTEGER, true);
            table.addField("cdo_created", DBType.BIGINT, true);
            table.addField("cdo_revised", DBType.BIGINT, true);
            table.addField("cdo_resource", DBType.BIGINT, true);
            table.addField("cdo_container", DBType.BIGINT, true);
            table.addField("cdo_feature", DBType.INTEGER, true);
        }
    }

    protected void appendRevisionInfos(StringBuilder builder, InternalCDORevision revision, boolean full) {
        builder.append(CDOIDUtil.getLong((CDOID)revision.getID()));
        builder.append(", ");
        builder.append(revision.getVersion());
        if (full) {
            builder.append(", ");
            builder.append(ServerInfo.getDBID((CDOModelElement)revision.getCDOClass()));
            builder.append(", ");
            builder.append(revision.getCreated());
            builder.append(", ");
            builder.append(revision.getRevised());
            builder.append(", ");
            builder.append(CDOIDUtil.getLong((CDOID)revision.getResourceID()));
            builder.append(", ");
            builder.append(CDOIDUtil.getLong((CDOID)revision.getContainerID()));
            builder.append(", ");
            builder.append(revision.getContainingFeatureID());
        }
    }

    protected int sqlUpdate(IDBStoreWriter storeWriter, String sql) throws DBException {
        if (TRACER.isEnabled()) {
            TRACER.trace(sql);
        }
        try {
            Statement statement = storeWriter.getStatement();
            return statement.executeUpdate(sql);
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
    }

    protected String mangleTableName(String name, int attempt) {
        return this.getDBAdapter().mangleTableName(name, attempt);
    }

    protected String mangleFieldName(String name, int attempt) {
        return this.getDBAdapter().mangleFieldName(name, attempt);
    }

    protected IDBTable addTable(String name) {
        int attempt = 0;
        while (true) {
            String tableName = this.mangleTableName(name, attempt);
            try {
                IDBTable table = this.mappingStrategy.getStore().getDBSchema().addTable(tableName);
                this.affectedTables.add(table);
                return table;
            }
            catch (DBException ex) {
                if (TRACER.isEnabled()) {
                    TRACER.format("{0}. attempt to add table: {1} ({2})", new Object[]{attempt + 1, tableName, ex.getMessage()});
                }
                ++attempt;
                continue;
            }
            break;
        }
    }

    protected IDBField addField(CDOFeature cdoFeature, IDBTable table) throws DBException {
        DBType fieldType = this.getDBType(cdoFeature);
        int fieldLength = this.getDBLength(cdoFeature);
        int attempt = 0;
        while (true) {
            String fieldName = this.mangleFieldName(cdoFeature.getName(), attempt);
            try {
                IDBField field = table.addField(fieldName, fieldType, fieldLength);
                this.affectedTables.add(table);
                return field;
            }
            catch (DBException ex) {
                if (TRACER.isEnabled()) {
                    TRACER.format("{0}. attempt to add field: {1} ({2})", new Object[]{attempt + 1, fieldName, ex.getMessage()});
                }
                ++attempt;
                continue;
            }
            break;
        }
    }

    protected DBType getDBType(CDOFeature cdoFeature) {
        return DBStore.getDBType(cdoFeature.getType());
    }

    protected int getDBLength(CDOFeature cdoFeature) {
        CDOType type = cdoFeature.getType();
        return type == CDOType.STRING || type == CDOType.CUSTOM ? 32672 : -1;
    }

    protected IDBAdapter getDBAdapter() {
        IDBStore store = this.mappingStrategy.getStore();
        return store.getDBAdapter();
    }

    protected String createSelectPrefix() {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        if (this.hasFullRevisionInfo()) {
            builder.append("cdo_version");
            builder.append(", ");
            builder.append("cdo_created");
            builder.append(", ");
            builder.append("cdo_revised");
            builder.append(", ");
            builder.append("cdo_resource");
            builder.append(", ");
            builder.append("cdo_container");
            builder.append(", ");
            builder.append("cdo_feature");
        } else if (this.attributeMappings == null) {
            return null;
        }
        if (this.attributeMappings != null) {
            for (IAttributeMapping attributeMapping : this.attributeMappings) {
                builder.append(", ");
                builder.append(attributeMapping.getField());
            }
        }
        builder.append(" FROM ");
        builder.append(this.table);
        builder.append(" WHERE ");
        builder.append("cdo_id");
        builder.append("=");
        return builder.toString();
    }

    @Override
    public List<IAttributeMapping> getAttributeMappings() {
        return this.attributeMappings;
    }

    @Override
    public List<IReferenceMapping> getReferenceMappings() {
        return this.referenceMappings;
    }

    @Override
    public IReferenceMapping getReferenceMapping(CDOFeature feature) {
        for (IReferenceMapping referenceMapping : this.referenceMappings) {
            if (referenceMapping.getFeature() != feature) continue;
            return referenceMapping;
        }
        return null;
    }

    @Override
    public IAttributeMapping getAttributeMapping(CDOFeature feature) {
        for (IAttributeMapping attributeMapping : this.attributeMappings) {
            if (attributeMapping.getFeature() != feature) continue;
            return attributeMapping;
        }
        return null;
    }

    protected List<IAttributeMapping> createAttributeMappings(CDOFeature[] features) {
        ArrayList<IAttributeMapping> attributeMappings = new ArrayList<IAttributeMapping>();
        CDOFeature[] cDOFeatureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            CDOFeature feature = cDOFeatureArray[n2];
            if (feature.isReference()) {
                if (!feature.isMany()) {
                    attributeMappings.add(this.createToOneReferenceMapping(feature));
                }
            } else {
                attributeMappings.add(this.createAttributeMapping(feature));
            }
            ++n2;
        }
        return attributeMappings.isEmpty() ? null : attributeMappings;
    }

    protected List<IReferenceMapping> createReferenceMappings(CDOFeature[] features) {
        ArrayList<IReferenceMapping> referenceMappings = new ArrayList<IReferenceMapping>();
        CDOFeature[] cDOFeatureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            CDOFeature feature = cDOFeatureArray[n2];
            if (feature.isReference() && feature.isMany()) {
                referenceMappings.add(this.createReferenceMapping(feature));
            }
            ++n2;
        }
        return referenceMappings.isEmpty() ? null : referenceMappings;
    }

    protected AttributeMapping createAttributeMapping(CDOFeature feature) {
        CDOType type = feature.getType();
        if (type == CDOType.BOOLEAN || type == CDOType.BOOLEAN_OBJECT) {
            return new AttributeMapping.AMBoolean(this, feature);
        }
        if (type == CDOType.BYTE || type == CDOType.BYTE_OBJECT) {
            return new AttributeMapping.AMByte(this, feature);
        }
        if (type == CDOType.CHAR || type == CDOType.CHARACTER_OBJECT) {
            return new AttributeMapping.AMCharacter(this, feature);
        }
        if (type == CDOType.DATE) {
            return new AttributeMapping.AMDate(this, feature);
        }
        if (type == CDOType.DOUBLE || type == CDOType.DOUBLE_OBJECT) {
            return new AttributeMapping.AMDouble(this, feature);
        }
        if (type == CDOType.FLOAT || type == CDOType.FLOAT_OBJECT) {
            return new AttributeMapping.AMFloat(this, feature);
        }
        if (type == CDOType.INT || type == CDOType.INTEGER_OBJECT) {
            return new AttributeMapping.AMInteger(this, feature);
        }
        if (type == CDOType.LONG || type == CDOType.LONG_OBJECT) {
            return new AttributeMapping.AMLong(this, feature);
        }
        if (type == CDOType.OBJECT) {
            return new AttributeMapping.AMObject(this, feature);
        }
        if (type == CDOType.SHORT || type == CDOType.SHORT_OBJECT) {
            return new AttributeMapping.AMShort(this, feature);
        }
        if (type == CDOType.STRING || type == CDOType.CUSTOM) {
            return new AttributeMapping.AMString(this, feature);
        }
        throw new ImplementationError("Unrecognized CDOType: " + type);
    }

    protected ToOneReferenceMapping createToOneReferenceMapping(CDOFeature feature) {
        return new ToOneReferenceMapping(this, feature);
    }

    protected ReferenceMapping createReferenceMapping(CDOFeature feature) {
        return new ReferenceMapping(this, feature, ToMany.PER_REFERENCE);
    }

    protected abstract boolean hasFullRevisionInfo();

    @Override
    public void writeRevision(IDBStoreWriter storeWriter, CDORevision revision) {
        if (revision.getVersion() >= 2 && this.hasFullRevisionInfo()) {
            this.writeRevisedRow(storeWriter, (InternalCDORevision)revision);
        }
        this.writeAttributes(storeWriter, (InternalCDORevision)revision);
        if (this.referenceMappings != null) {
            this.writeReferences(storeWriter, (InternalCDORevision)revision);
        }
    }

    protected void writeRevisedRow(IDBStoreWriter storeWriter, InternalCDORevision revision) {
        StringBuilder builder = new StringBuilder();
        builder.append("UPDATE ");
        builder.append(this.table);
        builder.append(" SET ");
        builder.append("cdo_revised");
        builder.append("=");
        builder.append(revision.getCreated() - 1L);
        builder.append(" WHERE ");
        builder.append("cdo_id");
        builder.append("=");
        builder.append(CDOIDUtil.getLong((CDOID)revision.getID()));
        builder.append(" AND ");
        builder.append("cdo_version");
        builder.append("=");
        builder.append(revision.getVersion() - 1);
        this.sqlUpdate(storeWriter, builder.toString());
    }

    protected void writeAttributes(IDBStoreWriter storeWriter, InternalCDORevision revision) {
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT INTO ");
        builder.append(this.table);
        builder.append(" VALUES (");
        this.appendRevisionInfos(builder, revision, this.hasFullRevisionInfo());
        if (this.attributeMappings != null) {
            for (IAttributeMapping attributeMapping : this.attributeMappings) {
                builder.append(", ");
                attributeMapping.appendValue(builder, revision);
            }
        }
        builder.append(")");
        this.sqlUpdate(storeWriter, builder.toString());
    }

    protected void writeReferences(IDBStoreWriter storeWriter, InternalCDORevision revision) {
        for (IReferenceMapping referenceMapping : this.referenceMappings) {
            referenceMapping.writeReference(storeWriter, (CDORevision)revision);
        }
    }

    @Override
    public void readRevision(IDBStoreReader storeReader, CDORevision revision, int referenceChunk) {
        String where = "cdo_revised=0";
        this.readRevision(storeReader, (InternalCDORevision)revision, where, referenceChunk);
    }

    @Override
    public void readRevisionByTime(IDBStoreReader storeReader, CDORevision revision, long timeStamp, int referenceChunk) {
        StringBuilder where = new StringBuilder();
        where.append("(");
        where.append("cdo_revised");
        where.append("=0 OR ");
        where.append("cdo_revised");
        where.append(">=");
        where.append(timeStamp);
        where.append(") AND ");
        where.append(timeStamp);
        where.append(">=");
        where.append("cdo_created");
        this.readRevision(storeReader, (InternalCDORevision)revision, where.toString(), referenceChunk);
    }

    @Override
    public void readRevisionByVersion(IDBStoreReader storeReader, CDORevision revision, int version, int referenceChunk) {
        String where = "cdo_version=" + version;
        this.readRevision(storeReader, (InternalCDORevision)revision, where, referenceChunk);
    }

    protected void readRevision(IDBStoreReader storeReader, InternalCDORevision revision, String where, int referenceChunk) {
        this.readAttributes(storeReader, revision, where);
        if (this.referenceMappings != null) {
            this.readReferences(storeReader, revision, referenceChunk);
        }
    }

    protected void readAttributes(IDBStoreReader storeReader, InternalCDORevision revision, String where) {
        long id = CDOIDUtil.getLong((CDOID)revision.getID());
        StringBuilder builder = new StringBuilder(this.selectPrefix);
        builder.append(id);
        if (where != null) {
            builder.append(" AND ");
            builder.append(where);
        }
        String sql = builder.toString();
        if (TRACER.isEnabled()) {
            TRACER.trace(sql);
        }
        ResultSet resultSet = null;
        try {
            try {
                resultSet = storeReader.getStatement().executeQuery(sql);
                if (!resultSet.next()) {
                    throw new IllegalStateException("Revision not found: " + id);
                }
                int i = 0;
                if (this.hasFullRevisionInfo()) {
                    revision.setVersion(resultSet.getInt(++i));
                    revision.setCreated(resultSet.getLong(++i));
                    revision.setRevised(resultSet.getLong(++i));
                    revision.setResourceID(CDOIDUtil.createLong((long)resultSet.getLong(++i)));
                    revision.setContainerID(CDOIDUtil.createLong((long)resultSet.getLong(++i)));
                    revision.setContainingFeatureID(resultSet.getInt(++i));
                }
                if (this.attributeMappings != null) {
                    for (IAttributeMapping attributeMapping : this.attributeMappings) {
                        attributeMapping.extractValue(resultSet, ++i, revision);
                    }
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
    }

    protected void readReferences(IDBStoreReader storeReader, InternalCDORevision revision, int referenceChunk) {
        for (IReferenceMapping referenceMapping : this.referenceMappings) {
            referenceMapping.readReference(storeReader, (CDORevision)revision, referenceChunk);
        }
    }
}

