/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate;

import java.io.Closeable;
import java.io.InputStream;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateMappingProvider;
import org.eclipse.emf.cdo.server.internal.hibernate.bundle.OM;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.hibernate.cfg.Configuration;

public class FileHibernateMappingProvider
extends HibernateMappingProvider {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, FileHibernateMappingProvider.class);
    private final String[] mappingFileLocations;

    public FileHibernateMappingProvider(String ... mappingFileLocations) {
        if (mappingFileLocations == null || mappingFileLocations.length == 0) {
            throw new IllegalArgumentException("mappingFileLocations");
        }
        this.mappingFileLocations = mappingFileLocations;
    }

    public void addMapping(Configuration configuration) {
        if (TRACER.isEnabled()) {
            TRACER.trace("Adding hibernate mapping from location(s):");
        }
        String[] stringArray = this.mappingFileLocations;
        int n = this.mappingFileLocations.length;
        int n2 = 0;
        while (n2 < n) {
            String location = stringArray[n2];
            if (TRACER.isEnabled()) {
                TRACER.trace(location);
            }
            InputStream is = null;
            try {
                try {
                    is = this.getClass().getResourceAsStream(location);
                    configuration.addInputStream(is);
                }
                catch (Exception e) {
                    throw WrappedException.wrap((Exception)e);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(is);
                throw throwable;
            }
            IOUtil.close((Closeable)is);
            ++n2;
        }
    }
}

