/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.protocol;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.common.id.CDOIDObjectFactory;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackage;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.spi.common.InternalCDOPackage;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;
import org.eclipse.emf.internal.cdo.CDOSessionImpl;
import org.eclipse.emf.internal.cdo.CDOTransactionImpl;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.protocol.CDOClientRequest;
import org.eclipse.emf.internal.cdo.protocol.CommitTransactionResult;
import org.eclipse.emf.internal.cdo.util.RevisionAdjuster;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitTransactionRequest
extends CDOClientRequest<CommitTransactionResult> {
    private static final ContextTracer PROTOCOL = new ContextTracer(OM.DEBUG_PROTOCOL, CommitTransactionRequest.class);
    private CDOTransactionImpl transaction;

    public CommitTransactionRequest(IChannel channel, CDOTransactionImpl transaction) {
        super(channel);
        this.transaction = transaction;
    }

    protected short getSignalID() {
        return 13;
    }

    protected void requesting(ExtendedDataOutputStream out) throws IOException {
        List<CDOPackage> newPackages = this.transaction.getNewPackages();
        Collection<CDOResource> newResources = this.transaction.getNewResources().values();
        Collection<CDOObject> newObjects = this.transaction.getNewObjects().values();
        Collection<CDORevisionDelta> dirtyObjects = this.transaction.getRevisionDeltas().values();
        out.writeInt(this.transaction.getViewID());
        out.writeInt(newPackages.size());
        out.writeInt(newResources.size() + newObjects.size());
        out.writeInt(dirtyObjects.size());
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Writing {0} new packages", new Object[]{newPackages.size()});
        }
        for (CDOPackage newPackage : newPackages) {
            if (PROTOCOL.isEnabled()) {
                PROTOCOL.format("Writing package {0}", new Object[]{newPackage});
            }
            CDOModelUtil.writePackage((ExtendedDataOutput)out, (CDOPackage)newPackage);
        }
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Writing {0} new objects", new Object[]{newResources.size() + newObjects.size()});
        }
        this.writeRevisions(out, newResources);
        this.writeRevisions(out, newObjects);
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Writing {0} dirty objects", new Object[]{dirtyObjects.size()});
        }
        RevisionAdjuster revisionAdjuster = new RevisionAdjuster(this.transaction);
        for (CDORevisionDelta revisionDelta : dirtyObjects) {
            revisionDelta.write((ExtendedDataOutput)out, (CDOIDProvider)this.transaction);
            CDOObject object = this.transaction.getDirtyObjects().get(revisionDelta.getID());
            InternalCDORevision revision = (InternalCDORevision)object.cdoRevision();
            revisionAdjuster.adjustRevision(revision, revisionDelta);
        }
    }

    protected CommitTransactionResult confirming(ExtendedDataInputStream in) throws IOException {
        CDOIDTemp oldID;
        boolean success = in.readBoolean();
        if (!success) {
            String rollbackMessage = in.readString();
            OM.LOG.error(rollbackMessage);
            return new CommitTransactionResult(rollbackMessage);
        }
        long timeStamp = in.readLong();
        CommitTransactionResult result = new CommitTransactionResult(timeStamp);
        CDOSessionImpl session = this.transaction.getSession();
        List<CDOPackage> newPackages = this.transaction.getNewPackages();
        for (CDOPackage newPackage : newPackages) {
            if (newPackage.getParentURI() != null) continue;
            CDOIDMetaRange oldRange = newPackage.getMetaIDRange();
            CDOIDMetaRange newRange = CDOIDUtil.readMetaRange((ExtendedDataInput)in);
            ((InternalCDOPackage)newPackage).setMetaIDRange(newRange);
            int i = 0;
            while (i < oldRange.size()) {
                CDOIDTemp oldID2 = (CDOIDTemp)oldRange.get(i);
                CDOID newID = newRange.get(i);
                session.remapMetaInstance((CDOID)oldID2, newID);
                result.addIDMapping(oldID2, newID);
                ++i;
            }
        }
        while (!(oldID = (CDOIDTemp)CDOIDUtil.read((ExtendedDataInput)in, (CDOIDObjectFactory)session)).isNull()) {
            CDOID newID = CDOIDUtil.read((ExtendedDataInput)in, (CDOIDObjectFactory)session);
            result.addIDMapping(oldID, newID);
        }
        return result;
    }

    private void writeDirtyObjects(ExtendedDataOutputStream out) throws IOException {
        Collection<CDOObject> dirtyObjects = this.transaction.getDirtyObjects().values();
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Writing {0} dirty objects", new Object[]{dirtyObjects.size()});
        }
        this.writeRevisions(out, dirtyObjects);
    }

    private void writeRevisions(ExtendedDataOutputStream out, Collection<?> objects) throws IOException {
        for (CDOObject object : objects) {
            CDORevision revision = object.cdoRevision();
            revision.write((ExtendedDataOutput)out, (CDOIDProvider)this.transaction, -1);
        }
    }
}

