/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.net4j.protocol;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.cdo.internal.common.id.CDOIDExternalTempImpl;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.internal.cdo.net4j.protocol.CommitTransactionPhase1Request;
import org.eclipse.emf.internal.cdo.net4j.protocol.CommitTransactionRequest;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOXATransaction;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class CommitTransactionPhase2Request
extends CommitTransactionRequest {
    private static final ContextTracer PROTOCOL = new ContextTracer(OM.DEBUG_PROTOCOL, CommitTransactionPhase1Request.class);

    public CommitTransactionPhase2Request(CDOClientProtocol protocol, InternalCDOXATransaction.InternalCDOXACommitContext xaContext) {
        super(protocol, (short)14, xaContext);
    }

    protected InternalCDOXATransaction.InternalCDOXACommitContext getCommitContext() {
        return (InternalCDOXATransaction.InternalCDOXACommitContext)super.getCommitContext();
    }

    protected void requesting(CDODataOutput out, OMMonitor monitor) throws IOException {
        this.requestingTransactionInfo(out);
        this.requestingIdMapping(out);
    }

    protected CDOSessionProtocol.CommitTransactionResult confirming(CDODataInput in, OMMonitor monitor) throws IOException {
        return this.confirmingCheckError(in);
    }

    protected void requestingIdMapping(CDODataOutput out) throws IOException {
        InternalCDOXATransaction.InternalCDOXACommitContext context = this.getCommitContext();
        Map<CDOIDExternalTempImpl, InternalCDOTransaction> requestedIDs = context.getRequestedIDs();
        int size = requestedIDs.size();
        out.writeInt(size);
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Number of ids requested: {0}", new Object[]{size});
        }
        for (Map.Entry<CDOIDExternalTempImpl, InternalCDOTransaction> entry : requestedIDs.entrySet()) {
            CDOIDExternalTempImpl tempID = entry.getKey();
            URI oldURIExternal = URI.createURI((String)tempID.toURIFragment());
            CDOID oldCDOID = CDOIDUtil.read((String)oldURIExternal.fragment(), null);
            InternalCDOXATransaction.InternalCDOXACommitContext commitContext = context.getTransactionManager().getCommitContext(entry.getValue());
            if (commitContext == null) {
                throw new IllegalStateException(MessageFormat.format(Messages.getString("CommitTransactionPhase2Request.1"), entry.getValue()));
            }
            CDOID newID = commitContext.getResult().getIDMappings().get(oldCDOID);
            if (newID == null) {
                throw new IllegalStateException(MessageFormat.format(Messages.getString("CommitTransactionPhase2Request.2"), oldCDOID.toURIFragment()));
            }
            CDOID newIDExternal = CDOURIUtil.convertExternalCDOID(oldURIExternal, newID);
            if (PROTOCOL.isEnabled()) {
                PROTOCOL.format("ID mapping: {0} --> {1}", new Object[]{tempID.toURIFragment(), newIDExternal.toURIFragment()});
            }
            out.writeCDOID((CDOID)tempID);
            out.writeCDOID(newIDExternal);
            context.getResult().addIDMapping((CDOIDTemp)tempID, newIDExternal);
        }
    }
}

