/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.tcp;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.internal.net4j.connector.Connector;
import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.connector.ConnectorException;
import org.eclipse.net4j.connector.ConnectorState;
import org.eclipse.net4j.internal.tcp.ControlChannel;
import org.eclipse.net4j.internal.tcp.bundle.OM;
import org.eclipse.net4j.protocol.IProtocol;
import org.eclipse.net4j.tcp.ITCPActiveSelectorListener;
import org.eclipse.net4j.tcp.ITCPConnector;
import org.eclipse.net4j.tcp.ITCPSelector;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.security.INegotiationContext;
import org.eclipse.net4j.util.security.NegotiationContext;
import org.eclipse.spi.net4j.InternalChannel;

public abstract class TCPConnector
extends Connector
implements ITCPConnector,
ITCPActiveSelectorListener {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, TCPConnector.class);
    private SocketChannel socketChannel;
    private ITCPSelector selector;
    private SelectionKey selectionKey;
    private BlockingQueue<InternalChannel> writeQueue = new LinkedBlockingQueue<InternalChannel>();
    private IBuffer inputBuffer;
    private ControlChannel controlChannel;
    private String host;
    private int port;

    public String getHost() {
        return this.host;
    }

    void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    void setPort(int port) {
        this.port = port;
    }

    public ITCPSelector getSelector() {
        return this.selector;
    }

    public void setSelector(ITCPSelector selector) {
        this.selector = selector;
    }

    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    public void setSocketChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
    }

    public String getURL() {
        return "tcp://" + this.host + ":" + this.port;
    }

    public void handleRegistration(ITCPSelector selector, SocketChannel socketChannel) {
        try {
            int interest = this.isClient() ? 8 : 1;
            this.selectionKey = socketChannel.register(selector.getSocketSelector(), interest, this);
            if (this.isServer()) {
                this.leaveConnecting();
            }
        }
        catch (ClosedChannelException closedChannelException) {
            this.deactivate();
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
            this.deactivate();
        }
    }

    public void handleConnect(ITCPSelector selector, SocketChannel channel) {
        try {
            if (channel.finishConnect()) {
                selector.orderConnectInterest(this.selectionKey, true, false);
                selector.orderReadInterest(this.selectionKey, true, true);
                this.leaveConnecting();
            }
        }
        catch (ClosedChannelException closedChannelException) {
            this.deactivate();
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
            this.deactivate();
        }
    }

    public void handleRead(ITCPSelector selector, SocketChannel socketChannel) {
        try {
            ByteBuffer byteBuffer;
            if (this.inputBuffer == null) {
                this.inputBuffer = this.getBufferProvider().provideBuffer();
            }
            if ((byteBuffer = this.inputBuffer.startGetting(socketChannel)) != null) {
                ControlChannel channel;
                short channelIndex = this.inputBuffer.getChannelIndex();
                ControlChannel controlChannel = channel = channelIndex == -1 ? this.controlChannel : this.getChannel(channelIndex);
                if (channel != null) {
                    channel.handleBufferFromMultiplexer(this.inputBuffer);
                } else {
                    if (TRACER.isEnabled()) {
                        TRACER.trace("Discarding buffer from unknown channel");
                    }
                    this.inputBuffer.release();
                }
                this.inputBuffer = null;
            }
        }
        catch (IOException iOException) {
            this.deactivate();
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
            this.deactivate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void multiplexChannel(IChannel channel) {
        BlockingQueue<InternalChannel> blockingQueue = this.writeQueue;
        synchronized (blockingQueue) {
            boolean firstChannel = this.writeQueue.isEmpty();
            try {
                this.writeQueue.put((InternalChannel)channel);
            }
            catch (InterruptedException ex) {
                throw WrappedException.wrap((Exception)ex);
            }
            if (firstChannel) {
                this.checkSelectionKey();
                this.selector.orderWriteInterest(this.selectionKey, this.isClient(), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleWrite(ITCPSelector selector, SocketChannel socketChannel) {
        try {
            BlockingQueue<InternalChannel> blockingQueue = this.writeQueue;
            synchronized (blockingQueue) {
                IBuffer buffer;
                Queue bufferQueue;
                InternalChannel channel = (InternalChannel)this.writeQueue.peek();
                if (channel != null && (bufferQueue = channel.getSendQueue()) != null && (buffer = (IBuffer)bufferQueue.peek()) != null && buffer.write(socketChannel)) {
                    this.writeQueue.poll();
                    bufferQueue.poll();
                    buffer.release();
                }
                if (this.writeQueue.isEmpty()) {
                    this.checkSelectionKey();
                    selector.orderWriteInterest(this.selectionKey, this.isClient(), false);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ClosedChannelException closedChannelException) {
            this.deactivate();
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
            this.deactivate();
        }
    }

    protected void registerChannelWithPeer(int channelID, short channelIndex, IProtocol protocol, long timeout) throws ConnectorException {
        try {
            if (!this.controlChannel.registerChannel(channelID, channelIndex, protocol, timeout)) {
                throw new ConnectorException("Failed to register channel with peer");
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConnectorException((Throwable)ex);
        }
    }

    public void inverseRemoveChannel(int channelID, short channelIndex) {
        try {
            InternalChannel channel = this.getChannel(channelIndex);
            if (channel instanceof ControlChannel) {
                return;
            }
            if (channel != null) {
                super.removeChannel((IChannel)channel);
            }
        }
        catch (RuntimeException ex) {
            OM.LOG.warn((Throwable)ex);
        }
    }

    public boolean removeChannel(IChannel channel) {
        if (channel instanceof ControlChannel) {
            return true;
        }
        if (super.removeChannel(channel)) {
            if (this.controlChannel != null && this.isConnected()) {
                this.controlChannel.deregisterChannel(channel.getChannelID(), channel.getChannelIndex());
            }
            return true;
        }
        return false;
    }

    protected INegotiationContext createNegotiationContext() {
        return new TCPNegotiationContext();
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        if (this.socketChannel == null) {
            throw new IllegalStateException("socketChannel == null");
        }
        if (this.selector == null) {
            throw new IllegalStateException("selector == null");
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.controlChannel = new ControlChannel(this.getNextChannelID(), this);
        this.controlChannel.activate();
        this.selector.orderRegistration(this.socketChannel, this.isClient(), this);
    }

    protected void doDeactivate() throws Exception {
        this.selectionKey.cancel();
        LifecycleUtil.deactivate((Object)((Object)this.controlChannel));
        IOUtil.closeSilent((Closeable)this.socketChannel);
        this.controlChannel = null;
        this.socketChannel = null;
        super.doDeactivate();
    }

    private void checkSelectionKey() {
        if (this.selectionKey == null) {
            throw new IllegalStateException("selectionKey == null");
        }
    }

    private final class TCPNegotiationContext
    extends NegotiationContext {
        private IBuffer buffer;

        public void setUserID(String userID) {
            TCPConnector.this.setUserID(userID);
        }

        public ByteBuffer getBuffer() {
            this.buffer = TCPConnector.this.getBufferProvider().provideBuffer();
            ByteBuffer byteBuffer = this.buffer.startPutting((short)-1);
            byteBuffer.put((byte)1);
            return byteBuffer;
        }

        public void transmitBuffer(ByteBuffer byteBuffer) {
            if (this.buffer.getByteBuffer() != byteBuffer) {
                throw new IllegalArgumentException("The passed buffer is not the last that was produced");
            }
            TCPConnector.this.controlChannel.sendBuffer(this.buffer);
        }

        public void setFinished(boolean success) {
            if (success) {
                TCPConnector.this.setState(ConnectorState.CONNECTED);
            } else {
                OM.LOG.error("Connector negotiation failed: " + TCPConnector.this);
                TCPConnector.this.deactivate();
            }
            super.setFinished(success);
        }
    }
}

