/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.signal.failover;

import java.util.concurrent.TimeoutException;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.signal.RequestWithConfirmation;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.signal.failover.IFailOverEvent;
import org.eclipse.net4j.signal.failover.IFailOverStrategy;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.event.Notifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FailOverStrategy
extends Notifier
implements IFailOverStrategy {
    @Override
    public <RESULT> RESULT send(RequestWithConfirmation<RESULT> request) throws Exception {
        return this.send(request, -1L);
    }

    @Override
    public <RESULT> RESULT send(RequestWithConfirmation<RESULT> request, long timeout) throws Exception {
        while (true) {
            try {
                return request.send(timeout);
            }
            catch (TimeoutException timeoutException) {
                this.failOver(request.getProtocol());
                continue;
            }
            break;
        }
    }

    protected void failOver(SignalProtocol protocol) {
        IChannel oldChannel = protocol.getChannel();
        IConnector newConnector = this.getNewConnector(oldChannel);
        CheckUtil.checkNull((Object)newConnector, (String)"newConnector");
        IChannel newChannel = newConnector.openChannel(protocol);
        protocol.setChannel(newChannel);
        oldChannel.close();
        this.fireEvent(new FailOverEvent(oldChannel, newChannel, newConnector));
    }

    protected abstract IConnector getNewConnector(IChannel var1);

    private final class FailOverEvent
    implements IFailOverEvent {
        private IChannel oldChannel;
        private IChannel newChannel;
        private IConnector newConnector;

        public FailOverEvent(IChannel oldChannel, IChannel newChannel, IConnector newConnector) {
            this.oldChannel = oldChannel;
            this.newChannel = newChannel;
            this.newConnector = newConnector;
        }

        public IFailOverStrategy getSource() {
            return FailOverStrategy.this;
        }

        public IChannel getOldChannel() {
            return this.oldChannel;
        }

        public IChannel getNewChannel() {
            return this.newChannel;
        }

        public IConnector getNewConnector() {
            return this.newConnector;
        }
    }
}

