/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.TestExecutionContext;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.test.ClassLoaderTools;
import org.eclipse.test.LegacyXmlResultFormatter;
import org.eclipse.ui.testing.dumps.TimeoutDumpTimer;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.BundleWiring;

public class EclipseTestRunner {
    public static final int SUCCESS = 0;
    public static final int FAILURES = 1;
    public static final int ERRORS = 2;

    public static void main(String[] args) throws IOException {
        System.exit(EclipseTestRunner.run(args));
    }

    public static int run(String[] args) throws IOException {
        String className = null;
        String classesNames = null;
        String testPluginName = null;
        String testPluginsNames = null;
        String resultPathString = null;
        String timeoutString = null;
        String junitReportOutput = null;
        Properties props = new Properties();
        int startArgs = 0;
        if (args.length > 0 && !args[0].startsWith("-")) {
            className = args[0];
            ++startArgs;
        }
        int i = startArgs;
        while (i < args.length) {
            block44: {
                Object formatterString;
                if (args[i].toLowerCase().equals("-classname")) {
                    if (i < args.length - 1) {
                        className = args[i + 1];
                    }
                    ++i;
                } else if (args[i].toLowerCase().equals("-classesnames")) {
                    if (i < args.length - 1) {
                        classesNames = args[i + 1];
                    }
                    ++i;
                } else if (args[i].toLowerCase().equals("-testpluginname")) {
                    if (i < args.length - 1) {
                        testPluginName = args[i + 1];
                    }
                    ++i;
                } else if (args[i].toLowerCase().equals("-testpluginsnames")) {
                    if (i < args.length - 1) {
                        testPluginsNames = args[i + 1];
                    }
                    ++i;
                } else if (args[i].equals("-junitReportOutput")) {
                    if (i < args.length - 1) {
                        junitReportOutput = args[i + 1];
                    }
                    ++i;
                } else if (args[i].startsWith("haltOnError=")) {
                    System.err.println("The haltOnError option is no longer supported");
                } else if (args[i].startsWith("haltOnFailure=")) {
                    System.err.println("The haltOnFailure option is no longer supported");
                } else if (args[i].startsWith("formatter=")) {
                    formatterString = args[i].substring(10);
                    int seperatorIndex22 = ((String)formatterString).indexOf(44);
                    resultPathString = seperatorIndex22 == -1 ? null : ((String)formatterString).substring(seperatorIndex22 + 1);
                } else {
                    if (args[i].startsWith("propsfile=")) {
                        formatterString = null;
                        Object seperatorIndex22 = null;
                        try (FileInputStream in = new FileInputStream(args[i].substring(10));){
                            props.load(in);
                            break block44;
                        }
                        catch (Throwable seperatorIndex22) {
                            if (formatterString == null) {
                                formatterString = seperatorIndex22;
                            } else if (formatterString != seperatorIndex22) {
                                ((Throwable)formatterString).addSuppressed(seperatorIndex22);
                            }
                            throw formatterString;
                        }
                    }
                    if (args[i].equals("-testlistener")) {
                        System.err.println("The testlistener option is no longer supported");
                    } else if (args[i].equals("-timeout")) {
                        if (i < args.length - 1) {
                            timeoutString = args[i + 1];
                        }
                        ++i;
                    }
                }
            }
            ++i;
        }
        Properties p = System.getProperties();
        Enumeration _enum = ((Hashtable)p).keys();
        while (_enum.hasMoreElements()) {
            Object key = _enum.nextElement();
            props.put(key, ((Hashtable)p).get(key));
        }
        if (timeoutString == null || timeoutString.isEmpty()) {
            System.err.println("INFO: optional timeout was not specified.");
        } else {
            String timeoutScreenOutputDir = null;
            timeoutScreenOutputDir = junitReportOutput == null || junitReportOutput.isEmpty() ? "timeoutScreens" : String.valueOf(junitReportOutput) + "/timeoutScreens";
            System.err.println("INFO: timeoutScreenOutputDir: " + timeoutScreenOutputDir);
            System.err.println("INFO: timeout: " + timeoutString);
            EclipseTestRunner.startStackDumpTimeoutTimer(timeoutString, new File(timeoutScreenOutputDir));
        }
        if (testPluginsNames != null && classesNames != null) {
            String[] testPlugins = testPluginsNames.split(",");
            String[] suiteClasses = classesNames.split(",");
            int returnCode = 0;
            int j = 0;
            EclipseTestRunner runner = new EclipseTestRunner();
            String[] stringArray = suiteClasses;
            int n = suiteClasses.length;
            int n2 = 0;
            while (n2 < n) {
                String oneClassName = stringArray[n2];
                int result = runner.runTests(props, testPlugins[j], oneClassName, resultPathString, true);
                ++j;
                if (result != 0) {
                    returnCode = result;
                }
                ++n2;
            }
            return returnCode;
        }
        if (className == null) {
            throw new IllegalArgumentException("Test class name not specified");
        }
        EclipseTestRunner runner = new EclipseTestRunner();
        return runner.runTests(props, testPluginName, className, resultPathString, false);
    }

    private int runTests(Properties props, String testPluginName, String testClassName, String resultPath, boolean multiTest) {
        ClassLoader currentTCCL = Thread.currentThread().getContextClassLoader();
        ExecutionListener executionListener = new ExecutionListener();
        if (testPluginName == null) {
            testPluginName = ClassLoaderTools.getClassPlugin(testClassName);
        }
        if (testPluginName == null) {
            throw new IllegalArgumentException("Test class not found");
        }
        LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request().selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass((String)testClassName)}).build();
        try {
            Thread.currentThread().setContextClassLoader(ClassLoaderTools.getJUnit5Classloader(this.getPlatformEngines()));
            Launcher launcher = LauncherFactory.create();
            Thread.currentThread().setContextClassLoader(ClassLoaderTools.getPluginClassLoader(testPluginName, currentTCCL));
            try {
                Throwable throwable = null;
                Object var11_13 = null;
                try (LegacyXmlResultFormatter legacyXmlResultFormatter = new LegacyXmlResultFormatter();){
                    Throwable throwable2 = null;
                    Object var14_18 = null;
                    try (OutputStream fileOutputStream = this.getResultOutputStream(resultPath, testClassName, multiTest);){
                        legacyXmlResultFormatter.setDestination(fileOutputStream);
                        legacyXmlResultFormatter.setContext(new ExecutionContext(props));
                        launcher.execute(request, new TestExecutionListener[]{legacyXmlResultFormatter, executionListener});
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                Thread.currentThread().setContextClassLoader(currentTCCL);
                return 2;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentTCCL);
        }
        return executionListener.didExecutionContainedFailures() ? 1 : 0;
    }

    private OutputStream getResultOutputStream(String resultPathString, String testClassName, boolean multiTest) throws IOException {
        File resultFile;
        if (resultPathString == null || resultPathString.isEmpty()) {
            return System.out;
        }
        if (multiTest) {
            Path resultDirectoryPath = new Path(resultPathString);
            File testDirectory = resultDirectoryPath.toFile();
            if (!testDirectory.exists()) {
                testDirectory.mkdirs();
            }
            resultFile = resultDirectoryPath.append("TEST-" + testClassName + ".xml").toFile();
        } else {
            Path resultPath = new Path(resultPathString);
            resultFile = resultPath.toFile();
            if (resultFile.isDirectory()) {
                resultFile = resultPath.append("TEST-" + testClassName + ".xml").toFile();
            } else {
                File resultDirectory = resultFile.getParentFile();
                if (!resultDirectory.exists()) {
                    resultDirectory.mkdirs();
                }
            }
        }
        if (!resultFile.exists()) {
            resultFile.createNewFile();
        }
        return new FileOutputStream(resultFile);
    }

    private List<String> getPlatformEngines() {
        Bundle[] bundles;
        ArrayList<String> platformEngines = new ArrayList<String>();
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        Bundle[] bundleArray = bundles = bundle.getBundleContext().getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle iBundle = bundleArray[n2];
            try {
                BundleWiring bundleWiring = (BundleWiring)Platform.getBundle((String)iBundle.getSymbolicName()).adapt(BundleWiring.class);
                Collection listResources = bundleWiring.listResources("META-INF/services", "org.junit.platform.engine.TestEngine", 2);
                if (!listResources.isEmpty()) {
                    platformEngines.add(iBundle.getSymbolicName());
                }
            }
            catch (Exception exception) {}
            ++n2;
        }
        return platformEngines;
    }

    private static void startStackDumpTimeoutTimer(String timeoutArg, File outputDirectory) {
        TimeoutDumpTimer.startTimeoutDumpTimer((String)timeoutArg, (File)outputDirectory);
    }

    private final class ExecutionContext
    implements TestExecutionContext {
        private final Properties props;

        ExecutionContext(Properties props) {
            this.props = props;
        }

        public Properties getProperties() {
            return this.props;
        }

        public Optional<Project> getProject() {
            return null;
        }
    }

    private final class ExecutionListener
    implements TestExecutionListener {
        private boolean executionContainedFailures = false;

        public boolean didExecutionContainedFailures() {
            return this.executionContainedFailures;
        }

        public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
            if (testExecutionResult.getStatus() == TestExecutionResult.Status.FAILED) {
                this.executionContainedFailures = true;
            }
        }
    }

    static class ThreadDump
    extends Exception {
        private static final long serialVersionUID = 1L;

        ThreadDump(String message) {
            super(message);
        }
    }
}

