/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.codegen.ecore.ui.launcher;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.eef.codegen.ecore.EMFCodegenPlugin;
import org.eclipse.emf.eef.codegen.flow.Workflow;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class GenerateEMFCodeAction
implements IObjectActionDelegate {
    protected Shell shell;
    protected List<GenModel> emfGenModels;
    protected IWorkspace workspace = ResourcesPlugin.getWorkspace();

    public GenerateEMFCodeAction() {
        this.emfGenModels = new ArrayList<GenModel>();
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        try {
            if (this.emfGenModels != null) {
                final Workflow flow = this.initEMFGenFlow();
                flow.prepare();
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        flow.execute(monitor);
                        monitor.done();
                    }
                };
                new ProgressMonitorDialog(this.shell).run(true, true, runnable);
            }
        }
        catch (InvocationTargetException e) {
            EMFCodegenPlugin.getDefault().logError(e);
        }
        catch (InterruptedException e) {
            EMFCodegenPlugin.getDefault().logWarning(e);
        }
    }

    protected abstract Workflow initEMFGenFlow();

    public void selectionChanged(IAction action, ISelection selection) {
        this.emfGenModels.clear();
        if (selection instanceof StructuredSelection) {
            StructuredSelection sSelection = (StructuredSelection)selection;
            for (Object selectedElement : sSelection.toList()) {
                if (!(selectedElement instanceof GenModel)) continue;
                this.emfGenModels.add((GenModel)selectedElement);
            }
        }
    }

    protected IProject extractProject(String sPath) {
        Path path = new Path(sPath);
        if (path.isEmpty()) {
            return null;
        }
        return this.workspace.getRoot().getProject(path.segment(0));
    }
}

