/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.codegen.ecore.ui.launcher;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.ecore.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.eef.codegen.ecore.main.GenEdit;
import org.eclipse.emf.eef.codegen.ecore.ui.launcher.GenerateEMFCodeAction;
import org.eclipse.emf.eef.codegen.ecore.util.EEFGeneratorAdapter;
import org.eclipse.emf.eef.codegen.flow.Step;
import org.eclipse.emf.eef.codegen.flow.Workflow;

public class GenerateEMFEditCodeAction
extends GenerateEMFCodeAction {
    protected Workflow initEMFGenFlow() {
        Workflow flow = new Workflow("Generate EMF edit code ", this.shell);
        for (final GenModel emfGenModel : this.emfGenModels) {
            String s1 = "Generate EMF Edit code for " + emfGenModel.eResource().getURI().lastSegment();
            flow.addStep(s1, new Step("EMF EDIT"){

                public IStatus execute(IProgressMonitor monitor) {
                    IProject editProject = GenerateEMFEditCodeAction.this.extractProject(emfGenModel.getEditProjectDirectory());
                    if (editProject == null) {
                        return Status.OK_STATUS;
                    }
                    IProject modelProject = GenerateEMFEditCodeAction.this.workspace.getRoot().getProject(emfGenModel.getModelProjectDirectory());
                    UniqueEList referencedProjects = new UniqueEList();
                    referencedProjects.add(modelProject);
                    if (!GenerateEMFEditCodeAction.this.workspace.getRoot().exists(editProject.getFullPath())) {
                        Generator.createEMFProject((IPath)new Path(emfGenModel.getEditDirectory()), null, (List)referencedProjects, (IProgressMonitor)new SubProgressMonitor(monitor, -1), (int)(Generator.EMF_EDIT_PROJECT_STYLE | Generator.EMF_PLUGIN_PROJECT_STYLE));
                    } else if (!editProject.isAccessible()) {
                        try {
                            editProject.open(monitor);
                        }
                        catch (CoreException e) {
                            return new Status(4, "org.eclipse.emf.eef.codegen.ecore", e.getMessage(), (Throwable)e);
                        }
                    }
                    ArrayList args = new ArrayList();
                    File editDirectory = editProject.getLocation().toFile();
                    try {
                        GenEdit generator = new GenEdit((EObject)emfGenModel, editDirectory, args);
                        generator.doGenerate(BasicMonitor.toMonitor((IProgressMonitorWithBlocking)new SubProgressMonitor(monitor, -1)));
                    }
                    catch (IOException e) {
                        return new Status(4, "org.eclipse.emf.eef.codegen.ecore", e.getMessage(), (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            });
            String s2prime = "Formatting generated files";
            flow.addStep(s2prime, new Step(s2prime){

                public IStatus execute(IProgressMonitor monitor) {
                    EEFGeneratorAdapter eefGen = new EEFGeneratorAdapter();
                    eefGen.generate(emfGenModel, "org.eclipse.emf.codegen.ecore.genmodel.generator.EditProject", BasicMonitor.toMonitor((IProgressMonitorWithBlocking)new SubProgressMonitor(monitor, -1)));
                    return Status.OK_STATUS;
                }
            });
            String s3 = "Refresh workspace " + emfGenModel.eResource().getURI().toString();
            flow.addStep(s3, new Step("REFRESH"){

                public IStatus execute(IProgressMonitor monitor) {
                    IProject editProject = GenerateEMFEditCodeAction.this.extractProject(emfGenModel.getEditProjectDirectory());
                    if (editProject == null) {
                        return Status.OK_STATUS;
                    }
                    try {
                        if (!editProject.isOpen()) {
                            editProject.open(monitor);
                        }
                        editProject.refreshLocal(2, monitor);
                    }
                    catch (CoreException e) {
                        return new Status(4, "org.eclipse.emf.eef.codegen.ecore", e.getMessage(), (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            });
        }
        return flow;
    }
}

