/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.codegen.ecore.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.generator.AbstractGeneratorAdapter;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;

public class EEFGeneratorAdapter
extends AbstractGeneratorAdapter {
    private static final String JAVA_EXT_FILE = "java";

    public boolean canGenerate(Object object, Object projectType) {
        return EMFPlugin.IS_ECLIPSE_RUNNING && object instanceof GenModel;
    }

    protected Diagnostic doGenerate(Object object, Object projectType, Monitor monitor) throws Exception {
        block3: {
            IProgressMonitor progressMonitor;
            Object codeFormatter;
            IFolder folder;
            GenModel genmodel;
            block2: {
                genmodel = (GenModel)object;
                folder = null;
                codeFormatter = this.createCodeFormatter(null, URI.createPlatformResourceURI((String)genmodel.getEditDirectory(), (boolean)true));
                progressMonitor = BasicMonitor.toIProgressMonitor((Monitor)monitor);
                if (projectType != "org.eclipse.emf.codegen.ecore.genmodel.generator.EditProject") break block2;
                for (GenPackage genPack : genmodel.getGenPackages()) {
                    IPath path = this.buildProviderPath(genmodel, genPack);
                    folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
                    if (folder == null || !folder.isAccessible()) continue;
                    folder.accept((IResourceVisitor)new ResourceVisitorFormatter(codeFormatter, progressMonitor));
                }
                break block3;
            }
            if (projectType != "org.eclipse.emf.codegen.ecore.genmodel.generator.EditorProject") break block3;
            for (GenPackage genPack : genmodel.getGenPackages()) {
                IPath path = this.buildPresentationPath(genmodel, genPack);
                folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
                if (folder == null || !folder.isAccessible()) continue;
                folder.accept((IResourceVisitor)new ResourceVisitorFormatter(codeFormatter, progressMonitor));
            }
        }
        return Diagnostic.OK_INSTANCE;
    }

    protected IPath buildProviderPath(GenModel genmodel, GenPackage genPack) {
        String pathStr = genmodel.getEditDirectory();
        if (genPack.getProviderPackageName() != null && !genPack.getProviderPackageName().equals("")) {
            pathStr = String.valueOf(pathStr) + "/" + genPack.getProviderPackageName().replaceAll("\\.", "/");
        }
        Path path = new Path(pathStr);
        return path;
    }

    protected IPath buildPresentationPath(GenModel genmodel, GenPackage genPack) {
        String pathStr = genmodel.getEditorDirectory();
        if (genPack.getPresentationPackageName() != null && !genPack.getPresentationPackageName().equals("")) {
            pathStr = String.valueOf(pathStr) + "/" + genPack.getPresentationPackageName().replaceAll("\\.", "/");
        }
        Path path = new Path(pathStr);
        return path;
    }

    private final class ResourceVisitorFormatter
    implements IResourceVisitor {
        private final Object codeFormatter;
        private final IProgressMonitor progressMonitor;

        private ResourceVisitorFormatter(Object codeFormatter, IProgressMonitor progressMonitor) {
            this.codeFormatter = codeFormatter;
            this.progressMonitor = progressMonitor;
        }

        public boolean visit(IResource resource) throws CoreException {
            try {
                if (resource instanceof IFile && ((IFile)resource).getFileExtension().equals(EEFGeneratorAdapter.JAVA_EXT_FILE)) {
                    this.formatFile((IFile)resource, this.codeFormatter, this.progressMonitor);
                }
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        private void formatFile(IFile file, Object codeFormatter, IProgressMonitor progressMonitor) throws Exception {
            URI createPlatformResourceURI = URI.createURI((String)file.getFullPath().toString(), (boolean)true);
            String contentsStr = EEFGeneratorAdapter.this.getContents(createPlatformResourceURI, null);
            String formatedContentsStr = EEFGeneratorAdapter.this.formatCode(contentsStr, codeFormatter);
            ByteArrayInputStream formatedContents = new ByteArrayInputStream(formatedContentsStr.getBytes());
            file.setContents((InputStream)formatedContents, true, true, progressMonitor);
            formatedContents.close();
        }
    }
}

