/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.query.compound;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.eef.runtime.query.QueryProcessor;
import org.eclipse.emf.eef.runtime.query.QueryResult;
import org.eclipse.emf.eef.runtime.query.QueryWrapper;

public class CompoundProcessor
implements QueryProcessor {
    private List<QueryProcessor> processors;

    public CompoundProcessor() {
        this.processors = new ArrayList<QueryProcessor>();
    }

    public CompoundProcessor(QueryProcessor[] processors) {
        this.processors = Arrays.asList(processors);
    }

    public void addProcessor(QueryProcessor processor) {
        this.processors.add(processor);
    }

    public void removeProcessor(QueryProcessor processor) {
        this.processors.remove(processor);
    }

    public QueryResult evaluate(EObject context, QueryWrapper query) {
        for (QueryProcessor processor : this.processors) {
            if (!processor.canEvaluate(query)) continue;
            return processor.evaluate(context, query);
        }
        return new QueryResult((IStatus)new Status(4, "org.eclipse.emf.eef.query", "No processor can evaluate this query."), null);
    }

    public boolean canEvaluate(QueryWrapper query) {
        for (QueryProcessor processor : this.processors) {
            if (!processor.canEvaluate(query)) continue;
            return true;
        }
        return false;
    }
}

