/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.impl.components;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.eef.runtime.api.component.IPropertiesEditionComponent;
import org.eclipse.emf.eef.runtime.api.notify.IPropertiesEditionEvent;
import org.eclipse.emf.eef.runtime.api.notify.IPropertiesEditionListener;
import org.eclipse.emf.eef.runtime.api.notify.PropertiesEditingSemanticLister;
import org.eclipse.emf.eef.runtime.api.parts.IPropertiesEditionPart;
import org.eclipse.emf.eef.runtime.context.PropertiesEditingContext;
import org.eclipse.emf.eef.runtime.context.impl.EObjectPropertiesEditionContext;
import org.eclipse.emf.eef.runtime.impl.command.StandardEditingCommand;
import org.eclipse.emf.eef.runtime.impl.notify.PropertiesValidationEditionEvent;

public abstract class StandardPropertiesEditionComponent
implements IPropertiesEditionComponent {
    private static final long DELAY = 500L;
    public static final Object FIRE_PROPERTIES_CHANGED_JOB_FAMILY = new Object();
    private List<IPropertiesEditionListener> listeners;
    protected PropertiesEditingSemanticLister semanticAdapter;
    protected EditingDomain liveEditingDomain;
    protected FirePropertiesChangedJob firePropertiesChangedJob;
    protected PropertiesEditingContext editingContext;
    protected String editing_mode;
    protected boolean initializing = false;
    protected String[] parts;

    public void initPart(Object key, int kind, EObject element) {
        this.initPart(key, kind, element, this.editingContext.getResourceSet());
    }

    public String[] partsList() {
        return this.parts;
    }

    public void addListener(IPropertiesEditionListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IPropertiesEditionListener>();
        }
        this.listeners.add(listener);
    }

    public void removeListener(IPropertiesEditionListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public void setLiveEditingDomain(EditingDomain editingDomain) {
        this.liveEditingDomain = editingDomain;
    }

    protected PropertiesEditingSemanticLister initializeSemanticAdapter() {
        return new PropertiesEditingSemanticLister(this){

            public void runUpdateRunnable(Notification msg) {
                StandardPropertiesEditionComponent.this.updatePart(msg);
            }
        };
    }

    public abstract void updatePart(Notification var1);

    private void propagateEvent(IPropertiesEditionEvent event) {
        event.addHolder(this);
        for (IPropertiesEditionListener listener : this.listeners) {
            if (event.hold(listener)) continue;
            listener.firePropertiesChanged(event);
        }
    }

    public void firePropertiesChanged(final IPropertiesEditionEvent event) {
        if (!this.isInitializing() && this.shouldProcess(event)) {
            Diagnostic valueDiagnostic = this.validateValue(event);
            if (valueDiagnostic.getSeverity() != 0 && valueDiagnostic instanceof BasicDiagnostic) {
                this.propagateEvent(new PropertiesValidationEditionEvent(event, valueDiagnostic));
            } else {
                if ("Batch".equals(this.editing_mode)) {
                    this.updateSemanticModel(event);
                } else if ("Live".equals(this.editing_mode)) {
                    this.liveEditingDomain.getCommandStack().execute((Command)new StandardEditingCommand(new EObjectPropertiesEditionContext(this.editingContext, this, this.editingContext.getEObject(), this.editingContext.getAdapterFactory())){

                        public void execute() {
                            StandardPropertiesEditionComponent.this.updateSemanticModel(event);
                            this.description = this.context.getChangeRecorder().endRecording();
                            this.context.getChangeRecorder().dispose();
                        }
                    });
                }
                Diagnostic validate = this.validate();
                this.propagateEvent(new PropertiesValidationEditionEvent(event, validate));
            }
            this.propagateEvent(event);
        }
    }

    public void delayedFirePropertiesChanged(IPropertiesEditionEvent event) {
        if ("Batch".equals(this.editing_mode)) {
            this.firePropertiesChanged(event);
        } else if ("Live".equals(this.editing_mode)) {
            if (this.getFirePropertiesChangedJob().cancel()) {
                this.getFirePropertiesChangedJob().setEvent(event);
                this.getFirePropertiesChangedJob().schedule(500L);
            } else {
                try {
                    this.getFirePropertiesChangedJob().join();
                    this.getFirePropertiesChangedJob().setEvent(event);
                    this.getFirePropertiesChangedJob().schedule();
                }
                catch (InterruptedException interruptedException) {
                    this.getFirePropertiesChangedJob().setEvent(null);
                }
            }
        }
    }

    protected FirePropertiesChangedJob getFirePropertiesChangedJob() {
        if (this.firePropertiesChangedJob == null) {
            this.firePropertiesChangedJob = new FirePropertiesChangedJob("Fire properties changed...");
        }
        return this.firePropertiesChangedJob;
    }

    protected boolean shouldProcess(IPropertiesEditionEvent event) {
        return true;
    }

    public EStructuralFeature associatedFeature(Object editorKey) {
        return null;
    }

    public abstract void updateSemanticModel(IPropertiesEditionEvent var1);

    public boolean mustBeComposed(Object key, int kind) {
        return true;
    }

    public boolean isRequired(Object key, int kind) {
        return false;
    }

    public String getHelpContent(Object key, int kind) {
        return "";
    }

    public Object translatePart(String key) {
        return null;
    }

    public boolean isInitializing() {
        return this.initializing;
    }

    public void setInitializing(boolean initializing) {
        this.initializing = initializing;
    }

    public void setPropertiesEditionPart(Object key, int kind, IPropertiesEditionPart propertiesEditionPart) {
    }

    protected class FirePropertiesChangedJob
    extends Job {
        private IPropertiesEditionEvent fEvent;

        public FirePropertiesChangedJob(String name) {
            super(name);
        }

        public boolean belongsTo(Object family) {
            return family == FIRE_PROPERTIES_CHANGED_JOB_FAMILY;
        }

        public boolean shouldSchedule() {
            return this.fEvent != null;
        }

        public boolean shouldRun() {
            return this.fEvent != null;
        }

        protected void canceling() {
            super.canceling();
            this.fEvent = null;
        }

        public void setEvent(IPropertiesEditionEvent event) {
            this.fEvent = event;
        }

        protected IStatus run(IProgressMonitor monitor) {
            StandardPropertiesEditionComponent.this.deactivate();
            StandardPropertiesEditionComponent.this.firePropertiesChanged(this.fEvent);
            StandardPropertiesEditionComponent.this.activate();
            this.fEvent = null;
            return Status.OK_STATUS;
        }
    }
}

