/*******************************************************************************
 * Copyright (c) 2008, 2010 Obeo.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Obeo - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.eef.runtime.ui.editors.pages.eefviewer;

import org.eclipse.emf.eef.runtime.ui.editors.pages.AbstractEEFMDFormPage;
import org.eclipse.emf.eef.runtime.ui.widgets.masterdetails.AbstractEEFMasterDetailsBlock;
import org.eclipse.emf.eef.runtime.ui.widgets.masterdetails.eefviewer.PropertiesViewerMasterDetailsBlock;
import org.eclipse.ui.forms.editor.FormEditor;

/**
 * @author <a href="mailto:goulwen.lefur@obeo.fr">Goulwen Le Fur</a>
 *
 */
public class EEFPropertiesViewerMDFormPage extends AbstractEEFMDFormPage {

	/**
	 * The page ID
	 */
	public static final String PAGE_ID = "EEF-md-form-page";  //$NON-NLS-1$
	
	private boolean orientable = true;
	private boolean showValidateAction = true;

	/**
	 * @param editor the form editor in which this page will be included
	 * @param pageTitle the title of the page
	 */
	public EEFPropertiesViewerMDFormPage(FormEditor editor, String pageTitle) {
		super(editor, pageTitle);
	}

	/**
	 * @param editor the form editor in which this page will be included
	 * @param pageTitle the title of the page
	 */
	public EEFPropertiesViewerMDFormPage(FormEditor editor, String pageTitle, boolean isOrientable, boolean showValidatePage) {
		super(editor, pageTitle);
		this.orientable = isOrientable;
		this.showValidateAction = showValidatePage;
	}

	/**
	 * {@inheritDoc}
	 * @see org.eclipse.emf.eef.runtime.ui.editors.pages.AbstractEEFMDFormPage#createMasterDetailsBlock()
	 */
	protected AbstractEEFMasterDetailsBlock createMasterDetailsBlock() {
		return new PropertiesViewerMasterDetailsBlock(orientable, showValidateAction);
	}
	
	

}
