/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.ui.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.eef.runtime.impl.filters.business.BusinessViewerFilter;
import org.eclipse.emf.eef.runtime.impl.utils.EEFUtils;
import org.eclipse.emf.eef.runtime.impl.utils.ModelViewerHelper;
import org.eclipse.emf.eef.runtime.impl.utils.PatternTool;
import org.eclipse.emf.eef.runtime.ui.comparator.EMFModelViewerComparator;
import org.eclipse.emf.eef.runtime.ui.providers.EMFListContentProvider;
import org.eclipse.emf.eef.runtime.ui.utils.EEFRuntimeUIMessages;
import org.eclipse.emf.eef.runtime.ui.widgets.SWTUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EMFModelViewerDialog
extends Dialog {
    protected TableViewer elements;
    protected ITableLabelProvider labelProvider;
    protected ILabelProvider labelProviderElement;
    private List<ViewerFilter> filters;
    private List<ViewerFilter> brFilters;
    private Button filteredContent;
    private List<Button> checkButtons;
    private Text fFilter;
    private boolean nullable;
    private boolean isMulti;
    protected Object input;

    public EMFModelViewerDialog(ILabelProvider labelProvider, Object input, List<ViewerFilter> filters, List<ViewerFilter> bpFilters, boolean nullable, boolean isMulti) {
        super(Display.getDefault().getActiveShell());
        this.labelProviderElement = labelProvider;
        this.filters = filters;
        this.brFilters = bpFilters;
        this.input = input;
        this.nullable = nullable;
        this.isMulti = isMulti;
        this.setShellStyle(67696);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        container.setLayout((Layout)layout);
        this.fFilter = new Text(container, 0x800800);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fFilter.setLayoutData((Object)gd);
        this.fFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EMFModelViewerDialog.this.patternChanged((Text)e.widget);
            }
        });
        this.fFilter.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    EMFModelViewerDialog.this.elements.getTable().setFocus();
                }
            }
        });
        this.elements = this.isMulti ? new TableViewer(container, 65538) : new TableViewer(container, 68352);
        GridData gd2 = new GridData(1808);
        this.elements.getTable().setLayoutData((Object)gd2);
        final Table table = this.buildTable();
        if (this.input instanceof Collection) {
            this.elements.setContentProvider((IContentProvider)new ArrayContentProvider());
        } else {
            this.elements.setContentProvider((IContentProvider)new EMFListContentProvider(this.nullable));
        }
        if (this.labelProvider == null) {
            this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)){

                public String getColumnText(Object object, int columnIndex) {
                    if (object instanceof EObject) {
                        if (columnIndex == 0) {
                            String result = ((EObject)object).eClass().getName();
                            if (result == null || result == "") {
                                return "";
                            }
                            if (result.equals("EClass")) {
                                return this.getColumnText(object, 1);
                            }
                            return result;
                        }
                        if (columnIndex == 1) {
                            return EMFModelViewerDialog.this.formatNomFWithLabelProvider(object);
                        }
                    }
                    return "";
                }

                public Image getColumnImage(Object object, int columnIndex) {
                    return null;
                }
            };
        }
        this.elements.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.elements.setComparator((ViewerComparator)new EMFModelViewerComparator(this.labelProvider));
        this.elements.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                EMFModelViewerDialog.this.okPressed();
            }
        });
        if (this.filters != null) {
            for (ViewerFilter filter : this.filters) {
                this.elements.addFilter(filter);
            }
        }
        this.checkButtons = new ArrayList<Button>();
        if (this.brFilters != null && !this.brFilters.isEmpty()) {
            String currentModel = EEFRuntimeUIMessages.EMFModelViewerDialog_current_model_filter_title;
            String referencedModels = EEFRuntimeUIMessages.EMFModelViewerDialog_referenced_models_filter_title;
            String differentContainer = EEFRuntimeUIMessages.EMFModelViewerDialog_different_container_filter_title;
            int i = 0;
            while (i < this.brFilters.size()) {
                String filterName = null;
                if (this.brFilters.get(i) instanceof BusinessViewerFilter) {
                    BusinessViewerFilter viewerFilter = (BusinessViewerFilter)this.brFilters.get(i);
                    this.filteredContent = new Button(container, 32);
                    filterName = viewerFilter.getName();
                    if (filterName != null) {
                        this.filteredContent.setText(filterName);
                    } else {
                        this.filteredContent.setText(EEFRuntimeUIMessages.EMFModelViewerDialog_filter_name);
                    }
                    this.filteredContent.setData((Object)viewerFilter);
                    this.checkButtons.add(this.filteredContent);
                }
                if (!(filterName == null || filterName.equals(currentModel) || filterName.equals(referencedModels) || filterName.equals(differentContainer))) {
                    this.checkButtons.get(i).setSelection(true);
                    this.elements.addFilter((ViewerFilter)this.checkButtons.get(i).getData());
                    int j = 0;
                    while (j < table.getColumns().length) {
                        table.getColumn(j).pack();
                        ++j;
                    }
                }
                ++i;
            }
            for (final Button b : this.checkButtons) {
                b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (!b.getSelection()) {
                            EMFModelViewerDialog.this.elements.removeFilter((ViewerFilter)b.getData());
                        } else {
                            EMFModelViewerDialog.this.elements.addFilter((ViewerFilter)b.getData());
                        }
                        int i = 0;
                        while (i < table.getColumns().length) {
                            table.getColumn(i).pack();
                            ++i;
                        }
                    }
                });
            }
        }
        this.elements.setInput(this.input);
        int i = 0;
        while (i < table.getColumns().length) {
            table.getColumn(i).pack();
            ++i;
        }
        this.setFirstSelection();
        return parent;
    }

    protected Table buildTable() {
        Table table = this.elements.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setSortDirection(1024);
        this.buildColumns(table);
        return table;
    }

    protected void buildColumns(Table table) {
        this.addColumn(table, 0, EEFRuntimeUIMessages.EMFModelViewerDialog_type_column_title);
        this.addColumn(table, 1, EEFRuntimeUIMessages.EMFModelViewerDialog_name_column_title);
    }

    protected void addColumn(final Table table, final int index, String label) {
        final TableColumn myPackage = new TableColumn(table, 0);
        myPackage.setText(label);
        myPackage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((EMFModelViewerComparator)EMFModelViewerDialog.this.elements.getComparator()).doSort(index);
                EMFModelViewerDialog.this.elements.refresh();
                table.setSortColumn(myPackage);
                table.setSortDirection(EMFModelViewerDialog.this.changeSortDirection(table.getSortDirection()));
            }
        });
    }

    private void setFirstSelection() {
        IStructuredSelection selection = ModelViewerHelper.getLastSelection();
        if (selection == null || selection.isEmpty() || this.elements.testFindItem(selection.getFirstElement()) == null) {
            if (this.elements.getElementAt(0) != null) {
                this.elements.setSelection((ISelection)new StructuredSelection(this.elements.getElementAt(0)));
            }
        } else {
            this.elements.setSelection((ISelection)selection);
        }
    }

    private void setSelection() {
        ISelection selection = this.elements.getSelection();
        if ((selection == null || selection.isEmpty()) && this.elements.getElementAt(0) != null) {
            this.elements.setSelection((ISelection)new StructuredSelection(this.elements.getElementAt(0)));
        }
    }

    protected int changeSortDirection(int sortDirection) {
        if (sortDirection == 128) {
            return 1024;
        }
        if (sortDirection == 1024) {
            return 128;
        }
        return 128;
    }

    protected void okPressed() {
        if (this.elements.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)this.elements.getSelection();
            if (selection.getFirstElement() instanceof EObject) {
                this.process(selection);
                ModelViewerHelper.setLastSelection(selection);
            } else if (this.nullable) {
                this.process(null);
                ModelViewerHelper.setLastSelection(null);
            }
        }
        super.okPressed();
    }

    protected Point getInitialSize() {
        int width;
        Point point = super.getInitialSize();
        int n = width = point.x < 800 ? 800 : point.x;
        if (width > SWTUtils.getWidth()) {
            return new Point(SWTUtils.getWidth(), SWTUtils.getHeight());
        }
        return new Point(width, SWTUtils.getHeight());
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.isMulti) {
            shell.setText(EEFRuntimeUIMessages.EMFModelViewerDialog_multi_selection_title);
        } else {
            shell.setText(EEFRuntimeUIMessages.EMFModelViewerDialog_single_element_title);
        }
    }

    public abstract void process(IStructuredSelection var1);

    protected void patternChanged(final Text text) {
        this.elements.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (text.getText() == null || text.getText().equals("")) {
                    return true;
                }
                String libelle = null;
                libelle = EMFModelViewerDialog.this.labelProviderElement != null ? EMFModelViewerDialog.this.formatNomFWithLabelProvider(element) : ModelViewerHelper.getName(element);
                if (EEFUtils.isBundleLoaded("org.eclipse.jdt.core")) {
                    return PatternTool.getPattern(libelle, text.getText());
                }
                return text.getText() == null || text.getText().equals("") || libelle.startsWith(text.getText());
            }
        });
        int i = 0;
        while (i < this.elements.getTable().getColumns().length) {
            this.elements.getTable().getColumn(i).pack();
            ++i;
        }
        this.setSelection();
    }

    protected String formatNomFWithLabelProvider(Object element) {
        if (this.labelProviderElement == null) {
            return "";
        }
        String result = this.labelProviderElement.getText(element);
        if (result == null) {
            return "";
        }
        return result;
    }
}

