/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.views.components;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.eef.runtime.api.component.IPropertiesEditionComponent;
import org.eclipse.emf.eef.runtime.api.notify.IPropertiesEditionEvent;
import org.eclipse.emf.eef.runtime.context.PropertiesEditingContext;
import org.eclipse.emf.eef.runtime.context.impl.EObjectPropertiesEditionContext;
import org.eclipse.emf.eef.runtime.impl.components.SinglePartPropertiesEditingComponent;
import org.eclipse.emf.eef.runtime.impl.utils.EEFConverterUtil;
import org.eclipse.emf.eef.runtime.policies.PropertiesEditingPolicy;
import org.eclipse.emf.eef.runtime.providers.PropertiesEditingProvider;
import org.eclipse.emf.eef.runtime.ui.widgets.ButtonsModeEnum;
import org.eclipse.emf.eef.runtime.ui.widgets.eobjflatcombo.EObjectFlatComboSettings;
import org.eclipse.emf.eef.toolkits.ToolkitsFactory;
import org.eclipse.emf.eef.toolkits.Widget;
import org.eclipse.emf.eef.views.CustomElementEditor;
import org.eclipse.emf.eef.views.ViewsPackage;
import org.eclipse.emf.eef.views.parts.CustomElementEditorPropertiesEditionPart;
import org.eclipse.emf.eef.views.parts.ViewsViewsRepository;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class CustomElementEditorBasePropertiesEditionComponent
extends SinglePartPropertiesEditingComponent {
    public static String BASE_PART = "Base";
    private EObjectFlatComboSettings representationSettings;

    public CustomElementEditorBasePropertiesEditionComponent(PropertiesEditingContext editingContext, EObject customElementEditor, String editing_mode) {
        super(editingContext, customElementEditor, editing_mode);
        this.parts = new String[]{BASE_PART};
        this.repositoryKey = ViewsViewsRepository.class;
        this.partKey = ViewsViewsRepository.CustomElementEditor.class;
    }

    public void initPart(Object key, int kind, EObject elt, ResourceSet allResource) {
        this.setInitializing(true);
        if (this.editingPart != null && key == this.partKey) {
            this.editingPart.setContext(elt, allResource);
            CustomElementEditor customElementEditor = (CustomElementEditor)elt;
            CustomElementEditorPropertiesEditionPart basePart = (CustomElementEditorPropertiesEditionPart)this.editingPart;
            this.representationSettings = new EObjectFlatComboSettings((EObject)customElementEditor, new EReference[]{ViewsPackage.eINSTANCE.getViewElement_Representation()});
            basePart.initRepresentation(this.representationSettings);
            basePart.setRepresentationButtonMode(ButtonsModeEnum.BROWSE);
            if (customElementEditor.getName() != null) {
                basePart.setName(EEFConverterUtil.convertToString((EDataType)EcorePackage.eINSTANCE.getEString(), (Object)customElementEditor.getName()));
            }
            basePart.setReadOnly(customElementEditor.isReadOnly());
            basePart.addFilterToRepresentation(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return element instanceof String && element.equals("") || element instanceof Widget;
                }
            });
        }
        this.setInitializing(false);
    }

    public void updateSemanticModel(IPropertiesEditionEvent event) {
        CustomElementEditor customElementEditor = (CustomElementEditor)this.semanticObject;
        if (ViewsViewsRepository.CustomElementEditor.Properties.representation == event.getAffectedEditor()) {
            if (event.getKind() == 1) {
                this.representationSettings.setToReference((Object)((Widget)event.getNewValue()));
            } else if (event.getKind() == 3) {
                PropertiesEditingPolicy policy;
                Widget eObject = ToolkitsFactory.eINSTANCE.createWidget();
                EObjectPropertiesEditionContext context = new EObjectPropertiesEditionContext(this.editingContext, (IPropertiesEditionComponent)this, (EObject)eObject, this.editingContext.getAdapterFactory());
                PropertiesEditingProvider provider = (PropertiesEditingProvider)this.editingContext.getAdapterFactory().adapt((Notifier)eObject, PropertiesEditingProvider.class);
                if (provider != null && (policy = provider.getPolicy((PropertiesEditingContext)context)) != null) {
                    policy.execute();
                }
                this.representationSettings.setToReference((Object)eObject);
            }
        }
        if (ViewsViewsRepository.CustomElementEditor.Properties.name == event.getAffectedEditor()) {
            customElementEditor.setName((String)EEFConverterUtil.createFromString((EDataType)EcorePackage.eINSTANCE.getEString(), (String)((String)event.getNewValue())));
        }
        if (ViewsViewsRepository.CustomElementEditor.Properties.readOnly == event.getAffectedEditor()) {
            customElementEditor.setReadOnly(((Boolean)event.getNewValue()).booleanValue());
        }
    }

    public void updatePart(Notification msg) {
        if (this.editingPart.isVisible()) {
            CustomElementEditorPropertiesEditionPart basePart = (CustomElementEditorPropertiesEditionPart)this.editingPart;
            if (ViewsPackage.eINSTANCE.getViewElement_Representation().equals(msg.getFeature()) && basePart != null) {
                basePart.setRepresentation((EObject)msg.getNewValue());
            }
            if (ViewsPackage.eINSTANCE.getViewElement_Name().equals(msg.getFeature()) && basePart != null) {
                if (msg.getNewValue() != null) {
                    basePart.setName(EcoreUtil.convertToString((EDataType)EcorePackage.eINSTANCE.getEString(), (Object)msg.getNewValue()));
                } else {
                    basePart.setName("");
                }
            }
            if (ViewsPackage.eINSTANCE.getElementEditor_ReadOnly().equals(msg.getFeature()) && basePart != null) {
                basePart.setReadOnly((Boolean)msg.getNewValue());
            }
        }
    }

    public boolean isRequired(Object key, int kind) {
        return key == ViewsViewsRepository.CustomElementEditor.Properties.name || key == ViewsViewsRepository.CustomElementEditor.Properties.readOnly;
    }

    public String getHelpContent(Object key, int kind) {
        if (key == ViewsViewsRepository.CustomElementEditor.Properties.representation) {
            return "The representation of this part of view";
        }
        if (key == ViewsViewsRepository.CustomElementEditor.Properties.name) {
            return "The element name";
        }
        if (key == ViewsViewsRepository.CustomElementEditor.Properties.readOnly) {
            return "Defines that this editor is in read only mode";
        }
        return super.getHelpContent(key, kind);
    }

    public Diagnostic validateValue(IPropertiesEditionEvent event) {
        Diagnostic ret = Diagnostic.OK_INSTANCE;
        if (event.getNewValue() != null) {
            try {
                Object newValue;
                if (ViewsViewsRepository.CustomElementEditor.Properties.name == event.getAffectedEditor()) {
                    newValue = event.getNewValue();
                    if (newValue instanceof String) {
                        newValue = EcoreUtil.createFromString((EDataType)ViewsPackage.eINSTANCE.getViewElement_Name().getEAttributeType(), (String)((String)newValue));
                    }
                    ret = Diagnostician.INSTANCE.validate(ViewsPackage.eINSTANCE.getViewElement_Name().getEAttributeType(), newValue);
                }
                if (ViewsViewsRepository.CustomElementEditor.Properties.readOnly == event.getAffectedEditor()) {
                    newValue = event.getNewValue();
                    if (newValue instanceof String) {
                        newValue = EcoreUtil.createFromString((EDataType)ViewsPackage.eINSTANCE.getElementEditor_ReadOnly().getEAttributeType(), (String)((String)newValue));
                    }
                    ret = Diagnostician.INSTANCE.validate(ViewsPackage.eINSTANCE.getElementEditor_ReadOnly().getEAttributeType(), newValue);
                }
            }
            catch (IllegalArgumentException iae) {
                ret = BasicDiagnostic.toDiagnostic((Throwable)iae);
            }
            catch (WrappedException we) {
                ret = BasicDiagnostic.toDiagnostic((Throwable)we);
            }
        }
        return ret;
    }
}

