/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.api.widgets;

import com.google.common.base.Objects;
import org.eclipse.eef.EEFDynamicMappingFor;
import org.eclipse.eef.EEFDynamicMappingIf;
import org.eclipse.eef.EEFGroupDescription;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.EEFWidgetStyle;
import org.eclipse.eef.common.api.utils.Util;
import org.eclipse.eef.common.ui.api.EEFWidgetFactory;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.IConsumer;
import org.eclipse.eef.core.api.controllers.IEEFWidgetController;
import org.eclipse.eef.core.api.utils.EvalFactory;
import org.eclipse.eef.ide.ui.api.widgets.AbstractEEFLifecycleManager;
import org.eclipse.eef.ide.ui.internal.EEFIdeUiPlugin;
import org.eclipse.eef.ide.ui.internal.Messages;
import org.eclipse.eef.ide.ui.internal.widgets.EEFStyleHelper;
import org.eclipse.eef.ide.ui.internal.widgets.EEFStyledTextStyleCallback;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractEEFWidgetLifecycleManager
extends AbstractEEFLifecycleManager {
    protected static final int VALIDATION_MARKER_OFFSET = 5;
    protected IVariableManager variableManager;
    protected IInterpreter interpreter;
    protected EditingContextAdapter contextAdapter;
    protected StyledText label;
    protected CLabel help;

    public AbstractEEFWidgetLifecycleManager(IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter contextAdapter) {
        this.variableManager = variableManager;
        this.interpreter = interpreter;
        this.contextAdapter = contextAdapter;
    }

    @Override
    public void createControl(Composite parent, IEEFFormContainer formContainer) {
        boolean needsHelp;
        super.createControl(parent, formContainer);
        EEFWidgetFactory widgetFactory = formContainer.getWidgetFactory();
        Composite composite = parent;
        boolean isInGroup = this.isInGroup();
        boolean needsSeparatedLabel = this.needSeparatedLabel();
        boolean isBlankLabel = Util.isBlank((String)this.getWidgetDescription().getLabelExpression());
        boolean needsLabel = isInGroup || !isBlankLabel && needsSeparatedLabel;
        boolean bl = needsHelp = isInGroup || !Util.isBlank((String)this.getWidgetDescription().getHelpExpression());
        if (!isInGroup && (needsLabel || needsHelp)) {
            composite = widgetFactory.createComposite(parent);
            int numColumn = 1;
            if (needsLabel) {
                ++numColumn;
            }
            if (needsHelp) {
                ++numColumn;
            }
            GridLayout layout = new GridLayout(numColumn, false);
            composite.setLayout((Layout)layout);
            GridData layoutData = new GridData(768);
            layoutData.horizontalSpan = 1;
            composite.setLayoutData((Object)layoutData);
        }
        if (needsLabel) {
            this.label = widgetFactory.createStyledText(composite, 0);
            this.label.setEditable(false);
            this.label.setEnabled(false);
            this.label.setLayoutData((Object)new GridData(this.getLabelVerticalAlignment()));
        }
        if (needsHelp) {
            this.help = widgetFactory.createCLabel(composite, "");
            if (!Util.isBlank((String)this.getWidgetDescription().getHelpExpression())) {
                this.help.setImage(EEFIdeUiPlugin.getPlugin().getImageRegistry().get("icons/full/help.gif"));
                this.help.setLayoutData((Object)new GridData(this.getLabelVerticalAlignment()));
                this.help.setToolTipText("");
            }
        }
        this.createMainControl(composite, formContainer);
    }

    private boolean isInGroup() {
        EObject eContainer = this.getWidgetDescription().eContainer();
        if (eContainer instanceof EEFDynamicMappingIf && eContainer.eContainer() instanceof EEFDynamicMappingFor) {
            EEFDynamicMappingFor dynamicMappingFor = (EEFDynamicMappingFor)eContainer.eContainer();
            return dynamicMappingFor.eContainer() instanceof EEFGroupDescription;
        }
        return eContainer instanceof EEFGroupDescription;
    }

    protected boolean needSeparatedLabel() {
        return true;
    }

    protected int getLabelVerticalAlignment() {
        return 2;
    }

    protected abstract IEEFWidgetController getController();

    protected abstract EEFWidgetDescription getWidgetDescription();

    protected abstract void createMainControl(Composite var1, IEEFFormContainer var2);

    @Override
    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.getController().onNewLabel((IConsumer)new IConsumer<String>(){

            public void apply(String value) {
                if (!(AbstractEEFWidgetLifecycleManager.this.label.isDisposed() || AbstractEEFWidgetLifecycleManager.this.label.getText() != null && AbstractEEFWidgetLifecycleManager.this.label.getText().equals(value))) {
                    AbstractEEFWidgetLifecycleManager.this.label.setText((String)Objects.firstNonNull((Object)value, (Object)""));
                }
                AbstractEEFWidgetLifecycleManager.this.setLabelFontStyle();
            }
        });
        this.getController().onNewHelp((IConsumer)new IConsumer<String>(){

            public void apply(String value) {
                if (!(AbstractEEFWidgetLifecycleManager.this.help == null || AbstractEEFWidgetLifecycleManager.this.help.isDisposed() || AbstractEEFWidgetLifecycleManager.this.help.getText() != null && AbstractEEFWidgetLifecycleManager.this.help.getText().equals(value))) {
                    AbstractEEFWidgetLifecycleManager.this.help.setToolTipText((String)Objects.firstNonNull((Object)value, (Object)""));
                }
            }
        });
    }

    private void setLabelFontStyle() {
        EEFStyleHelper styleHelper = new EEFStyleHelper(this.interpreter, this.variableManager);
        EEFWidgetStyle style = styleHelper.getWidgetStyle(this.getWidgetDescription());
        if (style != null) {
            EEFStyledTextStyleCallback callback = new EEFStyledTextStyleCallback(this.label);
            styleHelper.applyTextStyle(style.getLabelFontNameExpression(), style.getLabelFontSizeExpression(), style.getLabelFontStyleExpression(), this.label.getFont(), style.getLabelBackgroundColorExpression(), style.getLabelForegroundColorExpression(), callback);
        }
    }

    @Override
    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        this.getController().removeNewLabelConsumer();
    }

    @Override
    public void dispose() {
        EEFIdeUiPlugin.getPlugin().debug("AbstractEEFWidgetLifeCycleManager#dispose()");
    }

    protected IStructuredSelection getStructuredSelection(StructuredViewer viewer) throws ClassCastException {
        ISelection selection = viewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        throw new ClassCastException(Messages.AbstractEEFWidgetLifecycleManager_invalidSelectionType);
    }

    protected boolean isEnabled() {
        Boolean result = (Boolean)EvalFactory.of((IInterpreter)this.interpreter, (IVariableManager)this.variableManager).logIfInvalidType(Boolean.class).defaultValue((Object)Boolean.TRUE).evaluate(this.getWidgetDescription().getIsEnabledExpression());
        return result;
    }
}

