/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.internal.widgets;

import java.text.MessageFormat;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.eef.EEFTextDescription;
import org.eclipse.eef.EEFTextStyle;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.EEFWidgetStyle;
import org.eclipse.eef.common.api.utils.Util;
import org.eclipse.eef.common.ui.api.EEFWidgetFactory;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.common.ui.api.SWTUtils;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.EEFControllersFactory;
import org.eclipse.eef.core.api.controllers.IEEFTextController;
import org.eclipse.eef.core.api.controllers.IEEFWidgetController;
import org.eclipse.eef.core.api.utils.EvalFactory;
import org.eclipse.eef.ide.ui.api.widgets.AbstractEEFWidgetLifecycleManager;
import org.eclipse.eef.ide.ui.api.widgets.EEFStyleHelper;
import org.eclipse.eef.ide.ui.internal.EEFIdeUiPlugin;
import org.eclipse.eef.ide.ui.internal.Messages;
import org.eclipse.eef.ide.ui.internal.preferences.EEFPreferences;
import org.eclipse.eef.ide.ui.internal.widgets.EEFStyledTextStyleCallback;
import org.eclipse.eef.ide.ui.internal.widgets.EEFTextMemento;
import org.eclipse.eef.ide.ui.internal.widgets.styles.EEFColor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class EEFTextLifecycleManager
extends AbstractEEFWidgetLifecycleManager {
    private static final int TEXT_AREA_WIDTH_HINT = 300;
    private EEFTextDescription description;
    private StyledText text;
    private IEEFTextController controller;
    private FocusListener focusListener;
    private KeyListener keyListener;
    private EEFWidgetFactory widgetFactory;
    private Color defaultBackgroundColor;
    private ModifyListener modifyListener;
    private AtomicBoolean updateInProgress = new AtomicBoolean(false);
    private AtomicBoolean lockedByOtherInProgress = new AtomicBoolean(false);
    private String referenceValue = "";
    private boolean isDirty;

    public EEFTextLifecycleManager(EEFTextDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter editingContextAdapter) {
        super(variableManager, interpreter, editingContextAdapter);
        this.description = description;
    }

    @Override
    protected void createMainControl(Composite parent, IEEFFormContainer formContainer) {
        this.widgetFactory = formContainer.getWidgetFactory();
        this.defaultBackgroundColor = parent.getBackground();
        int lineCount = this.description.getLineCount();
        if (lineCount > 1) {
            this.text = this.widgetFactory.createStyledText(parent, 834);
            GridData gridData = new GridData(4, 1, true, false);
            gridData.heightHint = lineCount * this.text.getLineHeight();
            gridData.widthHint = 300;
            gridData.horizontalIndent = 5;
            this.text.setLayoutData((Object)gridData);
        } else {
            this.text = this.widgetFactory.createStyledText(parent, 4);
            GridData gridData = new GridData(4, 0x1000000, true, false);
            gridData.horizontalIndent = 5;
            this.text.setLayoutData((Object)gridData);
        }
        this.text.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.widgetFactory.paintBordersFor(parent);
        this.controller = new EEFControllersFactory().createTextController(this.description, this.variableManager, this.interpreter, this.editingContextAdapter);
    }

    @Override
    protected int getLabelVerticalAlignment() {
        if (this.description.getLineCount() > 1) {
            return 2;
        }
        return 4;
    }

    @Override
    protected IEEFWidgetController getController() {
        return this.controller;
    }

    @Override
    protected EEFWidgetDescription getWidgetDescription() {
        return this.description;
    }

    @Override
    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.modifyListener = event -> {
            if (!this.container.isRenderingInProgress() && !this.updateInProgress.get()) {
                this.isDirty = true;
                Object self = this.variableManager.getVariables().get("self");
                String userInput = ((StyledText)event.widget).getText();
                EEFTextMemento memento = new EEFTextMemento(this.description, self, this.referenceValue, userInput);
                memento.store(event.widget);
            }
        };
        this.text.addModifyListener(this.modifyListener);
        this.focusListener = SWTUtils.focusLostAdapter(event -> {
            if (!this.lockedByOtherInProgress.get() && !this.container.isRenderingInProgress() && this.isDirty) {
                this.updateValue(false);
            }
        });
        this.text.addFocusListener(this.focusListener);
        if (this.description.getLineCount() <= 1) {
            this.keyListener = SWTUtils.keyReleasedAdapter(event -> {
                if (event.character == '\r' || event.character == '\n') {
                    this.updateValue(false);
                }
            });
            this.text.addKeyListener(this.keyListener);
        }
        this.controller.onNewValue(value -> {
            if (!this.text.isDisposed()) {
                String newDisplayText = this.computeNewText(value);
                if (this.text.getText() == null || !this.text.getText().equals(newDisplayText)) {
                    this.text.setText(newDisplayText);
                    this.referenceValue = this.text.getText();
                }
                this.setStyle();
                if (!this.text.isEnabled()) {
                    this.text.setEnabled(true);
                }
            }
        });
    }

    private String computeNewText(Object value) {
        EEFTextMemento memento;
        String[] newDisplayText = new String[]{""};
        if (value != null) {
            newDisplayText[0] = Util.firstNonNull((String[])new String[]{value.toString(), newDisplayText[0]});
        }
        if ((memento = EEFTextMemento.of((Widget)this.text)) != null) {
            boolean userHasUncommitedInput;
            boolean resettingToPreviousReferenceValue = Objects.equals(newDisplayText[0], memento.getReferenceValue());
            boolean bl = userHasUncommitedInput = !Objects.equals(newDisplayText[0], memento.getUserInput());
            if (memento.appliesTo(this.description, this.variableManager.getVariables()) && userHasUncommitedInput) {
                if (resettingToPreviousReferenceValue) {
                    newDisplayText[0] = memento.getUserInput();
                } else if (!Objects.equals(memento.getUserInput(), newDisplayText[0])) {
                    newDisplayText[0] = this.resolveEditionConflict(this.text.getShell(), memento.getReferenceValue(), memento.getUserInput(), newDisplayText[0]);
                }
            }
            EEFTextMemento.remove((Widget)this.text);
        }
        return newDisplayText[0];
    }

    protected String resolveEditionConflict(Shell shell, String originalValue, String localEditedVersion, String newValueFromModel) {
        String result;
        switch (EEFPreferences.getTextConflictResolutionMode()) {
            case USE_LOCAL_VERSION: {
                result = localEditedVersion;
                break;
            }
            case USE_MODEL_VERSION: {
                result = newValueFromModel;
                break;
            }
            case ASK_USER: {
                result = this.askUserToResolveConflict(shell, originalValue, localEditedVersion, newValueFromModel);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return result;
    }

    protected String askUserToResolveConflict(Shell shell, String originalValue, String localEditedVersion, String newValueFromModel) {
        String[] result = new String[]{localEditedVersion};
        String[] choices = new String[]{Messages.EEFTextLifecycleManager_conflictDialog_choiceNewModelValue, Messages.EEFTextLifecycleManager_conflictDialog_choiceLocalEditedValue};
        shell.getDisplay().syncExec(() -> {
            String title = Messages.EEFTextLifecycleManager_conflictDialog_title;
            String message = MessageFormat.format(Messages.EEFTextLifecycleManager_conflictDialog_message, newValueFromModel, localEditedVersion);
            Image img = shell.getDisplay().getSystemImage(4);
            MessageDialog dialog = new MessageDialog(shell, title, img, message, 3, 0, choices);
            switch (dialog.open()) {
                case 0: {
                    stringArray2[0] = newValueFromModel;
                    break;
                }
                case 1: {
                    stringArray2[0] = localEditedVersion;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        });
        return result[0];
    }

    private void updateValue(boolean force) {
        boolean shouldUpdateWhileRendering;
        boolean bl = shouldUpdateWhileRendering = !this.container.isRenderingInProgress() || force;
        if (!this.text.isDisposed() && this.isDirty && shouldUpdateWhileRendering && this.updateInProgress.compareAndSet(false, true)) {
            try {
                IStatus result = this.controller.updateValue(this.text.getText());
                if (result != null && result.getSeverity() == 4) {
                    EEFIdeUiPlugin.INSTANCE.log(result);
                    this.text.setText(this.referenceValue);
                } else {
                    this.referenceValue = this.text.getText();
                    this.refresh();
                }
                this.isDirty = false;
                EEFTextMemento.remove((Widget)this.text);
                this.setStyle();
            }
            finally {
                this.updateInProgress.set(false);
            }
        }
    }

    private void setStyle() {
        EEFStyleHelper styleHelper = new EEFStyleHelper(this.interpreter, this.variableManager);
        EEFWidgetStyle widgetStyle = styleHelper.getWidgetStyle((EEFWidgetDescription)this.description);
        if (widgetStyle instanceof EEFTextStyle) {
            EEFTextStyle textStyle = (EEFTextStyle)widgetStyle;
            Font defaultFont = this.text.getShell().getFont();
            EEFStyledTextStyleCallback callback = new EEFStyledTextStyleCallback(this.text);
            styleHelper.applyTextStyle(textStyle.getFontNameExpression(), textStyle.getFontSizeExpression(), textStyle.getFontStyleExpression(), defaultFont, textStyle.getBackgroundColorExpression(), textStyle.getForegroundColorExpression(), callback);
        }
    }

    @Override
    protected Control getValidationControl() {
        return this.text;
    }

    @Override
    public void aboutToBeHidden() {
        if (this.isDirty) {
            this.updateValue(true);
        }
        super.aboutToBeHidden();
        if (!this.text.isDisposed()) {
            this.text.removeFocusListener(this.focusListener);
        }
        this.controller.removeNewValueConsumer();
        if (!this.text.isDisposed()) {
            this.text.removeModifyListener(this.modifyListener);
        }
        if (!this.text.isDisposed() && this.description.getLineCount() <= 1) {
            this.text.removeKeyListener(this.keyListener);
        }
    }

    @Override
    protected void lockedByOther() {
        this.lockedByOtherInProgress.set(true);
        try {
            String textFromModel = this.computeTextFromModel();
            EEFTextMemento memento = EEFTextMemento.of((Widget)this.text);
            if (memento != null) {
                boolean userHasUncommitedInput;
                boolean bl = userHasUncommitedInput = !Objects.equals(textFromModel, memento.getUserInput());
                if (memento.appliesTo(this.description, this.variableManager.getVariables()) && userHasUncommitedInput) {
                    this.notifyTextLossOnLock(memento.getUserInput(), textFromModel);
                    this.text.setText(textFromModel);
                }
                EEFTextMemento.remove((Widget)this.text);
            }
            super.lockedByOther();
        }
        finally {
            this.lockedByOtherInProgress.set(false);
        }
    }

    protected void notifyTextLossOnLock(String userInput, String textFromModel) {
        Shell shell = this.text.getShell();
        if (MessageDialog.openQuestion((Shell)shell, (String)Messages.EEFTextLifecycleManager_textLossByLocking_title, (String)MessageFormat.format(Messages.EEFTextLifecycleManager_textLossByLocking_title, userInput))) {
            Clipboard clipboard = new Clipboard(shell.getDisplay());
            clipboard.setContents(new Object[]{userInput}, new Transfer[]{TextTransfer.getInstance()});
            clipboard.dispose();
        }
    }

    private String computeTextFromModel() {
        String valueExpression = this.description.getValueExpression();
        Object result = EvalFactory.of((IInterpreter)this.interpreter, (IVariableManager)this.variableManager).evaluate(valueExpression);
        return Optional.ofNullable(result).filter(String.class::isInstance).map(String.class::cast).orElse("");
    }

    @Override
    protected void setEnabled(boolean isEnabled) {
        if (!this.text.isDisposed()) {
            this.text.setEnabled(isEnabled);
            this.text.setEditable(isEnabled);
            this.text.setBackground(this.getBackgroundColor(isEnabled));
        }
    }

    private Color getBackgroundColor(boolean isEnabled) {
        Color color = this.defaultBackgroundColor;
        if (!isEnabled) {
            color = this.widgetFactory.getColors().getInactiveBackground();
        } else {
            EEFTextStyle style;
            String backgroundColorCode;
            EEFWidgetStyle widgetStyle = new EEFStyleHelper(this.interpreter, this.variableManager).getWidgetStyle((EEFWidgetDescription)this.description);
            if (widgetStyle instanceof EEFTextStyle && !Util.isBlank((String)(backgroundColorCode = (style = (EEFTextStyle)widgetStyle).getBackgroundColorExpression()))) {
                EEFColor backgroundColor = new EEFColor(backgroundColorCode);
                color = backgroundColor.getColor();
            }
        }
        return color;
    }

    public static enum ConflictResolutionMode {
        USE_LOCAL_VERSION,
        USE_MODEL_VERSION,
        ASK_USER;

    }
}

