/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfindex;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.emfindex.IndexAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeIndexAdapter
extends EContentAdapter {
    private List<IndexAdapter> indexAdapters = new ArrayList<IndexAdapter>();
    private boolean isActive = true;

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (this.isActive) {
            for (IndexAdapter cachedScope : this.indexAdapters) {
                cachedScope.notifyChanged(notification);
            }
        }
    }

    public boolean addIndexAdapter(IndexAdapter adapter) {
        Object existingCache = this.findIndexAdapter(adapter.getClass());
        if (existingCache != null) {
            return false;
        }
        this.indexAdapters.add(adapter);
        return true;
    }

    public boolean removeIndexAdapter(IndexAdapter adapter) {
        return this.indexAdapters.remove(adapter);
    }

    public <T extends IndexAdapter> T findIndexAdapter(Class<T> adapterClass) {
        for (IndexAdapter registeredCaches : this.indexAdapters) {
            if (!registeredCaches.getClass().equals(adapterClass)) continue;
            return (T)registeredCaches;
        }
        return null;
    }

    public void clear() {
        for (IndexAdapter indexCache : this.indexAdapters) {
            indexCache.clear();
        }
    }
}

