/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfindex;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.emfindex.EmfIndexModule;
import org.eclipse.emf.emfindex.EquinoxEmfIndexModule;
import org.eclipse.emf.emfindex.Index;
import org.eclipse.emf.emfindex.store.UpdateableIndex;
import org.osgi.framework.BundleContext;

public class EmfIndexPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.emf.index";
    private static EmfIndexPlugin plugin;
    private Injector injector;
    @Inject
    private UpdateableIndex index;

    public static EmfIndexPlugin getDefault() {
        return plugin;
    }

    public Index getIndex() {
        return this.index;
    }

    public void start(BundleContext context) throws Exception {
        plugin = this;
        super.start(context);
        this.getInjector().injectMembers((Object)this);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static void logError(String message, Throwable t) {
        EmfIndexPlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, message, t));
    }

    public static void logError(String message) {
        EmfIndexPlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, message));
    }

    public static URI getBaseDirectoryURI() {
        return URI.createFileURI((String)EmfIndexPlugin.getBaseDirectory().getAbsolutePath());
    }

    public static File getBaseDirectory() {
        if (plugin != null) {
            return plugin.getStateLocation().toFile();
        }
        File file = new File("emfIndex");
        file.mkdir();
        return file;
    }

    public synchronized Injector getInjector() {
        if (this.injector == null) {
            if (EMFPlugin.IS_ECLIPSE_RUNNING) {
                try {
                    this.injector = Guice.createInjector((Module[])new Module[]{new EquinoxEmfIndexModule()});
                }
                catch (Exception e) {
                    this.getLog().log((IStatus)new Status(4, this.getBundle().getSymbolicName(), e.getMessage(), (Throwable)e));
                }
            } else {
                try {
                    this.injector = Guice.createInjector((Module[])new Module[]{new EmfIndexModule()});
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return this.injector;
    }
}

