/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfindex.store;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.emfindex.EObjectDescriptor;
import org.eclipse.emf.emfindex.EReferenceDescriptor;
import org.eclipse.emf.emfindex.ResourceDescriptor;
import org.eclipse.emf.emfindex.store.DescriptorFactory;
import org.eclipse.emf.emfindex.store.IndexUpdater;
import org.eclipse.emf.emfindex.store.ResourceIndexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceIndexerImpl
implements ResourceIndexer {
    @Override
    public void resourceChanged(URI resourceURI, IndexUpdater updater) {
        Resource resource = this.loadResource(resourceURI);
        this.resourceChanged(resource, updater);
    }

    @Override
    public void resourceDeleted(URI resourceURI, IndexUpdater updater) {
        updater.deleteResourceDescriptor(resourceURI);
    }

    protected Resource loadResource(URI resourceURI) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        return resourceSet.getResource(resourceURI, true);
    }

    public void resourceChanged(Resource resource, IndexUpdater updater) {
        if (resource != null) {
            DescriptorFactory descriptorFactory = updater.getDescriptorFactory();
            URIConverter uriConverter = this.getURIConverter(resource);
            ResourceDescriptor resourceDescriptor = this.createResourceDescriptor(resource, descriptorFactory, uriConverter);
            HashMap<EObject, EObjectDescriptor> eObject2DescriptorCache = new HashMap<EObject, EObjectDescriptor>();
            this.createEObjectDescriptors(resourceDescriptor, resource, (EList<EObject>)resource.getContents(), uriConverter, descriptorFactory, eObject2DescriptorCache);
            this.createEReferenceDescriptors(resourceDescriptor, resource, (EList<EObject>)resource.getContents(), uriConverter, descriptorFactory, eObject2DescriptorCache);
            updater.update(resourceDescriptor);
        }
    }

    protected void createEObjectDescriptors(ResourceDescriptor containerDescriptor, Resource resource, EList<EObject> contents, URIConverter uriConverter, DescriptorFactory descriptorFactory, Map<EObject, EObjectDescriptor> eObject2DescriptorCache) {
        for (EObject eObject : contents) {
            if (this.isIndexElement(eObject, resource) && eObject.eResource() == resource) {
                EObjectDescriptor eObjectDescriptor = this.createEObjectDescriptor(eObject, resource, containerDescriptor, descriptorFactory);
                eObject2DescriptorCache.put(eObject, eObjectDescriptor);
            }
            if (!this.isIndexChildren(eObject, resource)) continue;
            this.createEObjectDescriptors(containerDescriptor, resource, (EList<EObject>)eObject.eContents(), uriConverter, descriptorFactory, eObject2DescriptorCache);
        }
    }

    protected void createEReferenceDescriptors(ResourceDescriptor containerDescriptor, Resource resource, EList<EObject> contents, URIConverter uriConverter, DescriptorFactory descriptorFactory, Map<EObject, EObjectDescriptor> eObject2DescriptorCache) {
        for (EObject eObject : contents) {
            String sourceFragment = resource.getURIFragment(eObject);
            if (this.isIndexReferences(eObject, resource)) {
                for (EReference eReference : eObject.eClass().getEAllReferences()) {
                    if (!this.isIndexReference(eReference, eObject)) continue;
                    if (eReference.isMany()) {
                        List targets = (List)eObject.eGet((EStructuralFeature)eReference, false);
                        int index = 0;
                        while (index < targets.size()) {
                            Object target = targets.get(index);
                            this.createEReferenceDescriptor(sourceFragment, target, eReference, containerDescriptor, descriptorFactory, uriConverter, eObject2DescriptorCache);
                            ++index;
                        }
                        continue;
                    }
                    Object target = eObject.eGet((EStructuralFeature)eReference, false);
                    this.createEReferenceDescriptor(sourceFragment, target, eReference, containerDescriptor, descriptorFactory, uriConverter, eObject2DescriptorCache);
                }
            }
            if (!this.isIndexChildren(eObject, resource)) continue;
            this.createEReferenceDescriptors(containerDescriptor, resource, (EList<EObject>)eObject.eContents(), uriConverter, descriptorFactory, eObject2DescriptorCache);
        }
    }

    protected URIConverter getURIConverter(Resource resource) {
        ResourceSet resourceSet = resource.getResourceSet();
        return resourceSet != null ? resourceSet.getURIConverter() : URIConverter.INSTANCE;
    }

    protected ResourceDescriptor createResourceDescriptor(Resource resource, DescriptorFactory descriptorFactory, URIConverter uriConverter) {
        ResourceDescriptor resourceDescriptor = descriptorFactory.createResourceDescriptor(null, uriConverter.normalize(resource.getURI()), System.currentTimeMillis());
        this.addResourceUserData(resource, resourceDescriptor, descriptorFactory);
        return resourceDescriptor;
    }

    protected EObjectDescriptor createEObjectDescriptor(EObject eObject, Resource resource, ResourceDescriptor containerDescriptor, DescriptorFactory descriptorFactory) {
        EObjectDescriptor eObjectDescriptor = descriptorFactory.createEObjectDescriptor(containerDescriptor, this.getEObjectName(eObject), resource.getURIFragment(eObject), eObject.eClass());
        this.addEObjectUserData(eObject, eObjectDescriptor, descriptorFactory);
        return eObjectDescriptor;
    }

    protected EReferenceDescriptor createEReferenceDescriptor(String sourceFragment, Object target, EReference eReference, ResourceDescriptor containerDescriptor, DescriptorFactory descriptorFactory, URIConverter uriConverter, Map<EObject, EObjectDescriptor> eObject2DescriptorCache) {
        if (target instanceof EObject) {
            EObjectDescriptor targetEObjectDescriptor = eObject2DescriptorCache.get(target);
            if (targetEObjectDescriptor != null) {
                return descriptorFactory.createEReferenceDescriptor(containerDescriptor, sourceFragment, targetEObjectDescriptor, eReference);
            }
            URI targetFragmentURI = uriConverter.normalize(EcoreUtil.getURI((EObject)((EObject)target)));
            return descriptorFactory.createEReferenceDescriptor(containerDescriptor, sourceFragment, targetFragmentURI, eReference);
        }
        return null;
    }

    protected void addResourceUserData(Resource resource, ResourceDescriptor resourceDescriptor, DescriptorFactory descriptorFactory) {
    }

    protected void addEObjectUserData(EObject eObject, EObjectDescriptor eObjectDescriptor, DescriptorFactory descriptorFactory) {
    }

    protected String getEObjectName(EObject eObject) {
        EStructuralFeature nameFeature = eObject.eClass().getEStructuralFeature("name");
        if (nameFeature != null && nameFeature.getEType() instanceof EDataType) {
            if (!nameFeature.isMany()) {
                Object nameFeatureValue = eObject.eGet(nameFeature);
                return nameFeatureValue == null ? null : nameFeatureValue.toString();
            }
            List names = (List)eObject.eGet(nameFeature);
            StringBuilder b = new StringBuilder();
            Iterator nameIter = names.iterator();
            while (nameIter.hasNext()) {
                b.append(nameIter.next().toString());
            }
            return b.toString();
        }
        return null;
    }

    protected boolean isIndexElement(EObject eObject, Resource resource) {
        return eObject.eResource() == resource;
    }

    protected boolean isIndexReferences(EObject eObject, Resource resource) {
        return true;
    }

    protected boolean isIndexReference(EReference eReference, EObject element) {
        return !eReference.isContainment() && !eReference.isDerived() && element.eIsSet((EStructuralFeature)eReference);
    }

    protected boolean isIndexChildren(EObject eObject, Resource resource) {
        return true;
    }
}

