/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfindex.ui;

import com.google.inject.Injector;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExecutableExtensionFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.emfindex.ui.EmfIndexUIPlugin;
import org.osgi.framework.Bundle;

public class GuiceExecutableExtensionFactory
implements IExecutableExtensionFactory,
IExecutableExtension {
    private String clazzName;
    private IConfigurationElement config;
    private Object data;
    private String propertyName;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof String) {
            this.clazzName = (String)data;
        } else if (data instanceof Map) {
            this.clazzName = (String)((Map)data).get("actualClass");
        }
        if (this.clazzName == null) {
            throw new IllegalArgumentException("couldn't handle passed data : " + data);
        }
        this.config = config;
        this.data = data;
        this.propertyName = propertyName;
    }

    public Object create() throws CoreException {
        EmfIndexUIPlugin instance = EmfIndexUIPlugin.getDefault();
        if (instance == null) {
            throw new IllegalStateException("The bundle has not yet been activated. Make sure the Manifest.MF contains 'Bundle-ActivationPolicy: lazy'.");
        }
        Bundle bundle = instance.getBundle();
        try {
            Class clazz = bundle.loadClass(this.clazzName);
            Injector injector = instance.getInjector();
            Object result = injector.getInstance(clazz);
            if (result instanceof IExecutableExtension) {
                ((IExecutableExtension)result).setInitializationData(this.config, this.propertyName, this.data);
            }
            return result;
        }
        catch (Exception e) {
            Status error = new Status(4, "org.eclipse.emf.emfindex.ui", 0, e.getMessage(), (Throwable)e);
            EmfIndexUIPlugin.getDefault().getLog().log((IStatus)error);
            throw new CoreException((IStatus)error);
        }
    }
}

