/*******************************************************************************
 * Copyright (c) 2009 itemis AG (http://www.itemis.eu) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package org.eclipse.emf.emfindex.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.emfindex.store.IndexUpdater;
import org.eclipse.emf.emfindex.store.ResourceIndexer;
import org.eclipse.emf.emfindex.store.ResourceIndexerRegistryImpl;

/**
 * @author koehnlein
 * @author Sven Efftinge
 */
public class ResourceIndexerRegistryEquinoxImpl extends
		ResourceIndexerRegistryImpl {

	public static final String EXTENSION_POINT_ID = "org.eclipse.emf.emfindex.resourceIndexer";
	public static final String CLASS_ATTRIBUTE_NAME = "class";
	public static final String FILE_EXTENSION_ATTRIBUTE_NAME = "fileExtension";

	public ResourceIndexerRegistryEquinoxImpl() {
		IConfigurationElement[] configurationElementsFor = Platform
				.getExtensionRegistry().getConfigurationElementsFor(
						EXTENSION_POINT_ID);
		for (IConfigurationElement configurationElement : configurationElementsFor) {
			String fileExtension = configurationElement
					.getAttribute(FILE_EXTENSION_ATTRIBUTE_NAME);
			this.addResourceIndexer(fileExtension,
					new LazyDelegatingResourceIndexer(configurationElement));
		}
	}

	private static class LazyDelegatingResourceIndexer implements
			ResourceIndexer {

		private final IConfigurationElement configurationElement;

		public LazyDelegatingResourceIndexer(
				IConfigurationElement configurationElement) {
			this.configurationElement = configurationElement;
		}

		private ResourceIndexer indexer = null;

		protected synchronized ResourceIndexer getIndexer() {
			if (indexer == null) {
				indexer = createIndexer();
			}
			return indexer;
		}

		public void resourceChanged(URI resourceURI, IndexUpdater updater) {
			getIndexer().resourceChanged(resourceURI, updater);
		}

		public void resourceDeleted(URI resourceURI, IndexUpdater updater) {
			getIndexer().resourceDeleted(resourceURI, updater);
		}

		protected ResourceIndexer createIndexer() {
			try {
				return (ResourceIndexer) configurationElement
						.createExecutableExtension(CLASS_ATTRIBUTE_NAME);
			} catch (CoreException e) {
				throw new WrappedException(e);
			}
		}
	}

}
