/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfindex.query;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.emfindex.Index;
import org.eclipse.emf.emfindex.Logger;
import org.eclipse.emf.emfindex.query.Query;
import org.eclipse.emf.emfindex.query.QueryResult;
import org.eclipse.emf.emfindex.query.spi.QueryExecutorStrategy;
import org.eclipse.emf.emfindex.query.spi.QueryExecutorWithStrategies;
import org.eclipse.emf.emfindex.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class QueryExecutorImpl
implements QueryExecutorWithStrategies {
    private static final String CAN_EXECUTE_METHOD_NAME = "canExecute";
    private List<QueryExecutorStrategy<?, ?, ?>> strategies = new ArrayList();
    @Inject
    private Logger logger;
    private Index index;

    @Inject
    public QueryExecutorImpl(Index index) {
        this.index = index;
    }

    public <DescriptorType, QueryType extends Query<DescriptorType>, IndexType> QueryResult<DescriptorType> execute(QueryType query) {
        QueryExecutorStrategy<DescriptorType, QueryType, Index> strategy = this.findMatchingStrategy(query, this.index);
        if (strategy != null) {
            return strategy.execute(query, this.index);
        }
        throw new IllegalStateException(StringUtils.concat("No strategy for query: ", query, "   index: ", this.index));
    }

    private <DescriptorType, QueryType extends Query<DescriptorType>, IndexType> QueryExecutorStrategy<DescriptorType, QueryType, IndexType> findMatchingStrategy(Query<DescriptorType> query, IndexType index) {
        for (QueryExecutorStrategy<?, ?, ?> strategy : this.strategies) {
            Method[] methods;
            Class<?> strategyClass = strategy.getClass();
            Method[] methodArray = methods = strategyClass.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (!Modifier.isAbstract(method.getModifiers()) && method.getName().equals(CAN_EXECUTE_METHOD_NAME)) {
                    try {
                        Boolean canExecute;
                        Type[] parameterTypes = method.getGenericParameterTypes();
                        if (parameterTypes.length == 2 && this.isMatchingParameterType(parameterTypes[0], query.getClass()) && this.isMatchingParameterType(parameterTypes[1], index.getClass()) && method.getReturnType().equals(Boolean.TYPE) && (canExecute = (Boolean)method.invoke(strategy, query, index)).booleanValue()) {
                            return strategy;
                        }
                    }
                    catch (Exception e) {
                        this.logger.logError("Error resolving QueryExecutorStrategy", e);
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    private boolean isMatchingParameterType(Type declaredType, Class<?> argumentType) {
        Class declaredClass;
        if (declaredType instanceof Class && (declaredClass = (Class)declaredType).getTypeParameters().length == 0) {
            return declaredClass.isAssignableFrom(argumentType);
        }
        return false;
    }

    @Override
    public void addQueryExecutorStrategy(QueryExecutorStrategy<?, ? extends Query<?>, ? extends Index> queryExecutorStrategy, int priority) {
        this.strategies.add(queryExecutorStrategy);
        queryExecutorStrategy.init(this);
    }

    @Override
    public void removeQueryExecutorStrategy(QueryExecutorStrategy<?, ? extends Query<?>, ? extends Index> queryExecutorStrategy, int priority) {
        this.strategies.remove(queryExecutorStrategy);
    }

    public Index getIndex() {
        return this.index;
    }
}

