/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfindex.query;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.emfindex.EReferenceDescriptor;
import org.eclipse.emf.emfindex.EReferenceDescriptorIterator;
import org.eclipse.emf.emfindex.IndexAdapter;
import org.eclipse.emf.emfindex.ResourceDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferencesToResourceCache
implements IndexAdapter {
    private Multimap<URI, EReferenceDescriptor> cache = new HashMultimap();

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public void notifyChanged(Notification notification) {
        Object newValue;
        Object oldValue = notification.getOldValue();
        int eventType = notification.getEventType();
        if (oldValue instanceof ResourceDescriptor) {
            ResourceDescriptor resourceDescriptor = (ResourceDescriptor)oldValue;
            if (eventType == 4 || eventType == 1) {
                EReferenceDescriptorIterator eReferenceDescriptorIterator = new EReferenceDescriptorIterator(resourceDescriptor);
                while (eReferenceDescriptorIterator.hasNext()) {
                    EReferenceDescriptor next = (EReferenceDescriptor)eReferenceDescriptorIterator.next();
                    URI targetResourceURI = next.getTargetResourceURI();
                    this.cache.remove((Object)targetResourceURI, (Object)next);
                }
            }
        }
        if ((newValue = notification.getNewValue()) instanceof ResourceDescriptor) {
            ResourceDescriptor resourceDescriptor = (ResourceDescriptor)newValue;
            if (eventType == 3 || eventType == 1) {
                EReferenceDescriptorIterator eReferenceDescriptorIterator = new EReferenceDescriptorIterator(resourceDescriptor);
                while (eReferenceDescriptorIterator.hasNext()) {
                    EReferenceDescriptor next = (EReferenceDescriptor)eReferenceDescriptorIterator.next();
                    URI targetResourceURI = next.getTargetResourceURI();
                    this.cache.put((Object)targetResourceURI, (Object)next);
                }
            }
        }
    }

    public Iterable<EReferenceDescriptor> getReferencesTargetingResource(URI resourceURI) {
        return this.cache.get((Object)resourceURI);
    }
}

